/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpspec.run;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.commandLine.PhpCommandSettings;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.run.PhpExecutionUtil;
import com.jetbrains.php.run.PhpRunUtil;
import com.jetbrains.php.testFramework.run.PhpTestRunConfigurationHandler;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpSpecRunConfigurationHandler
implements PhpTestRunConfigurationHandler {
    private static final Logger LOG = Logger.getInstance(PhpSpecRunConfigurationHandler.class);
    private static final String PHPSPEC_HELPER_ENV_EXE = "IDE_PHPSPEC_EXE";
    private static final PhpSpecRunConfigurationHandler ourInstance = new PhpSpecRunConfigurationHandler();

    public static PhpSpecRunConfigurationHandler getInstance() {
        return ourInstance;
    }

    @NotNull
    public String getConfigFileOption() {
        if ("-c" == null) {
            PhpSpecRunConfigurationHandler.$$$reportNull$$$0(0);
        }
        return "-c";
    }

    public void prepareCommand(@NotNull Project project, @NotNull PhpCommandSettings command, @NotNull String exe, @Nullable String version) throws ExecutionException {
        String scriptFile;
        if (project == null) {
            PhpSpecRunConfigurationHandler.$$$reportNull$$$0(1);
        }
        if (command == null) {
            PhpSpecRunConfigurationHandler.$$$reportNull$$$0(2);
        }
        if (exe == null) {
            PhpSpecRunConfigurationHandler.$$$reportNull$$$0(3);
        }
        if (StringUtil.isEmpty((String)(scriptFile = PhpExecutionUtil.loadHelperScriptAndGetText((Project)project, (String)"phpspec.php", (PhpCommandSettings)command, PhpSpecRunConfigurationHandler.class)))) {
            String message = PhpBundle.message((String)"php.interpreter.base.configuration.interpreter.is.invalid", (Object[])new Object[]{"PHPSpec tests", "PHPSpec"});
            throw new ExecutionException(message);
        }
        command.setScript(scriptFile, false);
        command.addArgument("run");
        command.addArgument("--format=phpstorm");
        command.addArgument("--no-ansi");
        command.addArgument("--no-interaction");
        command.addEnv(PHPSPEC_HELPER_ENV_EXE, exe);
    }

    public void runType(@NotNull Project project, @NotNull PhpCommandSettings command, @NotNull String type, @NotNull String workingDirectory) throws ExecutionException {
        if (project == null) {
            PhpSpecRunConfigurationHandler.$$$reportNull$$$0(4);
        }
        if (command == null) {
            PhpSpecRunConfigurationHandler.$$$reportNull$$$0(5);
        }
        if (type == null) {
            PhpSpecRunConfigurationHandler.$$$reportNull$$$0(6);
        }
        if (workingDirectory == null) {
            PhpSpecRunConfigurationHandler.$$$reportNull$$$0(7);
        }
        throw new ExecutionException(PhpBundle.message((String)"php.test.framework.validation.run.configuration.unsupported.type", (Object[])new Object[]{type}));
    }

    public void runDirectory(@NotNull Project project, @NotNull PhpCommandSettings command, @NotNull String directory, @NotNull String workingDirectory) {
        if (project == null) {
            PhpSpecRunConfigurationHandler.$$$reportNull$$$0(8);
        }
        if (command == null) {
            PhpSpecRunConfigurationHandler.$$$reportNull$$$0(9);
        }
        if (directory == null) {
            PhpSpecRunConfigurationHandler.$$$reportNull$$$0(10);
        }
        if (workingDirectory == null) {
            PhpSpecRunConfigurationHandler.$$$reportNull$$$0(11);
        }
        command.addRelativePathArgument(directory, workingDirectory);
    }

    public void runFile(@NotNull Project project, @NotNull PhpCommandSettings command, @NotNull String file, @NotNull String workingDirectory) {
        if (project == null) {
            PhpSpecRunConfigurationHandler.$$$reportNull$$$0(12);
        }
        if (command == null) {
            PhpSpecRunConfigurationHandler.$$$reportNull$$$0(13);
        }
        if (file == null) {
            PhpSpecRunConfigurationHandler.$$$reportNull$$$0(14);
        }
        if (workingDirectory == null) {
            PhpSpecRunConfigurationHandler.$$$reportNull$$$0(15);
        }
        command.addRelativePathArgument(file, workingDirectory);
    }

    public void runMethod(@NotNull Project project, @NotNull PhpCommandSettings command, @NotNull String filePath, @NotNull String methodName, @NotNull String workingDirectory) {
        Method specification;
        PsiFile file;
        if (project == null) {
            PhpSpecRunConfigurationHandler.$$$reportNull$$$0(16);
        }
        if (command == null) {
            PhpSpecRunConfigurationHandler.$$$reportNull$$$0(17);
        }
        if (filePath == null) {
            PhpSpecRunConfigurationHandler.$$$reportNull$$$0(18);
        }
        if (methodName == null) {
            PhpSpecRunConfigurationHandler.$$$reportNull$$$0(19);
        }
        if (workingDirectory == null) {
            PhpSpecRunConfigurationHandler.$$$reportNull$$$0(20);
        }
        if ((file = PhpRunUtil.findPsiFile((Project)project, (String)filePath)) instanceof PhpFile && (specification = PhpSpecRunConfigurationHandler.getSpecification((PhpFile)file, methodName)) != null) {
            int line;
            int offset = specification.getTextRange().getStartOffset();
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
            int n = line = document == null ? -1 : document.getLineNumber(offset) + 1;
            if (line < 0) {
                LOG.warn("Can not find method '" + methodName + "' in " + workingDirectory + File.separator + filePath);
            }
            command.addRelativePathArgument(filePath, workingDirectory, ":" + line);
        }
    }

    @Nullable
    private static Method getSpecification(@NotNull PhpFile file, @Nullable String name) {
        if (file == null) {
            PhpSpecRunConfigurationHandler.$$$reportNull$$$0(21);
        }
        if (StringUtil.isEmptyOrSpaces((String)name)) {
            return null;
        }
        return PhpPsiUtil.findAllClasses((PhpFile)file).stream().map(c -> c.findMethodByName((CharSequence)name)).filter(m -> m != null).findAny().orElse(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phpspec/run/PhpSpecRunConfigurationHandler";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exe";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: 
            case 11: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 14: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigFileOption";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phpspec/run/PhpSpecRunConfigurationHandler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "prepareCommand";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "runType";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "runDirectory";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "runFile";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "runMethod";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getSpecification";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

