/*
 * Decompiled with CFR 0.152.
 */
package org.scalasbt.ipcsocket;

import com.sun.jna.Memory;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import org.scalasbt.ipcsocket.Win32NamedPipeLibrary;

public class Win32NamedPipeSocket
extends Socket {
    private static final Win32NamedPipeLibrary API = Win32NamedPipeLibrary.INSTANCE;
    static final boolean DEFAULT_REQUIRE_STRICT_LENGTH = false;
    private final WinNT.HANDLE handle;
    private final CloseCallback closeCallback;
    private final boolean requireStrictLength;
    private final InputStream is;
    private final OutputStream os;
    private final WinNT.HANDLE readerWaitable;
    private final WinNT.HANDLE writerWaitable;

    private static WinNT.HANDLE createFile(String string) {
        return API.CreateFile(string, -1073741824, 0, null, 3, 0, null);
    }

    private static CloseCallback emptyCallback() {
        return new CloseCallback(){

            @Override
            public void onNamedPipeSocketClose(WinNT.HANDLE hANDLE) throws IOException {
            }
        };
    }

    public Win32NamedPipeSocket(WinNT.HANDLE hANDLE, CloseCallback closeCallback, boolean bl) throws IOException {
        this.handle = hANDLE;
        this.closeCallback = closeCallback;
        this.requireStrictLength = bl;
        this.readerWaitable = API.CreateEvent(null, true, false, null);
        if (this.readerWaitable == null) {
            throw new IOException("CreateEvent() failed ");
        }
        this.writerWaitable = API.CreateEvent(null, true, false, null);
        if (this.writerWaitable == null) {
            throw new IOException("CreateEvent() failed ");
        }
        this.is = new Win32NamedPipeSocketInputStream(hANDLE);
        this.os = new Win32NamedPipeSocketOutputStream(hANDLE);
    }

    public Win32NamedPipeSocket(WinNT.HANDLE hANDLE, CloseCallback closeCallback) throws IOException {
        this(hANDLE, closeCallback, false);
    }

    public Win32NamedPipeSocket(String string) throws IOException {
        this(Win32NamedPipeSocket.createFile(string), Win32NamedPipeSocket.emptyCallback(), false);
    }

    @Override
    public InputStream getInputStream() {
        return this.is;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.os;
    }

    @Override
    public void close() throws IOException {
        this.closeCallback.onNamedPipeSocketClose(this.handle);
    }

    @Override
    public void shutdownInput() throws IOException {
    }

    @Override
    public void shutdownOutput() throws IOException {
    }

    private class Win32NamedPipeSocketOutputStream
    extends OutputStream {
        private final WinNT.HANDLE handle;

        Win32NamedPipeSocketOutputStream(WinNT.HANDLE hANDLE) {
            this.handle = hANDLE;
        }

        @Override
        public void write(int n) throws IOException {
            this.write(new byte[]{(byte)(0xFF & n)});
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
            WinBase.OVERLAPPED oVERLAPPED = new WinBase.OVERLAPPED();
            oVERLAPPED.hEvent = Win32NamedPipeSocket.this.writerWaitable;
            oVERLAPPED.write();
            boolean bl = API.WriteFile(this.handle, byteBuffer, n2, null, oVERLAPPED.getPointer());
            if (!bl && (n3 = API.GetLastError()) != 997) {
                throw new IOException("WriteFile() failed: " + n3);
            }
            IntByReference intByReference = new IntByReference();
            if (!API.GetOverlappedResult(this.handle, oVERLAPPED.getPointer(), intByReference, true)) {
                int n4 = API.GetLastError();
                throw new IOException("GetOverlappedResult() failed for write operation: " + n4);
            }
            if (intByReference.getValue() != n2) {
                throw new IOException("WriteFile() wrote less bytes than requested");
            }
        }
    }

    private class Win32NamedPipeSocketInputStream
    extends InputStream {
        private final WinNT.HANDLE handle;

        Win32NamedPipeSocketInputStream(WinNT.HANDLE hANDLE) {
            this.handle = hANDLE;
        }

        @Override
        public int read() throws IOException {
            byte[] byArray = new byte[1];
            int n = this.read(byArray) == 0 ? -1 : 0xFF & byArray[0];
            return n;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            Memory memory = new Memory((long)n2);
            WinBase.OVERLAPPED oVERLAPPED = new WinBase.OVERLAPPED();
            oVERLAPPED.hEvent = Win32NamedPipeSocket.this.readerWaitable;
            oVERLAPPED.write();
            boolean bl = API.ReadFile(this.handle, memory, n2, null, oVERLAPPED.getPointer());
            if (!bl && (n3 = API.GetLastError()) != 997) {
                throw new IOException("ReadFile() failed: " + n3);
            }
            IntByReference intByReference = new IntByReference();
            if (!API.GetOverlappedResult(this.handle, oVERLAPPED.getPointer(), intByReference, true)) {
                int n4 = API.GetLastError();
                throw new IOException("GetOverlappedResult() failed for read operation: " + n4);
            }
            int n5 = intByReference.getValue();
            if (Win32NamedPipeSocket.this.requireStrictLength && n5 != n2) {
                throw new IOException("ReadFile() read less bytes than requested: expected " + n2 + " bytes, but read " + n5 + " bytes");
            }
            byte[] byArray2 = memory.getByteArray(0L, n5);
            System.arraycopy(byArray2, 0, byArray, n, n5);
            return n5;
        }
    }

    static interface CloseCallback {
        public void onNamedPipeSocketClose(WinNT.HANDLE var1) throws IOException;
    }
}

