/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.dht;

import edu.emory.mathcs.jtransforms.dht.FloatDHT_1D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class FloatDHT_3D {
    private int n1;
    private int n2;
    private int n3;
    private int sliceStride;
    private int rowStride;
    private int[] ip;
    private float[] w;
    private float[] t;
    private FloatDHT_1D dhtn1;
    private FloatDHT_1D dhtn2;
    private FloatDHT_1D dhtn3;
    private int oldNthread;
    private int nt;

    public FloatDHT_3D(int n, int n2, int n3) {
        if (!(ConcurrencyUtils.isPowerOf2(n) && ConcurrencyUtils.isPowerOf2(n2) && ConcurrencyUtils.isPowerOf2(n3))) {
            throw new IllegalArgumentException("n1, n2 and n3 must be power of two numbers");
        }
        if (n <= 1 || n2 <= 1 || n3 <= 1) {
            throw new IllegalArgumentException("n1, n2 and n3 must be greater than 1");
        }
        this.n1 = n;
        this.n2 = n2;
        this.n3 = n3;
        this.sliceStride = n2 * n3;
        this.rowStride = n3;
        this.ip = new int[2 + (int)Math.ceil(Math.sqrt(Math.max(Math.max(n / 2, n2 / 2), n3 / 2)))];
        this.w = new float[(int)Math.ceil(Math.max(Math.max((double)n * 1.5, (double)n2 * 1.5), (double)n3 * 1.5))];
        this.dhtn1 = new FloatDHT_1D(n, this.ip, this.w);
        this.dhtn2 = new FloatDHT_1D(n2, this.ip, this.w);
        this.dhtn3 = new FloatDHT_1D(n3, this.ip, this.w);
        this.oldNthread = ConcurrencyUtils.getNumberOfProcessors();
        this.nt = n;
        if (this.nt < n2) {
            this.nt = n2;
        }
        this.nt *= 4;
        if (this.oldNthread > 1) {
            this.nt *= this.oldNthread;
        }
        if (n3 == 2) {
            this.nt >>= 1;
        }
        this.t = new float[this.nt];
    }

    public void forward(float[] fArray) {
        int n;
        int n2;
        int n3;
        int n4 = this.n1;
        if (n4 < this.n2) {
            n4 = this.n2;
        }
        if (n4 < this.n3) {
            n4 = this.n3;
        }
        if (n4 > (n3 = this.ip[0]) << 2) {
            n3 = n4 >> 2;
            this.makewt(n3);
        }
        if (n4 > (n2 = this.ip[1])) {
            n2 = n4;
            this.makect(n2, this.w, n3);
        }
        if ((n = ConcurrencyUtils.getNumberOfProcessors()) != this.oldNthread) {
            this.nt = this.n1;
            if (this.nt < this.n2) {
                this.nt = this.n2;
            }
            this.nt *= 4;
            if (n > 1) {
                this.nt *= n;
            }
            if (this.n3 == 2) {
                this.nt >>= 1;
            }
            this.t = new float[this.nt];
            this.oldNthread = n;
        }
        if (n > 1 && this.n1 * this.n2 * this.n3 >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            this.ddxt3da_subth(-1, fArray, true);
            this.ddxt3db_subth(-1, fArray, true);
        } else {
            this.ddxt3da_sub(-1, fArray, true);
            this.ddxt3db_sub(-1, fArray, true);
        }
        this.y_transform(fArray);
    }

    public void forward(float[][][] fArray) {
        int n;
        int n2;
        int n3;
        int n4 = this.n1;
        if (n4 < this.n2) {
            n4 = this.n2;
        }
        if (n4 < this.n3) {
            n4 = this.n3;
        }
        if (n4 > (n3 = this.ip[0]) << 2) {
            n3 = n4 >> 2;
            this.makewt(n3);
        }
        if (n4 > (n2 = this.ip[1])) {
            n2 = n4;
            this.makect(n2, this.w, n3);
        }
        if ((n = ConcurrencyUtils.getNumberOfProcessors()) != this.oldNthread) {
            this.nt = this.n1;
            if (this.nt < this.n2) {
                this.nt = this.n2;
            }
            this.nt *= 4;
            if (n > 1) {
                this.nt *= n;
            }
            if (this.n3 == 2) {
                this.nt >>= 1;
            }
            this.t = new float[this.nt];
            this.oldNthread = n;
        }
        if (n > 1 && this.n1 * this.n2 * this.n3 >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            this.ddxt3da_subth(-1, fArray, true);
            this.ddxt3db_subth(-1, fArray, true);
        } else {
            this.ddxt3da_sub(-1, fArray, true);
            this.ddxt3db_sub(-1, fArray, true);
        }
        this.y_transform(fArray);
    }

    public void inverse(float[] fArray, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4 = this.n1;
        if (n4 < this.n2) {
            n4 = this.n2;
        }
        if (n4 < this.n3) {
            n4 = this.n3;
        }
        if (n4 > (n3 = this.ip[0]) << 2) {
            n3 = n4 >> 2;
            this.makewt(n3);
        }
        if (n4 > (n2 = this.ip[1])) {
            n2 = n4;
            this.makect(n2, this.w, n3);
        }
        if ((n = ConcurrencyUtils.getNumberOfProcessors()) != this.oldNthread) {
            this.nt = this.n1;
            if (this.nt < this.n2) {
                this.nt = this.n2;
            }
            this.nt *= 4;
            if (n > 1) {
                this.nt *= n;
            }
            if (this.n3 == 2) {
                this.nt >>= 1;
            }
            this.t = new float[this.nt];
            this.oldNthread = n;
        }
        if (n > 1 && this.n1 * this.n2 * this.n3 >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            this.ddxt3da_subth(1, fArray, bl);
            this.ddxt3db_subth(1, fArray, bl);
        } else {
            this.ddxt3da_sub(1, fArray, bl);
            this.ddxt3db_sub(1, fArray, bl);
        }
        this.y_transform(fArray);
    }

    public void inverse(float[][][] fArray, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4 = this.n1;
        if (n4 < this.n2) {
            n4 = this.n2;
        }
        if (n4 < this.n3) {
            n4 = this.n3;
        }
        if (n4 > (n3 = this.ip[0]) << 2) {
            n3 = n4 >> 2;
            this.makewt(n3);
        }
        if (n4 > (n2 = this.ip[1])) {
            n2 = n4;
            this.makect(n2, this.w, n3);
        }
        if ((n = ConcurrencyUtils.getNumberOfProcessors()) != this.oldNthread) {
            this.nt = this.n1;
            if (this.nt < this.n2) {
                this.nt = this.n2;
            }
            this.nt *= 4;
            if (n > 1) {
                this.nt *= n;
            }
            if (this.n3 == 2) {
                this.nt >>= 1;
            }
            this.t = new float[this.nt];
            this.oldNthread = n;
        }
        if (n > 1 && this.n1 * this.n2 * this.n3 >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            this.ddxt3da_subth(1, fArray, bl);
            this.ddxt3db_subth(1, fArray, bl);
        } else {
            this.ddxt3da_sub(1, fArray, bl);
            this.ddxt3db_sub(1, fArray, bl);
        }
        this.y_transform(fArray);
    }

    private void ddxt3da_sub(int n, float[] fArray, boolean bl) {
        if (n == -1) {
            for (int i = 0; i < this.n1; ++i) {
                int n2;
                int n3;
                int n4 = i * this.sliceStride;
                for (n3 = 0; n3 < this.n2; ++n3) {
                    this.dhtn3.forward(fArray, n4 + n3 * this.rowStride);
                }
                if (this.n3 > 2) {
                    for (int j = 0; j < this.n3; j += 4) {
                        int n5;
                        for (n3 = 0; n3 < this.n2; ++n3) {
                            n2 = n4 + n3 * this.rowStride + j;
                            n5 = this.n2 + n3;
                            this.t[n3] = fArray[n2];
                            this.t[n5] = fArray[n2 + 1];
                            this.t[n5 + this.n2] = fArray[n2 + 2];
                            this.t[n5 + 2 * this.n2] = fArray[n2 + 3];
                        }
                        this.dhtn2.forward(this.t, 0);
                        this.dhtn2.forward(this.t, this.n2);
                        this.dhtn2.forward(this.t, 2 * this.n2);
                        this.dhtn2.forward(this.t, 3 * this.n2);
                        for (n3 = 0; n3 < this.n2; ++n3) {
                            n2 = n4 + n3 * this.rowStride + j;
                            n5 = this.n2 + n3;
                            fArray[n2] = this.t[n3];
                            fArray[n2 + 1] = this.t[n5];
                            fArray[n2 + 2] = this.t[n5 + this.n2];
                            fArray[n2 + 3] = this.t[n5 + 2 * this.n2];
                        }
                    }
                    continue;
                }
                if (this.n3 != 2) continue;
                for (n3 = 0; n3 < this.n2; ++n3) {
                    n2 = n4 + n3 * this.rowStride;
                    this.t[n3] = fArray[n2];
                    this.t[this.n2 + n3] = fArray[n2 + 1];
                }
                this.dhtn2.forward(this.t, 0);
                this.dhtn2.forward(this.t, this.n2);
                for (n3 = 0; n3 < this.n2; ++n3) {
                    n2 = n4 + n3 * this.rowStride;
                    fArray[n2] = this.t[n3];
                    fArray[n2 + 1] = this.t[this.n2 + n3];
                }
            }
        } else {
            for (int i = 0; i < this.n1; ++i) {
                int n6;
                int n7;
                int n8 = i * this.sliceStride;
                for (n7 = 0; n7 < this.n2; ++n7) {
                    this.dhtn3.inverse(fArray, n8 + n7 * this.rowStride, bl);
                }
                if (this.n3 > 2) {
                    for (int j = 0; j < this.n3; j += 4) {
                        int n9;
                        for (n7 = 0; n7 < this.n2; ++n7) {
                            n6 = n8 + n7 * this.rowStride + j;
                            n9 = this.n2 + n7;
                            this.t[n7] = fArray[n6];
                            this.t[n9] = fArray[n6 + 1];
                            this.t[n9 + this.n2] = fArray[n6 + 2];
                            this.t[n9 + 2 * this.n2] = fArray[n6 + 3];
                        }
                        this.dhtn2.inverse(this.t, 0, bl);
                        this.dhtn2.inverse(this.t, this.n2, bl);
                        this.dhtn2.inverse(this.t, 2 * this.n2, bl);
                        this.dhtn2.inverse(this.t, 3 * this.n2, bl);
                        for (n7 = 0; n7 < this.n2; ++n7) {
                            n6 = n8 + n7 * this.rowStride + j;
                            n9 = this.n2 + n7;
                            fArray[n6] = this.t[n7];
                            fArray[n6 + 1] = this.t[n9];
                            fArray[n6 + 2] = this.t[n9 + this.n2];
                            fArray[n6 + 3] = this.t[n9 + 2 * this.n2];
                        }
                    }
                    continue;
                }
                if (this.n3 != 2) continue;
                for (n7 = 0; n7 < this.n2; ++n7) {
                    n6 = n8 + n7 * this.rowStride;
                    this.t[n7] = fArray[n6];
                    this.t[this.n2 + n7] = fArray[n6 + 1];
                }
                this.dhtn2.inverse(this.t, 0, bl);
                this.dhtn2.inverse(this.t, this.n2, bl);
                for (n7 = 0; n7 < this.n2; ++n7) {
                    n6 = n8 + n7 * this.rowStride;
                    fArray[n6] = this.t[n7];
                    fArray[n6 + 1] = this.t[this.n2 + n7];
                }
            }
        }
    }

    private void ddxt3da_sub(int n, float[][][] fArray, boolean bl) {
        if (n == -1) {
            for (int i = 0; i < this.n1; ++i) {
                int n2;
                for (n2 = 0; n2 < this.n2; ++n2) {
                    this.dhtn3.forward(fArray[i][n2]);
                }
                if (this.n3 > 2) {
                    for (int j = 0; j < this.n3; j += 4) {
                        int n3;
                        for (n2 = 0; n2 < this.n2; ++n2) {
                            n3 = this.n2 + n2;
                            this.t[n2] = fArray[i][n2][j];
                            this.t[n3] = fArray[i][n2][j + 1];
                            this.t[n3 + this.n2] = fArray[i][n2][j + 2];
                            this.t[n3 + 2 * this.n2] = fArray[i][n2][j + 3];
                        }
                        this.dhtn2.forward(this.t, 0);
                        this.dhtn2.forward(this.t, this.n2);
                        this.dhtn2.forward(this.t, 2 * this.n2);
                        this.dhtn2.forward(this.t, 3 * this.n2);
                        for (n2 = 0; n2 < this.n2; ++n2) {
                            n3 = this.n2 + n2;
                            fArray[i][n2][j] = this.t[n2];
                            fArray[i][n2][j + 1] = this.t[n3];
                            fArray[i][n2][j + 2] = this.t[n3 + this.n2];
                            fArray[i][n2][j + 3] = this.t[n3 + 2 * this.n2];
                        }
                    }
                    continue;
                }
                if (this.n3 != 2) continue;
                for (n2 = 0; n2 < this.n2; ++n2) {
                    this.t[n2] = fArray[i][n2][0];
                    this.t[this.n2 + n2] = fArray[i][n2][1];
                }
                this.dhtn2.forward(this.t, 0);
                this.dhtn2.forward(this.t, this.n2);
                for (n2 = 0; n2 < this.n2; ++n2) {
                    fArray[i][n2][0] = this.t[n2];
                    fArray[i][n2][1] = this.t[this.n2 + n2];
                }
            }
        } else {
            for (int i = 0; i < this.n1; ++i) {
                int n4;
                for (n4 = 0; n4 < this.n2; ++n4) {
                    this.dhtn3.inverse(fArray[i][n4], bl);
                }
                if (this.n3 > 2) {
                    for (int j = 0; j < this.n3; j += 4) {
                        int n5;
                        for (n4 = 0; n4 < this.n2; ++n4) {
                            n5 = this.n2 + n4;
                            this.t[n4] = fArray[i][n4][j];
                            this.t[n5] = fArray[i][n4][j + 1];
                            this.t[n5 + this.n2] = fArray[i][n4][j + 2];
                            this.t[n5 + 2 * this.n2] = fArray[i][n4][j + 3];
                        }
                        this.dhtn2.inverse(this.t, 0, bl);
                        this.dhtn2.inverse(this.t, this.n2, bl);
                        this.dhtn2.inverse(this.t, 2 * this.n2, bl);
                        this.dhtn2.inverse(this.t, 3 * this.n2, bl);
                        for (n4 = 0; n4 < this.n2; ++n4) {
                            n5 = this.n2 + n4;
                            fArray[i][n4][j] = this.t[n4];
                            fArray[i][n4][j + 1] = this.t[n5];
                            fArray[i][n4][j + 2] = this.t[n5 + this.n2];
                            fArray[i][n4][j + 3] = this.t[n5 + 2 * this.n2];
                        }
                    }
                    continue;
                }
                if (this.n3 != 2) continue;
                for (n4 = 0; n4 < this.n2; ++n4) {
                    this.t[n4] = fArray[i][n4][0];
                    this.t[this.n2 + n4] = fArray[i][n4][1];
                }
                this.dhtn2.inverse(this.t, 0, bl);
                this.dhtn2.inverse(this.t, this.n2, bl);
                for (n4 = 0; n4 < this.n2; ++n4) {
                    fArray[i][n4][0] = this.t[n4];
                    fArray[i][n4][1] = this.t[this.n2 + n4];
                }
            }
        }
    }

    private void ddxt3db_sub(int n, float[] fArray, boolean bl) {
        block19: {
            block17: {
                block18: {
                    if (n != -1) break block17;
                    if (this.n3 <= 2) break block18;
                    for (int i = 0; i < this.n2; ++i) {
                        int n2 = i * this.rowStride;
                        for (int j = 0; j < this.n3; j += 4) {
                            int n3;
                            int n4;
                            int n5;
                            for (n5 = 0; n5 < this.n1; ++n5) {
                                n4 = n5 * this.sliceStride + n2 + j;
                                n3 = this.n1 + n5;
                                this.t[n5] = fArray[n4];
                                this.t[n3] = fArray[n4 + 1];
                                this.t[n3 + this.n1] = fArray[n4 + 2];
                                this.t[n3 + 2 * this.n1] = fArray[n4 + 3];
                            }
                            this.dhtn1.forward(this.t, 0);
                            this.dhtn1.forward(this.t, this.n1);
                            this.dhtn1.forward(this.t, 2 * this.n1);
                            this.dhtn1.forward(this.t, 3 * this.n1);
                            for (n5 = 0; n5 < this.n1; ++n5) {
                                n4 = n5 * this.sliceStride + n2 + j;
                                n3 = this.n1 + n5;
                                fArray[n4] = this.t[n5];
                                fArray[n4 + 1] = this.t[n3];
                                fArray[n4 + 2] = this.t[n3 + this.n1];
                                fArray[n4 + 3] = this.t[n3 + 2 * this.n1];
                            }
                        }
                    }
                    break block19;
                }
                if (this.n3 != 2) break block19;
                for (int i = 0; i < this.n2; ++i) {
                    int n6;
                    int n7;
                    int n8 = i * this.rowStride;
                    for (n7 = 0; n7 < this.n1; ++n7) {
                        n6 = n7 * this.sliceStride + n8;
                        this.t[n7] = fArray[n6];
                        this.t[this.n1 + n7] = fArray[n6 + 1];
                    }
                    this.dhtn1.forward(this.t, 0);
                    this.dhtn1.forward(this.t, this.n1);
                    for (n7 = 0; n7 < this.n1; ++n7) {
                        n6 = n7 * this.sliceStride + n8;
                        fArray[n6] = this.t[n7];
                        fArray[n6 + 1] = this.t[this.n1 + n7];
                    }
                }
                break block19;
            }
            if (this.n3 > 2) {
                for (int i = 0; i < this.n2; ++i) {
                    int n9 = i * this.rowStride;
                    for (int j = 0; j < this.n3; j += 4) {
                        int n10;
                        int n11;
                        int n12;
                        for (n12 = 0; n12 < this.n1; ++n12) {
                            n11 = n12 * this.sliceStride + n9 + j;
                            n10 = this.n1 + n12;
                            this.t[n12] = fArray[n11];
                            this.t[n10] = fArray[n11 + 1];
                            this.t[n10 + this.n1] = fArray[n11 + 2];
                            this.t[n10 + 2 * this.n1] = fArray[n11 + 3];
                        }
                        this.dhtn1.inverse(this.t, 0, bl);
                        this.dhtn1.inverse(this.t, this.n1, bl);
                        this.dhtn1.inverse(this.t, 2 * this.n1, bl);
                        this.dhtn1.inverse(this.t, 3 * this.n1, bl);
                        for (n12 = 0; n12 < this.n1; ++n12) {
                            n11 = n12 * this.sliceStride + n9 + j;
                            n10 = this.n1 + n12;
                            fArray[n11] = this.t[n12];
                            fArray[n11 + 1] = this.t[n10];
                            fArray[n11 + 2] = this.t[n10 + this.n1];
                            fArray[n11 + 3] = this.t[n10 + 2 * this.n1];
                        }
                    }
                }
            } else if (this.n3 == 2) {
                for (int i = 0; i < this.n2; ++i) {
                    int n13;
                    int n14;
                    int n15 = i * this.rowStride;
                    for (n14 = 0; n14 < this.n1; ++n14) {
                        n13 = n14 * this.sliceStride + n15;
                        this.t[n14] = fArray[n13];
                        this.t[this.n1 + n14] = fArray[n13 + 1];
                    }
                    this.dhtn1.inverse(this.t, 0, bl);
                    this.dhtn1.inverse(this.t, this.n1, bl);
                    for (n14 = 0; n14 < this.n1; ++n14) {
                        n13 = n14 * this.sliceStride + n15;
                        fArray[n13] = this.t[n14];
                        fArray[n13 + 1] = this.t[this.n1 + n14];
                    }
                }
            }
        }
    }

    private void ddxt3db_sub(int n, float[][][] fArray, boolean bl) {
        block19: {
            block17: {
                block18: {
                    if (n != -1) break block17;
                    if (this.n3 <= 2) break block18;
                    for (int i = 0; i < this.n2; ++i) {
                        for (int j = 0; j < this.n3; j += 4) {
                            int n2;
                            int n3;
                            for (n3 = 0; n3 < this.n1; ++n3) {
                                n2 = this.n1 + n3;
                                this.t[n3] = fArray[n3][i][j];
                                this.t[n2] = fArray[n3][i][j + 1];
                                this.t[n2 + this.n1] = fArray[n3][i][j + 2];
                                this.t[n2 + 2 * this.n1] = fArray[n3][i][j + 3];
                            }
                            this.dhtn1.forward(this.t, 0);
                            this.dhtn1.forward(this.t, this.n1);
                            this.dhtn1.forward(this.t, 2 * this.n1);
                            this.dhtn1.forward(this.t, 3 * this.n1);
                            for (n3 = 0; n3 < this.n1; ++n3) {
                                n2 = this.n1 + n3;
                                fArray[n3][i][j] = this.t[n3];
                                fArray[n3][i][j + 1] = this.t[n2];
                                fArray[n3][i][j + 2] = this.t[n2 + this.n1];
                                fArray[n3][i][j + 3] = this.t[n2 + 2 * this.n1];
                            }
                        }
                    }
                    break block19;
                }
                if (this.n3 != 2) break block19;
                for (int i = 0; i < this.n2; ++i) {
                    int n4;
                    for (n4 = 0; n4 < this.n1; ++n4) {
                        this.t[n4] = fArray[n4][i][0];
                        this.t[this.n1 + n4] = fArray[n4][i][1];
                    }
                    this.dhtn1.forward(this.t, 0);
                    this.dhtn1.forward(this.t, this.n1);
                    for (n4 = 0; n4 < this.n1; ++n4) {
                        fArray[n4][i][0] = this.t[n4];
                        fArray[n4][i][1] = this.t[this.n1 + n4];
                    }
                }
                break block19;
            }
            if (this.n3 > 2) {
                for (int i = 0; i < this.n2; ++i) {
                    for (int j = 0; j < this.n3; j += 4) {
                        int n5;
                        int n6;
                        for (n6 = 0; n6 < this.n1; ++n6) {
                            n5 = this.n1 + n6;
                            this.t[n6] = fArray[n6][i][j];
                            this.t[n5] = fArray[n6][i][j + 1];
                            this.t[n5 + this.n1] = fArray[n6][i][j + 2];
                            this.t[n5 + 2 * this.n1] = fArray[n6][i][j + 3];
                        }
                        this.dhtn1.inverse(this.t, 0, bl);
                        this.dhtn1.inverse(this.t, this.n1, bl);
                        this.dhtn1.inverse(this.t, 2 * this.n1, bl);
                        this.dhtn1.inverse(this.t, 3 * this.n1, bl);
                        for (n6 = 0; n6 < this.n1; ++n6) {
                            n5 = this.n1 + n6;
                            fArray[n6][i][j] = this.t[n6];
                            fArray[n6][i][j + 1] = this.t[n5];
                            fArray[n6][i][j + 2] = this.t[n5 + this.n1];
                            fArray[n6][i][j + 3] = this.t[n5 + 2 * this.n1];
                        }
                    }
                }
            } else if (this.n3 == 2) {
                for (int i = 0; i < this.n2; ++i) {
                    int n7;
                    for (n7 = 0; n7 < this.n1; ++n7) {
                        this.t[n7] = fArray[n7][i][0];
                        this.t[this.n1 + n7] = fArray[n7][i][1];
                    }
                    this.dhtn1.inverse(this.t, 0, bl);
                    this.dhtn1.inverse(this.t, this.n1, bl);
                    for (n7 = 0; n7 < this.n1; ++n7) {
                        fArray[n7][i][0] = this.t[n7];
                        fArray[n7][i][1] = this.t[this.n1 + n7];
                    }
                }
            }
        }
    }

    private void ddxt3da_subth(final int n, final float[] fArray, final boolean bl) {
        int n2;
        int n3 = ConcurrencyUtils.getNumberOfProcessors();
        if (n3 > this.n1) {
            n3 = this.n1;
        }
        int n4 = 4 * this.n2;
        if (this.n3 == 2) {
            n4 >>= 1;
        }
        final int n5 = n3;
        Future[] futureArray = new Future[n3];
        for (int i = 0; i < n3; ++i) {
            n2 = i;
            final int n6 = n4 * i;
            futureArray[i] = ConcurrencyUtils.threadPool.submit(new Runnable(){

                public void run() {
                    if (n == -1) {
                        for (int i = n2; i < FloatDHT_3D.this.n1; i += n5) {
                            int n10;
                            int n22;
                            int n3 = i * FloatDHT_3D.this.sliceStride;
                            for (n22 = 0; n22 < FloatDHT_3D.this.n2; ++n22) {
                                FloatDHT_3D.this.dhtn3.forward(fArray, n3 + n22 * FloatDHT_3D.this.rowStride);
                            }
                            if (FloatDHT_3D.this.n3 > 2) {
                                for (n22 = 0; n22 < FloatDHT_3D.this.n3; n22 += 4) {
                                    int n4;
                                    int n52;
                                    for (n52 = 0; n52 < FloatDHT_3D.this.n2; ++n52) {
                                        n10 = n3 + n52 * FloatDHT_3D.this.rowStride + n22;
                                        n4 = n6 + FloatDHT_3D.this.n2 + n52;
                                        ((FloatDHT_3D)FloatDHT_3D.this).t[n6 + n52] = fArray[n10];
                                        ((FloatDHT_3D)FloatDHT_3D.this).t[n4] = fArray[n10 + 1];
                                        ((FloatDHT_3D)FloatDHT_3D.this).t[n4 + ((FloatDHT_3D)FloatDHT_3D.this).n2] = fArray[n10 + 2];
                                        ((FloatDHT_3D)FloatDHT_3D.this).t[n4 + 2 * ((FloatDHT_3D)FloatDHT_3D.this).n2] = fArray[n10 + 3];
                                    }
                                    FloatDHT_3D.this.dhtn2.forward(FloatDHT_3D.this.t, n6);
                                    FloatDHT_3D.this.dhtn2.forward(FloatDHT_3D.this.t, n6 + FloatDHT_3D.this.n2);
                                    FloatDHT_3D.this.dhtn2.forward(FloatDHT_3D.this.t, n6 + 2 * FloatDHT_3D.this.n2);
                                    FloatDHT_3D.this.dhtn2.forward(FloatDHT_3D.this.t, n6 + 3 * FloatDHT_3D.this.n2);
                                    for (n52 = 0; n52 < FloatDHT_3D.this.n2; ++n52) {
                                        n10 = n3 + n52 * FloatDHT_3D.this.rowStride + n22;
                                        n4 = n6 + FloatDHT_3D.this.n2 + n52;
                                        fArray[n10] = FloatDHT_3D.this.t[n6 + n52];
                                        fArray[n10 + 1] = FloatDHT_3D.this.t[n4];
                                        fArray[n10 + 2] = FloatDHT_3D.this.t[n4 + FloatDHT_3D.this.n2];
                                        fArray[n10 + 3] = FloatDHT_3D.this.t[n4 + 2 * FloatDHT_3D.this.n2];
                                    }
                                }
                                continue;
                            }
                            if (FloatDHT_3D.this.n3 != 2) continue;
                            for (n22 = 0; n22 < FloatDHT_3D.this.n2; ++n22) {
                                n10 = n3 + n22 * FloatDHT_3D.this.rowStride;
                                ((FloatDHT_3D)FloatDHT_3D.this).t[n6 + n22] = fArray[n10];
                                ((FloatDHT_3D)FloatDHT_3D.this).t[n6 + ((FloatDHT_3D)FloatDHT_3D.this).n2 + n22] = fArray[n10 + 1];
                            }
                            FloatDHT_3D.this.dhtn2.forward(FloatDHT_3D.this.t, n6);
                            FloatDHT_3D.this.dhtn2.forward(FloatDHT_3D.this.t, n6 + FloatDHT_3D.this.n2);
                            for (n22 = 0; n22 < FloatDHT_3D.this.n2; ++n22) {
                                n10 = n3 + n22 * FloatDHT_3D.this.rowStride;
                                fArray[n10] = FloatDHT_3D.this.t[n6 + n22];
                                fArray[n10 + 1] = FloatDHT_3D.this.t[n6 + FloatDHT_3D.this.n2 + n22];
                            }
                        }
                    } else {
                        for (int i = n2; i < FloatDHT_3D.this.n1; i += n5) {
                            int n11;
                            int n62;
                            int n7 = i * FloatDHT_3D.this.sliceStride;
                            for (n62 = 0; n62 < FloatDHT_3D.this.n2; ++n62) {
                                FloatDHT_3D.this.dhtn3.inverse(fArray, n7 + n62 * FloatDHT_3D.this.rowStride, bl);
                            }
                            if (FloatDHT_3D.this.n3 > 2) {
                                for (n62 = 0; n62 < FloatDHT_3D.this.n3; n62 += 4) {
                                    int n8;
                                    int n9;
                                    for (n9 = 0; n9 < FloatDHT_3D.this.n2; ++n9) {
                                        n11 = n7 + n9 * FloatDHT_3D.this.rowStride + n62;
                                        n8 = n6 + FloatDHT_3D.this.n2 + n9;
                                        ((FloatDHT_3D)FloatDHT_3D.this).t[n6 + n9] = fArray[n11];
                                        ((FloatDHT_3D)FloatDHT_3D.this).t[n8] = fArray[n11 + 1];
                                        ((FloatDHT_3D)FloatDHT_3D.this).t[n8 + ((FloatDHT_3D)FloatDHT_3D.this).n2] = fArray[n11 + 2];
                                        ((FloatDHT_3D)FloatDHT_3D.this).t[n8 + 2 * ((FloatDHT_3D)FloatDHT_3D.this).n2] = fArray[n11 + 3];
                                    }
                                    FloatDHT_3D.this.dhtn2.inverse(FloatDHT_3D.this.t, n6, bl);
                                    FloatDHT_3D.this.dhtn2.inverse(FloatDHT_3D.this.t, n6 + FloatDHT_3D.this.n2, bl);
                                    FloatDHT_3D.this.dhtn2.inverse(FloatDHT_3D.this.t, n6 + 2 * FloatDHT_3D.this.n2, bl);
                                    FloatDHT_3D.this.dhtn2.inverse(FloatDHT_3D.this.t, n6 + 3 * FloatDHT_3D.this.n2, bl);
                                    for (n9 = 0; n9 < FloatDHT_3D.this.n2; ++n9) {
                                        n11 = n7 + n9 * FloatDHT_3D.this.rowStride + n62;
                                        n8 = n6 + FloatDHT_3D.this.n2 + n9;
                                        fArray[n11] = FloatDHT_3D.this.t[n6 + n9];
                                        fArray[n11 + 1] = FloatDHT_3D.this.t[n8];
                                        fArray[n11 + 2] = FloatDHT_3D.this.t[n8 + FloatDHT_3D.this.n2];
                                        fArray[n11 + 3] = FloatDHT_3D.this.t[n8 + 2 * FloatDHT_3D.this.n2];
                                    }
                                }
                                continue;
                            }
                            if (FloatDHT_3D.this.n3 != 2) continue;
                            for (n62 = 0; n62 < FloatDHT_3D.this.n2; ++n62) {
                                n11 = n7 + n62 * FloatDHT_3D.this.rowStride;
                                ((FloatDHT_3D)FloatDHT_3D.this).t[n6 + n62] = fArray[n11];
                                ((FloatDHT_3D)FloatDHT_3D.this).t[n6 + ((FloatDHT_3D)FloatDHT_3D.this).n2 + n62] = fArray[n11 + 1];
                            }
                            FloatDHT_3D.this.dhtn2.inverse(FloatDHT_3D.this.t, n6, bl);
                            FloatDHT_3D.this.dhtn2.inverse(FloatDHT_3D.this.t, n6 + FloatDHT_3D.this.n2, bl);
                            for (n62 = 0; n62 < FloatDHT_3D.this.n2; ++n62) {
                                n11 = n7 + n62 * FloatDHT_3D.this.rowStride;
                                fArray[n11] = FloatDHT_3D.this.t[n6 + n62];
                                fArray[n11 + 1] = FloatDHT_3D.this.t[n6 + FloatDHT_3D.this.n2 + n62];
                            }
                        }
                    }
                }
            });
        }
        try {
            for (n2 = 0; n2 < n3; ++n2) {
                futureArray[n2].get();
            }
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void ddxt3da_subth(final int n, final float[][][] fArray, final boolean bl) {
        int n2;
        int n3 = ConcurrencyUtils.getNumberOfProcessors();
        if (n3 > this.n1) {
            n3 = this.n1;
        }
        int n4 = 4 * this.n2;
        if (this.n3 == 2) {
            n4 >>= 1;
        }
        final int n5 = n3;
        Future[] futureArray = new Future[n3];
        for (int i = 0; i < n3; ++i) {
            n2 = i;
            final int n6 = n4 * i;
            futureArray[i] = ConcurrencyUtils.threadPool.submit(new Runnable(){

                public void run() {
                    if (n == -1) {
                        for (int i = n2; i < FloatDHT_3D.this.n1; i += n5) {
                            int n7;
                            for (n7 = 0; n7 < FloatDHT_3D.this.n2; ++n7) {
                                FloatDHT_3D.this.dhtn3.forward(fArray[i][n7]);
                            }
                            if (FloatDHT_3D.this.n3 > 2) {
                                for (n7 = 0; n7 < FloatDHT_3D.this.n3; n7 += 4) {
                                    int n22;
                                    int n3;
                                    for (n3 = 0; n3 < FloatDHT_3D.this.n2; ++n3) {
                                        n22 = n6 + FloatDHT_3D.this.n2 + n3;
                                        ((FloatDHT_3D)FloatDHT_3D.this).t[n6 + n3] = fArray[i][n3][n7];
                                        ((FloatDHT_3D)FloatDHT_3D.this).t[n22] = fArray[i][n3][n7 + 1];
                                        ((FloatDHT_3D)FloatDHT_3D.this).t[n22 + ((FloatDHT_3D)FloatDHT_3D.this).n2] = fArray[i][n3][n7 + 2];
                                        ((FloatDHT_3D)FloatDHT_3D.this).t[n22 + 2 * ((FloatDHT_3D)FloatDHT_3D.this).n2] = fArray[i][n3][n7 + 3];
                                    }
                                    FloatDHT_3D.this.dhtn2.forward(FloatDHT_3D.this.t, n6);
                                    FloatDHT_3D.this.dhtn2.forward(FloatDHT_3D.this.t, n6 + FloatDHT_3D.this.n2);
                                    FloatDHT_3D.this.dhtn2.forward(FloatDHT_3D.this.t, n6 + 2 * FloatDHT_3D.this.n2);
                                    FloatDHT_3D.this.dhtn2.forward(FloatDHT_3D.this.t, n6 + 3 * FloatDHT_3D.this.n2);
                                    for (n3 = 0; n3 < FloatDHT_3D.this.n2; ++n3) {
                                        n22 = n6 + FloatDHT_3D.this.n2 + n3;
                                        fArray[i][n3][n7] = FloatDHT_3D.this.t[n6 + n3];
                                        fArray[i][n3][n7 + 1] = FloatDHT_3D.this.t[n22];
                                        fArray[i][n3][n7 + 2] = FloatDHT_3D.this.t[n22 + FloatDHT_3D.this.n2];
                                        fArray[i][n3][n7 + 3] = FloatDHT_3D.this.t[n22 + 2 * FloatDHT_3D.this.n2];
                                    }
                                }
                                continue;
                            }
                            if (FloatDHT_3D.this.n3 != 2) continue;
                            for (n7 = 0; n7 < FloatDHT_3D.this.n2; ++n7) {
                                ((FloatDHT_3D)FloatDHT_3D.this).t[n6 + n7] = fArray[i][n7][0];
                                ((FloatDHT_3D)FloatDHT_3D.this).t[n6 + ((FloatDHT_3D)FloatDHT_3D.this).n2 + n7] = fArray[i][n7][1];
                            }
                            FloatDHT_3D.this.dhtn2.forward(FloatDHT_3D.this.t, n6);
                            FloatDHT_3D.this.dhtn2.forward(FloatDHT_3D.this.t, n6 + FloatDHT_3D.this.n2);
                            for (n7 = 0; n7 < FloatDHT_3D.this.n2; ++n7) {
                                fArray[i][n7][0] = FloatDHT_3D.this.t[n6 + n7];
                                fArray[i][n7][1] = FloatDHT_3D.this.t[n6 + FloatDHT_3D.this.n2 + n7];
                            }
                        }
                    } else {
                        for (int i = n2; i < FloatDHT_3D.this.n1; i += n5) {
                            int n8;
                            for (n8 = 0; n8 < FloatDHT_3D.this.n2; ++n8) {
                                FloatDHT_3D.this.dhtn3.inverse(fArray[i][n8], bl);
                            }
                            if (FloatDHT_3D.this.n3 > 2) {
                                for (n8 = 0; n8 < FloatDHT_3D.this.n3; n8 += 4) {
                                    int n4;
                                    int n52;
                                    for (n52 = 0; n52 < FloatDHT_3D.this.n2; ++n52) {
                                        n4 = n6 + FloatDHT_3D.this.n2 + n52;
                                        ((FloatDHT_3D)FloatDHT_3D.this).t[n6 + n52] = fArray[i][n52][n8];
                                        ((FloatDHT_3D)FloatDHT_3D.this).t[n4] = fArray[i][n52][n8 + 1];
                                        ((FloatDHT_3D)FloatDHT_3D.this).t[n4 + ((FloatDHT_3D)FloatDHT_3D.this).n2] = fArray[i][n52][n8 + 2];
                                        ((FloatDHT_3D)FloatDHT_3D.this).t[n4 + 2 * ((FloatDHT_3D)FloatDHT_3D.this).n2] = fArray[i][n52][n8 + 3];
                                    }
                                    FloatDHT_3D.this.dhtn2.inverse(FloatDHT_3D.this.t, n6, bl);
                                    FloatDHT_3D.this.dhtn2.inverse(FloatDHT_3D.this.t, n6 + FloatDHT_3D.this.n2, bl);
                                    FloatDHT_3D.this.dhtn2.inverse(FloatDHT_3D.this.t, n6 + 2 * FloatDHT_3D.this.n2, bl);
                                    FloatDHT_3D.this.dhtn2.inverse(FloatDHT_3D.this.t, n6 + 3 * FloatDHT_3D.this.n2, bl);
                                    for (n52 = 0; n52 < FloatDHT_3D.this.n2; ++n52) {
                                        n4 = n6 + FloatDHT_3D.this.n2 + n52;
                                        fArray[i][n52][n8] = FloatDHT_3D.this.t[n6 + n52];
                                        fArray[i][n52][n8 + 1] = FloatDHT_3D.this.t[n4];
                                        fArray[i][n52][n8 + 2] = FloatDHT_3D.this.t[n4 + FloatDHT_3D.this.n2];
                                        fArray[i][n52][n8 + 3] = FloatDHT_3D.this.t[n4 + 2 * FloatDHT_3D.this.n2];
                                    }
                                }
                                continue;
                            }
                            if (FloatDHT_3D.this.n3 != 2) continue;
                            for (n8 = 0; n8 < FloatDHT_3D.this.n2; ++n8) {
                                ((FloatDHT_3D)FloatDHT_3D.this).t[n6 + n8] = fArray[i][n8][0];
                                ((FloatDHT_3D)FloatDHT_3D.this).t[n6 + ((FloatDHT_3D)FloatDHT_3D.this).n2 + n8] = fArray[i][n8][1];
                            }
                            FloatDHT_3D.this.dhtn2.inverse(FloatDHT_3D.this.t, n6, bl);
                            FloatDHT_3D.this.dhtn2.inverse(FloatDHT_3D.this.t, n6 + FloatDHT_3D.this.n2, bl);
                            for (n8 = 0; n8 < FloatDHT_3D.this.n2; ++n8) {
                                fArray[i][n8][0] = FloatDHT_3D.this.t[n6 + n8];
                                fArray[i][n8][1] = FloatDHT_3D.this.t[n6 + FloatDHT_3D.this.n2 + n8];
                            }
                        }
                    }
                }
            });
        }
        try {
            for (n2 = 0; n2 < n3; ++n2) {
                futureArray[n2].get();
            }
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void ddxt3db_subth(final int n, final float[] fArray, final boolean bl) {
        int n2;
        int n3 = ConcurrencyUtils.getNumberOfProcessors();
        if (n3 > this.n2) {
            n3 = this.n2;
        }
        int n4 = 4 * this.n1;
        if (this.n3 == 2) {
            n4 >>= 1;
        }
        Future[] futureArray = new Future[n3];
        final int n5 = n3;
        for (int i = 0; i < n3; ++i) {
            n2 = i;
            final int n6 = n4 * i;
            futureArray[i] = ConcurrencyUtils.threadPool.submit(new Runnable(){

                public void run() {
                    block19: {
                        block17: {
                            block18: {
                                if (n != -1) break block17;
                                if (FloatDHT_3D.this.n3 <= 2) break block18;
                                for (int i = n2; i < FloatDHT_3D.this.n2; i += n5) {
                                    int n12 = i * FloatDHT_3D.this.rowStride;
                                    for (int j = 0; j < FloatDHT_3D.this.n3; j += 4) {
                                        int n22;
                                        int n3;
                                        int n4;
                                        for (n4 = 0; n4 < FloatDHT_3D.this.n1; ++n4) {
                                            n3 = n4 * FloatDHT_3D.this.sliceStride + n12 + j;
                                            n22 = n6 + FloatDHT_3D.this.n1 + n4;
                                            ((FloatDHT_3D)FloatDHT_3D.this).t[n6 + n4] = fArray[n3];
                                            ((FloatDHT_3D)FloatDHT_3D.this).t[n22] = fArray[n3 + 1];
                                            ((FloatDHT_3D)FloatDHT_3D.this).t[n22 + ((FloatDHT_3D)FloatDHT_3D.this).n1] = fArray[n3 + 2];
                                            ((FloatDHT_3D)FloatDHT_3D.this).t[n22 + 2 * ((FloatDHT_3D)FloatDHT_3D.this).n1] = fArray[n3 + 3];
                                        }
                                        FloatDHT_3D.this.dhtn1.forward(FloatDHT_3D.this.t, n6);
                                        FloatDHT_3D.this.dhtn1.forward(FloatDHT_3D.this.t, n6 + FloatDHT_3D.this.n1);
                                        FloatDHT_3D.this.dhtn1.forward(FloatDHT_3D.this.t, n6 + 2 * FloatDHT_3D.this.n1);
                                        FloatDHT_3D.this.dhtn1.forward(FloatDHT_3D.this.t, n6 + 3 * FloatDHT_3D.this.n1);
                                        for (n4 = 0; n4 < FloatDHT_3D.this.n1; ++n4) {
                                            n3 = n4 * FloatDHT_3D.this.sliceStride + n12 + j;
                                            n22 = n6 + FloatDHT_3D.this.n1 + n4;
                                            fArray[n3] = FloatDHT_3D.this.t[n6 + n4];
                                            fArray[n3 + 1] = FloatDHT_3D.this.t[n22];
                                            fArray[n3 + 2] = FloatDHT_3D.this.t[n22 + FloatDHT_3D.this.n1];
                                            fArray[n3 + 3] = FloatDHT_3D.this.t[n22 + 2 * FloatDHT_3D.this.n1];
                                        }
                                    }
                                }
                                break block19;
                            }
                            if (FloatDHT_3D.this.n3 != 2) break block19;
                            for (int i = n2; i < FloatDHT_3D.this.n2; i += n5) {
                                int n13;
                                int n52;
                                int n62 = i * FloatDHT_3D.this.rowStride;
                                for (n52 = 0; n52 < FloatDHT_3D.this.n1; ++n52) {
                                    n13 = n52 * FloatDHT_3D.this.sliceStride + n62;
                                    ((FloatDHT_3D)FloatDHT_3D.this).t[n6 + n52] = fArray[n13];
                                    ((FloatDHT_3D)FloatDHT_3D.this).t[n6 + ((FloatDHT_3D)FloatDHT_3D.this).n1 + n52] = fArray[n13 + 1];
                                }
                                FloatDHT_3D.this.dhtn1.forward(FloatDHT_3D.this.t, n6);
                                FloatDHT_3D.this.dhtn1.forward(FloatDHT_3D.this.t, n6 + FloatDHT_3D.this.n1);
                                for (n52 = 0; n52 < FloatDHT_3D.this.n1; ++n52) {
                                    n13 = n52 * FloatDHT_3D.this.sliceStride + n62;
                                    fArray[n13] = FloatDHT_3D.this.t[n6 + n52];
                                    fArray[n13 + 1] = FloatDHT_3D.this.t[n6 + FloatDHT_3D.this.n1 + n52];
                                }
                            }
                            break block19;
                        }
                        if (FloatDHT_3D.this.n3 > 2) {
                            for (int i = n2; i < FloatDHT_3D.this.n2; i += n5) {
                                int n14 = i * FloatDHT_3D.this.rowStride;
                                for (int j = 0; j < FloatDHT_3D.this.n3; j += 4) {
                                    int n7;
                                    int n8;
                                    int n9;
                                    for (n9 = 0; n9 < FloatDHT_3D.this.n1; ++n9) {
                                        n8 = n9 * FloatDHT_3D.this.sliceStride + n14 + j;
                                        n7 = n6 + FloatDHT_3D.this.n1 + n9;
                                        ((FloatDHT_3D)FloatDHT_3D.this).t[n6 + n9] = fArray[n8];
                                        ((FloatDHT_3D)FloatDHT_3D.this).t[n7] = fArray[n8 + 1];
                                        ((FloatDHT_3D)FloatDHT_3D.this).t[n7 + ((FloatDHT_3D)FloatDHT_3D.this).n1] = fArray[n8 + 2];
                                        ((FloatDHT_3D)FloatDHT_3D.this).t[n7 + 2 * ((FloatDHT_3D)FloatDHT_3D.this).n1] = fArray[n8 + 3];
                                    }
                                    FloatDHT_3D.this.dhtn1.inverse(FloatDHT_3D.this.t, n6, bl);
                                    FloatDHT_3D.this.dhtn1.inverse(FloatDHT_3D.this.t, n6 + FloatDHT_3D.this.n1, bl);
                                    FloatDHT_3D.this.dhtn1.inverse(FloatDHT_3D.this.t, n6 + 2 * FloatDHT_3D.this.n1, bl);
                                    FloatDHT_3D.this.dhtn1.inverse(FloatDHT_3D.this.t, n6 + 3 * FloatDHT_3D.this.n1, bl);
                                    for (n9 = 0; n9 < FloatDHT_3D.this.n1; ++n9) {
                                        n8 = n9 * FloatDHT_3D.this.sliceStride + n14 + j;
                                        n7 = n6 + FloatDHT_3D.this.n1 + n9;
                                        fArray[n8] = FloatDHT_3D.this.t[n6 + n9];
                                        fArray[n8 + 1] = FloatDHT_3D.this.t[n7];
                                        fArray[n8 + 2] = FloatDHT_3D.this.t[n7 + FloatDHT_3D.this.n1];
                                        fArray[n8 + 3] = FloatDHT_3D.this.t[n7 + 2 * FloatDHT_3D.this.n1];
                                    }
                                }
                            }
                        } else if (FloatDHT_3D.this.n3 == 2) {
                            for (int i = n2; i < FloatDHT_3D.this.n2; i += n5) {
                                int n15;
                                int n10;
                                int n11 = i * FloatDHT_3D.this.rowStride;
                                for (n10 = 0; n10 < FloatDHT_3D.this.n1; ++n10) {
                                    n15 = n10 * FloatDHT_3D.this.sliceStride + n11;
                                    ((FloatDHT_3D)FloatDHT_3D.this).t[n6 + n10] = fArray[n15];
                                    ((FloatDHT_3D)FloatDHT_3D.this).t[n6 + ((FloatDHT_3D)FloatDHT_3D.this).n1 + n10] = fArray[n15 + 1];
                                }
                                FloatDHT_3D.this.dhtn1.inverse(FloatDHT_3D.this.t, n6, bl);
                                FloatDHT_3D.this.dhtn1.inverse(FloatDHT_3D.this.t, n6 + FloatDHT_3D.this.n1, bl);
                                for (n10 = 0; n10 < FloatDHT_3D.this.n1; ++n10) {
                                    n15 = n10 * FloatDHT_3D.this.sliceStride + n11;
                                    fArray[n15] = FloatDHT_3D.this.t[n6 + n10];
                                    fArray[n15 + 1] = FloatDHT_3D.this.t[n6 + FloatDHT_3D.this.n1 + n10];
                                }
                            }
                        }
                    }
                }
            });
        }
        try {
            for (n2 = 0; n2 < n3; ++n2) {
                futureArray[n2].get();
            }
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void ddxt3db_subth(final int n, final float[][][] fArray, final boolean bl) {
        int n2;
        int n3 = ConcurrencyUtils.getNumberOfProcessors();
        if (n3 > this.n2) {
            n3 = this.n2;
        }
        int n4 = 4 * this.n1;
        if (this.n3 == 2) {
            n4 >>= 1;
        }
        Future[] futureArray = new Future[n3];
        final int n5 = n3;
        for (int i = 0; i < n3; ++i) {
            n2 = i;
            final int n6 = n4 * i;
            futureArray[i] = ConcurrencyUtils.threadPool.submit(new Runnable(){

                public void run() {
                    block19: {
                        block17: {
                            block18: {
                                if (n != -1) break block17;
                                if (FloatDHT_3D.this.n3 <= 2) break block18;
                                for (int i = n2; i < FloatDHT_3D.this.n2; i += n5) {
                                    for (int j = 0; j < FloatDHT_3D.this.n3; j += 4) {
                                        int n4;
                                        int n22;
                                        for (n22 = 0; n22 < FloatDHT_3D.this.n1; ++n22) {
                                            n4 = n6 + FloatDHT_3D.this.n1 + n22;
                                            ((FloatDHT_3D)FloatDHT_3D.this).t[n6 + n22] = fArray[n22][i][j];
                                            ((FloatDHT_3D)FloatDHT_3D.this).t[n4] = fArray[n22][i][j + 1];
                                            ((FloatDHT_3D)FloatDHT_3D.this).t[n4 + ((FloatDHT_3D)FloatDHT_3D.this).n1] = fArray[n22][i][j + 2];
                                            ((FloatDHT_3D)FloatDHT_3D.this).t[n4 + 2 * ((FloatDHT_3D)FloatDHT_3D.this).n1] = fArray[n22][i][j + 3];
                                        }
                                        FloatDHT_3D.this.dhtn1.forward(FloatDHT_3D.this.t, n6);
                                        FloatDHT_3D.this.dhtn1.forward(FloatDHT_3D.this.t, n6 + FloatDHT_3D.this.n1);
                                        FloatDHT_3D.this.dhtn1.forward(FloatDHT_3D.this.t, n6 + 2 * FloatDHT_3D.this.n1);
                                        FloatDHT_3D.this.dhtn1.forward(FloatDHT_3D.this.t, n6 + 3 * FloatDHT_3D.this.n1);
                                        for (n22 = 0; n22 < FloatDHT_3D.this.n1; ++n22) {
                                            n4 = n6 + FloatDHT_3D.this.n1 + n22;
                                            fArray[n22][i][j] = FloatDHT_3D.this.t[n6 + n22];
                                            fArray[n22][i][j + 1] = FloatDHT_3D.this.t[n4];
                                            fArray[n22][i][j + 2] = FloatDHT_3D.this.t[n4 + FloatDHT_3D.this.n1];
                                            fArray[n22][i][j + 3] = FloatDHT_3D.this.t[n4 + 2 * FloatDHT_3D.this.n1];
                                        }
                                    }
                                }
                                break block19;
                            }
                            if (FloatDHT_3D.this.n3 != 2) break block19;
                            for (int i = n2; i < FloatDHT_3D.this.n2; i += n5) {
                                int n7;
                                for (n7 = 0; n7 < FloatDHT_3D.this.n1; ++n7) {
                                    ((FloatDHT_3D)FloatDHT_3D.this).t[n6 + n7] = fArray[n7][i][0];
                                    ((FloatDHT_3D)FloatDHT_3D.this).t[n6 + ((FloatDHT_3D)FloatDHT_3D.this).n1 + n7] = fArray[n7][i][1];
                                }
                                FloatDHT_3D.this.dhtn1.forward(FloatDHT_3D.this.t, n6);
                                FloatDHT_3D.this.dhtn1.forward(FloatDHT_3D.this.t, n6 + FloatDHT_3D.this.n1);
                                for (n7 = 0; n7 < FloatDHT_3D.this.n1; ++n7) {
                                    fArray[n7][i][0] = FloatDHT_3D.this.t[n6 + n7];
                                    fArray[n7][i][1] = FloatDHT_3D.this.t[n6 + FloatDHT_3D.this.n1 + n7];
                                }
                            }
                            break block19;
                        }
                        if (FloatDHT_3D.this.n3 > 2) {
                            for (int i = n2; i < FloatDHT_3D.this.n2; i += n5) {
                                for (int j = 0; j < FloatDHT_3D.this.n3; j += 4) {
                                    int n8;
                                    int n3;
                                    for (n3 = 0; n3 < FloatDHT_3D.this.n1; ++n3) {
                                        n8 = n6 + FloatDHT_3D.this.n1 + n3;
                                        ((FloatDHT_3D)FloatDHT_3D.this).t[n6 + n3] = fArray[n3][i][j];
                                        ((FloatDHT_3D)FloatDHT_3D.this).t[n8] = fArray[n3][i][j + 1];
                                        ((FloatDHT_3D)FloatDHT_3D.this).t[n8 + ((FloatDHT_3D)FloatDHT_3D.this).n1] = fArray[n3][i][j + 2];
                                        ((FloatDHT_3D)FloatDHT_3D.this).t[n8 + 2 * ((FloatDHT_3D)FloatDHT_3D.this).n1] = fArray[n3][i][j + 3];
                                    }
                                    FloatDHT_3D.this.dhtn1.inverse(FloatDHT_3D.this.t, n6, bl);
                                    FloatDHT_3D.this.dhtn1.inverse(FloatDHT_3D.this.t, n6 + FloatDHT_3D.this.n1, bl);
                                    FloatDHT_3D.this.dhtn1.inverse(FloatDHT_3D.this.t, n6 + 2 * FloatDHT_3D.this.n1, bl);
                                    FloatDHT_3D.this.dhtn1.inverse(FloatDHT_3D.this.t, n6 + 3 * FloatDHT_3D.this.n1, bl);
                                    for (n3 = 0; n3 < FloatDHT_3D.this.n1; ++n3) {
                                        n8 = n6 + FloatDHT_3D.this.n1 + n3;
                                        fArray[n3][i][j] = FloatDHT_3D.this.t[n6 + n3];
                                        fArray[n3][i][j + 1] = FloatDHT_3D.this.t[n8];
                                        fArray[n3][i][j + 2] = FloatDHT_3D.this.t[n8 + FloatDHT_3D.this.n1];
                                        fArray[n3][i][j + 3] = FloatDHT_3D.this.t[n8 + 2 * FloatDHT_3D.this.n1];
                                    }
                                }
                            }
                        } else if (FloatDHT_3D.this.n3 == 2) {
                            for (int i = n2; i < FloatDHT_3D.this.n2; i += n5) {
                                int n9;
                                for (n9 = 0; n9 < FloatDHT_3D.this.n1; ++n9) {
                                    ((FloatDHT_3D)FloatDHT_3D.this).t[n6 + n9] = fArray[n9][i][0];
                                    ((FloatDHT_3D)FloatDHT_3D.this).t[n6 + ((FloatDHT_3D)FloatDHT_3D.this).n1 + n9] = fArray[n9][i][1];
                                }
                                FloatDHT_3D.this.dhtn1.inverse(FloatDHT_3D.this.t, n6, bl);
                                FloatDHT_3D.this.dhtn1.inverse(FloatDHT_3D.this.t, n6 + FloatDHT_3D.this.n1, bl);
                                for (n9 = 0; n9 < FloatDHT_3D.this.n1; ++n9) {
                                    fArray[n9][i][0] = FloatDHT_3D.this.t[n6 + n9];
                                    fArray[n9][i][1] = FloatDHT_3D.this.t[n6 + FloatDHT_3D.this.n1 + n9];
                                }
                            }
                        }
                    }
                }
            });
        }
        try {
            for (n2 = 0; n2 < n3; ++n2) {
                futureArray[n2].get();
            }
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void makewt(int n) {
        this.ip[0] = n;
        this.ip[1] = 1;
        if (n > 2) {
            int n2;
            int n3 = n >> 1;
            float f = (float)(Math.atan(1.0) / (double)n3);
            float f2 = (float)Math.cos(f * (float)n3);
            this.w[0] = 1.0f;
            this.w[1] = f2;
            if (n3 == 4) {
                this.w[2] = (float)Math.cos(f * 2.0f);
                this.w[3] = (float)Math.sin(f * 2.0f);
            } else if (n3 > 4) {
                this.makeipt(n);
                this.w[2] = (float)(0.5 / Math.cos(f * 2.0f));
                this.w[3] = (float)(0.5 / Math.cos(f * 6.0f));
                for (n2 = 4; n2 < n3; n2 += 4) {
                    this.w[n2] = (float)Math.cos(f * (float)n2);
                    this.w[n2 + 1] = (float)Math.sin(f * (float)n2);
                    this.w[n2 + 2] = (float)Math.cos(3.0f * f * (float)n2);
                    this.w[n2 + 3] = (float)(-Math.sin(3.0f * f * (float)n2));
                }
            }
            int n4 = 0;
            while (n3 > 2) {
                float f3;
                float f4;
                int n5 = n4 + n3;
                this.w[n5] = 1.0f;
                this.w[n5 + 1] = f2;
                if ((n3 >>= 1) == 4) {
                    f4 = this.w[n4 + 4];
                    f3 = this.w[n4 + 5];
                    this.w[n5 + 2] = f4;
                    this.w[n5 + 3] = f3;
                } else if (n3 > 4) {
                    f4 = this.w[n4 + 4];
                    float f5 = this.w[n4 + 6];
                    this.w[n5 + 2] = (float)(0.5 / (double)f4);
                    this.w[n5 + 3] = (float)(0.5 / (double)f5);
                    for (n2 = 4; n2 < n3; n2 += 4) {
                        int n6 = n4 + 2 * n2;
                        int n7 = n5 + n2;
                        f4 = this.w[n6];
                        f3 = this.w[n6 + 1];
                        f5 = this.w[n6 + 2];
                        float f6 = this.w[n6 + 3];
                        this.w[n7] = f4;
                        this.w[n7 + 1] = f3;
                        this.w[n7 + 2] = f5;
                        this.w[n7 + 3] = f6;
                    }
                }
                n4 = n5;
            }
        }
    }

    private void makeipt(int n) {
        this.ip[2] = 0;
        this.ip[3] = 16;
        int n2 = 2;
        for (int i = n; i > 32; i >>= 2) {
            int n3 = n2 << 1;
            int n4 = n3 << 3;
            for (int j = n2; j < n3; ++j) {
                int n5;
                this.ip[n2 + j] = n5 = this.ip[j] << 2;
                this.ip[n3 + j] = n5 + n4;
            }
            n2 = n3;
        }
    }

    private void makect(int n, float[] fArray, int n2) {
        this.ip[1] = n;
        if (n > 1) {
            int n3 = n >> 1;
            float f = (float)Math.atan(1.0) / (float)n3;
            fArray[n2] = (float)Math.cos(f * (float)n3);
            fArray[n2 + n3] = 0.5f * fArray[n2];
            for (int i = 1; i < n3; ++i) {
                fArray[n2 + i] = (float)(0.5 * Math.cos(f * (float)i));
                fArray[n2 + n - i] = (float)(0.5 * Math.sin(f * (float)i));
            }
        }
    }

    private void y_transform(float[] fArray) {
        for (int i = 0; i <= this.n1 / 2; ++i) {
            int n = (this.n1 - i) % this.n1;
            for (int j = 0; j <= this.n2 / 2; ++j) {
                int n2 = (this.n2 - j) % this.n2;
                for (int k = 0; k <= this.n3 / 2; ++k) {
                    int n3 = (this.n3 - k) % this.n3;
                    int n4 = i * this.sliceStride + n2 * this.rowStride + k;
                    int n5 = i * this.sliceStride + j * this.rowStride + n3;
                    int n6 = n * this.sliceStride + j * this.rowStride + k;
                    int n7 = n * this.sliceStride + n2 * this.rowStride + n3;
                    int n8 = n * this.sliceStride + n2 * this.rowStride + k;
                    int n9 = n * this.sliceStride + j * this.rowStride + n3;
                    int n10 = i * this.sliceStride + j * this.rowStride + k;
                    int n11 = i * this.sliceStride + n2 * this.rowStride + n3;
                    float f = fArray[n4];
                    float f2 = fArray[n5];
                    float f3 = fArray[n6];
                    float f4 = fArray[n7];
                    float f5 = fArray[n8];
                    float f6 = fArray[n9];
                    float f7 = fArray[n10];
                    float f8 = fArray[n11];
                    fArray[n10] = (f + f2 + f3 - f4) / 2.0f;
                    fArray[n6] = (f5 + f6 + f7 - f8) / 2.0f;
                    fArray[n4] = (f7 + f8 + f5 - f6) / 2.0f;
                    fArray[n8] = (f3 + f4 + f - f2) / 2.0f;
                    fArray[n5] = (f8 + f7 + f6 - f5) / 2.0f;
                    fArray[n9] = (f4 + f3 + f2 - f) / 2.0f;
                    fArray[n11] = (f2 + f + f4 - f3) / 2.0f;
                    fArray[n7] = (f6 + f5 + f8 - f7) / 2.0f;
                }
            }
        }
    }

    private void y_transform(float[][][] fArray) {
        for (int i = 0; i <= this.n1 / 2; ++i) {
            int n = (this.n1 - i) % this.n1;
            for (int j = 0; j <= this.n2 / 2; ++j) {
                int n2 = (this.n2 - j) % this.n2;
                for (int k = 0; k <= this.n3 / 2; ++k) {
                    int n3 = (this.n3 - k) % this.n3;
                    float f = fArray[i][n2][k];
                    float f2 = fArray[i][j][n3];
                    float f3 = fArray[n][j][k];
                    float f4 = fArray[n][n2][n3];
                    float f5 = fArray[n][n2][k];
                    float f6 = fArray[n][j][n3];
                    float f7 = fArray[i][j][k];
                    float f8 = fArray[i][n2][n3];
                    fArray[i][j][k] = (f + f2 + f3 - f4) / 2.0f;
                    fArray[n][j][k] = (f5 + f6 + f7 - f8) / 2.0f;
                    fArray[i][n2][k] = (f7 + f8 + f5 - f6) / 2.0f;
                    fArray[n][n2][k] = (f3 + f4 + f - f2) / 2.0f;
                    fArray[i][j][n3] = (f8 + f7 + f6 - f5) / 2.0f;
                    fArray[n][j][n3] = (f4 + f3 + f2 - f) / 2.0f;
                    fArray[i][n2][n3] = (f2 + f + f4 - f3) / 2.0f;
                    fArray[n][n2][n3] = (f6 + f5 + f8 - f7) / 2.0f;
                }
            }
        }
    }
}

