/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.operations.userdefined;

import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.PagingState;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.Token;
import com.datastax.driver.core.TokenRange;
import io.netty.util.concurrent.FastThreadLocal;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.naming.OperationNotSupportedException;
import org.apache.cassandra.stress.Operation;
import org.apache.cassandra.stress.StressYaml;
import org.apache.cassandra.stress.WorkManager;
import org.apache.cassandra.stress.generate.TokenRangeIterator;
import org.apache.cassandra.stress.report.Timer;
import org.apache.cassandra.stress.settings.StressSettings;
import org.apache.cassandra.stress.util.JavaDriverClient;
import org.apache.cassandra.stress.util.ThriftClient;

public class TokenRangeQuery
extends Operation {
    private final FastThreadLocal<State> currentState = new FastThreadLocal();
    private final TableMetadata tableMetadata;
    private final TokenRangeIterator tokenRangeIterator;
    private final String columns;
    private final int pageSize;
    private final boolean isWarmup;

    public TokenRangeQuery(Timer timer, StressSettings settings, TableMetadata tableMetadata, TokenRangeIterator tokenRangeIterator, StressYaml.TokenRangeQueryDef def, boolean isWarmup) {
        super(timer, settings);
        this.tableMetadata = tableMetadata;
        this.tokenRangeIterator = tokenRangeIterator;
        this.columns = TokenRangeQuery.sanitizeColumns(def.columns, tableMetadata);
        this.pageSize = isWarmup ? Math.min(100, def.page_size) : def.page_size;
        this.isWarmup = isWarmup;
    }

    private static String sanitizeColumns(String columns, TableMetadata tableMetadata) {
        if (!columns.equals("*")) {
            return columns;
        }
        return String.join((CharSequence)", ", tableMetadata.getColumns().stream().map(ColumnMetadata::getName).collect(Collectors.toList()));
    }

    private String buildQuery(TokenRange tokenRange) {
        Token start = tokenRange.getStart();
        Token end = tokenRange.getEnd();
        List pkColumns = this.tableMetadata.getPartitionKey().stream().map(ColumnMetadata::getName).collect(Collectors.toList());
        String tokenStatement = String.format("token(%s)", String.join((CharSequence)", ", pkColumns));
        StringBuilder ret = new StringBuilder();
        ret.append("SELECT ");
        ret.append(tokenStatement);
        ret.append(", ");
        ret.append(this.columns);
        ret.append(" FROM ");
        ret.append(this.tableMetadata.getName());
        if (start != null || end != null) {
            ret.append(" WHERE ");
        }
        if (start != null) {
            ret.append(tokenStatement);
            ret.append(" > ");
            ret.append(start.toString());
        }
        if (start != null && end != null) {
            ret.append(" AND ");
        }
        if (end != null) {
            ret.append(tokenStatement);
            ret.append(" <= ");
            ret.append(end.toString());
        }
        return ret.toString();
    }

    @Override
    public void run(JavaDriverClient client) throws IOException {
        this.timeWithRetry(new JavaDriverRun(client));
    }

    @Override
    public void run(ThriftClient client) throws IOException {
        this.timeWithRetry(new ThriftRun(client));
    }

    @Override
    public int ready(WorkManager workManager) {
        this.tokenRangeIterator.update();
        if (this.tokenRangeIterator.exhausted() && this.currentState.get() == null) {
            return 0;
        }
        int numLeft = workManager.takePermits(1);
        return numLeft > 0 ? 1 : 0;
    }

    @Override
    public String key() {
        State state = (State)this.currentState.get();
        return state == null ? "-" : state.toString();
    }

    private static class ThriftRun
    extends Runner {
        final ThriftClient client;

        private ThriftRun(ThriftClient client) {
            this.client = client;
        }

        @Override
        public boolean run() throws Exception {
            throw new OperationNotSupportedException("Bulk read over thrift not supported");
        }
    }

    private class JavaDriverRun
    extends Runner {
        final JavaDriverClient client;

        private JavaDriverRun(JavaDriverClient client) {
            this.client = client;
        }

        @Override
        public boolean run() throws Exception {
            State state = (State)TokenRangeQuery.this.currentState.get();
            if (state == null) {
                TokenRange range = TokenRangeQuery.this.tokenRangeIterator.next();
                if (range == null) {
                    return true;
                }
                state = new State(range, TokenRangeQuery.this.buildQuery(range));
                TokenRangeQuery.this.currentState.set((Object)state);
            }
            SimpleStatement statement = new SimpleStatement(state.query);
            statement.setFetchSize(TokenRangeQuery.this.pageSize);
            if (state.pagingState != null) {
                statement.setPagingState(state.pagingState);
            }
            ResultSet results = this.client.getSession().execute((Statement)statement);
            state.pagingState = results.getExecutionInfo().getPagingState();
            int remaining = results.getAvailableWithoutFetching();
            this.rowCount += remaining;
            for (Row row : results) {
                Token partition = row.getPartitionKeyToken();
                if (!state.partitions.contains(partition)) {
                    ++this.partitionCount;
                    state.partitions.add(partition);
                }
                if (--remaining != 0) continue;
                break;
            }
            if (results.isExhausted() || TokenRangeQuery.this.isWarmup) {
                TokenRangeQuery.this.currentState.set(null);
            }
            return true;
        }
    }

    static abstract class Runner
    implements Operation.RunOp {
        int partitionCount;
        int rowCount;

        Runner() {
        }

        @Override
        public int partitionCount() {
            return this.partitionCount;
        }

        @Override
        public int rowCount() {
            return this.rowCount;
        }
    }

    private static final class State {
        public final TokenRange tokenRange;
        public final String query;
        public PagingState pagingState;
        public Set<Token> partitions = new HashSet<Token>();

        public State(TokenRange tokenRange, String query) {
            this.tokenRange = tokenRange;
            this.query = query;
        }

        public String toString() {
            return String.format("[%s, %s]", this.tokenRange.getStart(), this.tokenRange.getEnd());
        }
    }
}

