/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.stats;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.MethodHandles;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.Term;
import org.apache.solr.common.util.Utils;
import org.apache.solr.search.stats.CollectionStats;
import org.apache.solr.search.stats.TermStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsUtil {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String ENTRY_SEPARATOR = "!";
    public static final char ENTRY_SEPARATOR_CHAR = '!';
    public static final char ESCAPE = '_';
    public static final char ESCAPE_ENTRY_SEPARATOR = '0';

    public static String shardUrlToShard(String collectionName, String shardUrls) {
        String shard;
        String[] urls = shardUrls.split("\\|");
        if (urls.length == 0) {
            return null;
        }
        String[] urlParts = urls[0].split("/");
        String coreName = urlParts[urlParts.length - 1];
        String replicaName = Utils.parseMetricsReplicaName((String)collectionName, (String)coreName);
        if (replicaName != null) {
            shard = coreName.substring(collectionName.length() + 1);
            shard = shard.substring(0, shard.length() - replicaName.length() - 1);
        } else if (coreName.length() > collectionName.length() && coreName.startsWith(collectionName)) {
            shard = coreName.substring(collectionName.length() + 1);
            if (shard.isEmpty()) {
                shard = urls[0];
            }
        } else {
            shard = urls[0];
        }
        return shard;
    }

    public static String termsToEncodedString(Collection<?> terms) {
        StringBuilder sb = new StringBuilder();
        for (Object o : terms) {
            if (sb.length() > 0) {
                sb.append(ENTRY_SEPARATOR);
            }
            if (o instanceof Term) {
                sb.append(StatsUtil.termToEncodedString((Term)o));
                continue;
            }
            sb.append(StatsUtil.termToEncodedString(String.valueOf(o)));
        }
        return sb.toString();
    }

    public static Set<Term> termsFromEncodedString(String data) {
        String[] items;
        HashSet<Term> terms = new HashSet<Term>();
        if (data == null || data.trim().isEmpty()) {
            return terms;
        }
        for (String item : items = data.split(ENTRY_SEPARATOR)) {
            Term t = StatsUtil.termFromEncodedString(item);
            if (t == null) continue;
            terms.add(t);
        }
        return terms;
    }

    public static Set<String> fieldsFromString(String data) {
        String[] items;
        HashSet<String> fields = new HashSet<String>();
        if (data == null || data.trim().isEmpty()) {
            return fields;
        }
        for (String item : items = data.split(ENTRY_SEPARATOR)) {
            if (item.trim().isEmpty()) continue;
            fields.add(item);
        }
        return fields;
    }

    public static String fieldsToString(Collection<String> fields) {
        StringBuilder sb = new StringBuilder();
        for (String field : fields) {
            if (field.trim().isEmpty()) continue;
            if (sb.length() > 0) {
                sb.append(ENTRY_SEPARATOR);
            }
            sb.append(field);
        }
        return sb.toString();
    }

    public static String colStatsToString(CollectionStats colStats) {
        StringBuilder sb = new StringBuilder();
        sb.append(colStats.field);
        sb.append(',');
        sb.append(colStats.maxDoc);
        sb.append(',');
        sb.append(colStats.docCount);
        sb.append(',');
        sb.append(colStats.sumTotalTermFreq);
        sb.append(',');
        sb.append(colStats.sumDocFreq);
        return sb.toString();
    }

    private static CollectionStats colStatsFromString(String data) {
        if (data == null || data.trim().length() == 0) {
            log.warn("Invalid empty collection stats string");
            return null;
        }
        String[] vals = data.split(",");
        if (vals.length != 5) {
            log.warn("Invalid collection stats string, num fields {} != 5 '{}'", (Object)vals.length, (Object)data);
            return null;
        }
        String field = vals[0];
        try {
            long maxDoc = Long.parseLong(vals[1]);
            long docCount = Long.parseLong(vals[2]);
            long sumTotalTermFreq = Long.parseLong(vals[3]);
            long sumDocFreq = Long.parseLong(vals[4]);
            return new CollectionStats(field, maxDoc, docCount, sumTotalTermFreq, sumDocFreq);
        }
        catch (Exception e) {
            log.warn("Invalid collection stats string '{}', ", (Object)data, (Object)e);
            return null;
        }
    }

    public static String termToEncodedString(Term t) {
        StringBuilder sb = new StringBuilder();
        sb.append(t.field()).append(':');
        sb.append(StatsUtil.encode(t.text()));
        return sb.toString();
    }

    public static String encode(String value) {
        StringBuilder output = new StringBuilder(value.length() + 2);
        block6: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '_': {
                    output.append('_').append('_');
                    continue block6;
                }
                case '!': {
                    output.append('_').append('0');
                    continue block6;
                }
                default: {
                    output.append(c);
                }
            }
        }
        try {
            return URLEncoder.encode(output.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Apparently your JVM doesn't support UTF-8 encoding?", e);
        }
    }

    public static String decode(String value) throws IOException {
        value = URLDecoder.decode(value, "UTF-8");
        StringBuilder output = new StringBuilder(value.length());
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '_' && i < value.length() - 1) {
                char next;
                if ((next = value.charAt(++i)) == '_') {
                    output.append('_');
                    continue;
                }
                if (next == '0') {
                    output.append('!');
                    continue;
                }
                throw new IOException("invalid escape sequence in " + value);
            }
            output.append(c);
        }
        return output.toString();
    }

    public static String termToEncodedString(String term) {
        int idx = term.indexOf(58);
        if (idx == -1) {
            log.warn("Invalid term data without ':': '{}'", (Object)term);
            return null;
        }
        String prefix = term.substring(0, idx + 1);
        String value = term.substring(idx + 1);
        return prefix + StatsUtil.encode(value);
    }

    public static Term termFromEncodedString(String data) {
        if (data == null || data.trim().length() == 0) {
            log.warn("Invalid empty term value");
            return null;
        }
        int idx = data.indexOf(58);
        if (idx == -1) {
            log.warn("Invalid term data without ':': '{}'", (Object)data);
            return null;
        }
        String field = data.substring(0, idx);
        String value = data.substring(idx + 1);
        try {
            return new Term(field, StatsUtil.decode(value));
        }
        catch (Exception e) {
            log.warn("Invalid term value '{}'", (Object)value);
            return null;
        }
    }

    public static String termStatsToString(TermStats termStats, boolean encode) {
        StringBuilder sb = new StringBuilder();
        sb.append(encode ? StatsUtil.termToEncodedString(termStats.term) : termStats.term).append(',');
        sb.append(termStats.docFreq);
        sb.append(',');
        sb.append(termStats.totalTermFreq);
        return sb.toString();
    }

    private static TermStats termStatsFromString(String data) {
        if (data == null || data.trim().length() == 0) {
            log.warn("Invalid empty term stats string");
            return null;
        }
        String[] vals = data.split(",");
        if (vals.length < 3) {
            log.warn("Invalid term stats string, num fields {} < 3, '{}'", (Object)vals.length, (Object)data);
            return null;
        }
        Term term = StatsUtil.termFromEncodedString(vals[0]);
        try {
            long docFreq = Long.parseLong(vals[1]);
            long totalTermFreq = Long.parseLong(vals[2]);
            return new TermStats(term.toString(), docFreq, totalTermFreq);
        }
        catch (Exception e) {
            log.warn("Invalid termStats string '{}'", (Object)data);
            return null;
        }
    }

    public static Map<String, CollectionStats> colStatsMapFromString(String data) {
        String[] entries;
        if (data == null || data.trim().length() == 0) {
            return null;
        }
        HashMap<String, CollectionStats> map = new HashMap<String, CollectionStats>();
        for (String es : entries = data.split(ENTRY_SEPARATOR)) {
            CollectionStats stats = StatsUtil.colStatsFromString(es);
            if (stats == null) continue;
            map.put(stats.field, stats);
        }
        return map;
    }

    public static String colStatsMapToString(Map<String, CollectionStats> stats) {
        if (stats == null || stats.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, CollectionStats> e : stats.entrySet()) {
            if (sb.length() > 0) {
                sb.append(ENTRY_SEPARATOR);
            }
            sb.append(StatsUtil.colStatsToString(e.getValue()));
        }
        return sb.toString();
    }

    public static Map<String, TermStats> termStatsMapFromString(String data) {
        String[] entries;
        if (data == null || data.trim().length() == 0) {
            return null;
        }
        HashMap<String, TermStats> map = new HashMap<String, TermStats>();
        for (String es : entries = data.split(ENTRY_SEPARATOR)) {
            TermStats termStats = StatsUtil.termStatsFromString(es);
            if (termStats == null) continue;
            map.put(termStats.term, termStats);
        }
        return map;
    }

    public static String termStatsMapToString(Map<String, TermStats> stats) {
        if (stats == null || stats.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, TermStats> e : stats.entrySet()) {
            if (sb.length() > 0) {
                sb.append(ENTRY_SEPARATOR);
            }
            sb.append(StatsUtil.termStatsToString(e.getValue(), true));
        }
        return sb.toString();
    }
}

