/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.ltr;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Rescorer;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.search.Weight;
import org.apache.solr.ltr.FeatureLogger;
import org.apache.solr.ltr.LTRScoringQuery;
import org.apache.solr.ltr.interleaving.OriginalRankingLTRScoringQuery;
import org.apache.solr.search.SolrIndexSearcher;

public class LTRRescorer
extends Rescorer {
    private final LTRScoringQuery scoringQuery;
    private static final Comparator<ScoreDoc> docComparator = Comparator.comparingInt(a -> a.doc);
    protected static final Comparator<ScoreDoc> scoreComparator = (a, b) -> {
        if (a.score > b.score) {
            return -1;
        }
        if (a.score < b.score) {
            return 1;
        }
        return a.doc - b.doc;
    };

    public LTRRescorer() {
        this.scoringQuery = null;
    }

    public LTRRescorer(LTRScoringQuery scoringQuery) {
        this.scoringQuery = scoringQuery;
    }

    protected static void heapAdjust(ScoreDoc[] hits, int size, int root) {
        ScoreDoc doc = hits[root];
        float score = doc.score;
        int i = root;
        while (i <= (size >> 1) - 1) {
            int lchild = (i << 1) + 1;
            ScoreDoc ldoc = hits[lchild];
            float lscore = ldoc.score;
            float rscore = Float.MAX_VALUE;
            int rchild = (i << 1) + 2;
            ScoreDoc rdoc = null;
            if (rchild < size) {
                rdoc = hits[rchild];
                rscore = rdoc.score;
            }
            if (lscore < score) {
                if (rscore < lscore) {
                    hits[i] = rdoc;
                    hits[rchild] = doc;
                    i = rchild;
                    continue;
                }
                hits[i] = ldoc;
                hits[lchild] = doc;
                i = lchild;
                continue;
            }
            if (rscore < score) {
                hits[i] = rdoc;
                hits[rchild] = doc;
                i = rchild;
                continue;
            }
            return;
        }
    }

    protected static void heapify(ScoreDoc[] hits, int size) {
        for (int i = (size >> 1) - 1; i >= 0; --i) {
            LTRRescorer.heapAdjust(hits, size, i);
        }
    }

    public TopDocs rescore(IndexSearcher searcher, TopDocs firstPassTopDocs, int topN) throws IOException {
        if (topN == 0 || firstPassTopDocs.scoreDocs.length == 0) {
            return firstPassTopDocs;
        }
        ScoreDoc[] firstPassResults = LTRRescorer.getFirstPassDocsRanked(firstPassTopDocs);
        topN = Math.toIntExact(Math.min((long)topN, firstPassTopDocs.totalHits.value));
        ScoreDoc[] reranked = this.rerank(searcher, topN, firstPassResults);
        return new TopDocs(firstPassTopDocs.totalHits, reranked);
    }

    private ScoreDoc[] rerank(IndexSearcher searcher, int topN, ScoreDoc[] firstPassResults) throws IOException {
        ScoreDoc[] reranked = new ScoreDoc[topN];
        List leaves = searcher.getIndexReader().leaves();
        LTRScoringQuery.ModelWeight modelWeight = (LTRScoringQuery.ModelWeight)searcher.createWeight(searcher.rewrite((Query)this.scoringQuery), ScoreMode.COMPLETE, 1.0f);
        this.scoreFeatures(searcher, topN, modelWeight, firstPassResults, leaves, reranked);
        Arrays.sort(reranked, scoreComparator);
        return reranked;
    }

    @Deprecated
    protected static void sortByScore(ScoreDoc[] reranked) {
        Arrays.sort(reranked, scoreComparator);
    }

    protected static ScoreDoc[] getFirstPassDocsRanked(TopDocs firstPassTopDocs) {
        ScoreDoc[] hits = firstPassTopDocs.scoreDocs;
        Arrays.sort(hits, docComparator);
        assert (firstPassTopDocs.totalHits.relation == TotalHits.Relation.EQUAL_TO);
        return hits;
    }

    public void scoreFeatures(IndexSearcher indexSearcher, int topN, LTRScoringQuery.ModelWeight modelWeight, ScoreDoc[] hits, List<LeafReaderContext> leaves, ScoreDoc[] reranked) throws IOException {
        int readerUpto = -1;
        int endDoc = 0;
        int docBase = 0;
        LTRScoringQuery.ModelWeight.ModelScorer scorer = null;
        for (int hitUpto = 0; hitUpto < hits.length; ++hitUpto) {
            ScoreDoc hit = hits[hitUpto];
            int docID = hit.doc;
            LeafReaderContext readerContext = null;
            while (docID >= endDoc) {
                readerContext = leaves.get(++readerUpto);
                endDoc = readerContext.docBase + readerContext.reader().maxDoc();
            }
            if (readerContext != null) {
                docBase = readerContext.docBase;
                scorer = modelWeight.scorer(readerContext);
            }
            if (!LTRRescorer.scoreSingleHit(topN, docBase, hitUpto, hit, docID, scorer, reranked)) continue;
            LTRRescorer.logSingleHit(indexSearcher, modelWeight, hit.doc, this.scoringQuery);
        }
    }

    @Deprecated
    protected static void scoreSingleHit(IndexSearcher indexSearcher, int topN, LTRScoringQuery.ModelWeight modelWeight, int docBase, int hitUpto, ScoreDoc hit, int docID, LTRScoringQuery rerankingQuery, LTRScoringQuery.ModelWeight.ModelScorer scorer, ScoreDoc[] reranked) throws IOException {
        if (LTRRescorer.scoreSingleHit(topN, docBase, hitUpto, hit, docID, scorer, reranked)) {
            LTRRescorer.logSingleHit(indexSearcher, modelWeight, hit.doc, rerankingQuery);
        }
    }

    protected static void logSingleHit(IndexSearcher indexSearcher, LTRScoringQuery.ModelWeight modelWeight, int docid, LTRScoringQuery scoringQuery) {
        FeatureLogger featureLogger = scoringQuery.getFeatureLogger();
        if (featureLogger != null && indexSearcher instanceof SolrIndexSearcher) {
            featureLogger.log(docid, scoringQuery, (SolrIndexSearcher)indexSearcher, modelWeight.getFeaturesInfo());
        }
    }

    protected static boolean scoreSingleHit(int topN, int docBase, int hitUpto, ScoreDoc hit, int docID, LTRScoringQuery.ModelWeight.ModelScorer scorer, ScoreDoc[] reranked) throws IOException {
        assert (scorer != null);
        int targetDoc = docID - docBase;
        scorer.docID();
        scorer.iterator().advance(targetDoc);
        boolean logHit = false;
        scorer.getDocInfo().setOriginalDocScore(Float.valueOf(hit.score));
        hit.score = scorer.score();
        if (hitUpto < topN) {
            reranked[hitUpto] = hit;
            logHit = true;
        } else if (hitUpto == topN) {
            LTRRescorer.heapify(reranked, topN);
        }
        if (hitUpto >= topN && hit.score > reranked[0].score) {
            reranked[0] = hit;
            LTRRescorer.heapAdjust(reranked, topN, 0);
            logHit = true;
        }
        return logHit;
    }

    public Explanation explain(IndexSearcher searcher, Explanation firstPassExplanation, int docID) throws IOException {
        return LTRRescorer.getExplanation(searcher, docID, this.scoringQuery);
    }

    protected static Explanation getExplanation(IndexSearcher searcher, int docID, LTRScoringQuery rerankingQuery) throws IOException {
        List leafContexts = searcher.getTopReaderContext().leaves();
        int n = ReaderUtil.subIndex((int)docID, (List)leafContexts);
        LeafReaderContext context = (LeafReaderContext)leafContexts.get(n);
        int deBasedDoc = docID - context.docBase;
        Weight rankingWeight = rerankingQuery instanceof OriginalRankingLTRScoringQuery ? rerankingQuery.getOriginalQuery().createWeight(searcher, ScoreMode.COMPLETE, 1.0f) : searcher.createWeight(searcher.rewrite((Query)rerankingQuery), ScoreMode.COMPLETE, 1.0f);
        return rankingWeight.explain(context, deBasedDoc);
    }

    public static LTRScoringQuery.FeatureInfo[] extractFeaturesInfo(LTRScoringQuery.ModelWeight modelWeight, int docid, Float originalDocScore, List<LeafReaderContext> leafContexts) throws IOException {
        int n = ReaderUtil.subIndex((int)docid, leafContexts);
        LeafReaderContext atomicContext = leafContexts.get(n);
        int deBasedDoc = docid - atomicContext.docBase;
        LTRScoringQuery.ModelWeight.ModelScorer r = modelWeight.scorer(atomicContext);
        if (r == null || r.iterator().advance(deBasedDoc) != deBasedDoc) {
            return new LTRScoringQuery.FeatureInfo[0];
        }
        if (originalDocScore != null) {
            r.getDocInfo().setOriginalDocScore(originalDocScore);
        }
        r.score();
        return modelWeight.getFeaturesInfo();
    }
}

