/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.functions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.BuiltinFunction;
import net.thisptr.jackson.jq.internal.misc.Preconditions;

@BuiltinFunction(value={"to_entries/0"})
public class ToEntriesFunction
implements Function {
    @Override
    public List<JsonNode> apply(Scope scope, List<JsonQuery> args, JsonNode in) throws JsonQueryException {
        Preconditions.checkInputType("to_entries", in, JsonNodeType.OBJECT);
        ArrayNode out = scope.getObjectMapper().createArrayNode();
        Iterator iter = in.fields();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            ObjectNode entryNode = scope.getObjectMapper().createObjectNode();
            entryNode.set("key", (JsonNode)new TextNode((String)entry.getKey()));
            entryNode.set("value", (JsonNode)entry.getValue());
            out.add((JsonNode)entryNode);
        }
        return Collections.singletonList(out);
    }
}

