/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import org.apache.solr.analytics.util.function.FloatConsumer;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.FloatValue;
import org.apache.solr.analytics.value.FloatValueStream;
import org.apache.solr.common.SolrException;

class FloatStreamReplaceFunction
extends FloatValueStream.AbstractFloatValueStream {
    private final FloatValueStream baseExpr;
    private final FloatValue compExpr;
    private final FloatValue fillExpr;
    public static final String name = "replace";
    private final String exprStr;
    private final AnalyticsValueStream.ExpressionType funcType;

    public FloatStreamReplaceFunction(FloatValueStream baseExpr, FloatValue compExpr, FloatValue fillExpr) throws SolrException {
        this.baseExpr = baseExpr;
        this.compExpr = compExpr;
        this.fillExpr = fillExpr;
        this.exprStr = AnalyticsValueStream.createExpressionString(name, baseExpr, compExpr, fillExpr);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, compExpr, fillExpr);
    }

    @Override
    public void streamFloats(FloatConsumer cons) {
        float compValue = this.compExpr.getFloat();
        if (this.compExpr.exists()) {
            float fillValue = this.fillExpr.getFloat();
            boolean fillExists = this.fillExpr.exists();
            this.baseExpr.streamFloats(value -> {
                if (value == compValue) {
                    if (fillExists) {
                        cons.accept(fillValue);
                    }
                } else {
                    cons.accept(value);
                }
            });
        } else {
            this.baseExpr.streamFloats(cons);
        }
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

