/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.hibernate.connectionprovider;

import java.util.Properties;
import org.hibernate.connection.C3P0ConnectionProvider;
import org.jasypt.encryption.pbe.PBEStringEncryptor;
import org.jasypt.exceptions.EncryptionInitializationException;
import org.jasypt.hibernate.encryptor.HibernatePBEEncryptorRegistry;
import org.jasypt.properties.PropertyValueEncryptionUtils;

public class EncryptedPasswordC3P0ConnectionProvider
extends C3P0ConnectionProvider {
    public void configure(Properties props) {
        String encryptorRegisteredName = props.getProperty("hibernate.connection.encryptor_registered_name");
        HibernatePBEEncryptorRegistry encryptorRegistry = HibernatePBEEncryptorRegistry.getInstance();
        PBEStringEncryptor encryptor = encryptorRegistry.getPBEStringEncryptor(encryptorRegisteredName);
        if (encryptor == null) {
            throw new EncryptionInitializationException("No string encryptor registered for hibernate with name \"" + encryptorRegisteredName + "\"");
        }
        String driver = props.getProperty("hibernate.connection.driver_class");
        String url = props.getProperty("hibernate.connection.url");
        String user = props.getProperty("hibernate.connection.username");
        String password = props.getProperty("hibernate.connection.password");
        if (PropertyValueEncryptionUtils.isEncryptedValue(driver)) {
            props.setProperty("hibernate.connection.driver_class", PropertyValueEncryptionUtils.decrypt(driver, encryptor));
        }
        if (PropertyValueEncryptionUtils.isEncryptedValue(url)) {
            props.setProperty("hibernate.connection.url", PropertyValueEncryptionUtils.decrypt(url, encryptor));
        }
        if (PropertyValueEncryptionUtils.isEncryptedValue(user)) {
            props.setProperty("hibernate.connection.username", PropertyValueEncryptionUtils.decrypt(user, encryptor));
        }
        if (PropertyValueEncryptionUtils.isEncryptedValue(password)) {
            props.setProperty("hibernate.connection.password", PropertyValueEncryptionUtils.decrypt(password, encryptor));
        }
        super.configure(props);
    }
}

