/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.transport;

import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.Executor;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.fusesource.hawtdispatch.Task;
import org.fusesource.hawtdispatch.transport.SslTransport;
import org.fusesource.hawtdispatch.transport.TcpTransport;
import org.fusesource.hawtdispatch.transport.TcpTransportServer;

public class SslTransportServer
extends TcpTransportServer {
    protected KeyManager[] keyManagers;
    private TrustManager[] trustManagers;
    protected String protocol = "TLS";
    protected SSLContext sslContext;
    protected Executor blockingExecutor;
    private String clientAuth = "want";

    public static SslTransportServer createTransportServer(URI uri) throws Exception {
        return new SslTransportServer(uri);
    }

    public SslTransportServer(URI location) throws Exception {
        super(location);
        this.setSSLContext(SSLContext.getInstance(SslTransport.protocol(location.getScheme())));
    }

    public void setKeyManagers(KeyManager[] keyManagers) {
        this.keyManagers = keyManagers;
    }

    public void setTrustManagers(TrustManager[] trustManagers) {
        this.trustManagers = trustManagers;
    }

    public void start(Task onCompleted) throws Exception {
        if (this.keyManagers != null) {
            this.sslContext.init(this.keyManagers, this.trustManagers, null);
        } else {
            this.sslContext = SSLContext.getDefault();
        }
        super.start(onCompleted);
    }

    protected TcpTransport createTransport() {
        SslTransport rc = new SslTransport();
        rc.setSSLContext(this.sslContext);
        rc.setBlockingExecutor(this.blockingExecutor);
        rc.setClientAuth(this.clientAuth);
        return rc;
    }

    public SslTransportServer protocol(String value) throws NoSuchAlgorithmException {
        this.protocol = value;
        this.sslContext = SSLContext.getInstance(this.protocol);
        return this;
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    public void setSSLContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public Executor getBlockingExecutor() {
        return this.blockingExecutor;
    }

    public void setBlockingExecutor(Executor blockingExecutor) {
        this.blockingExecutor = blockingExecutor;
    }

    public String getClientAuth() {
        return this.clientAuth;
    }

    public void setClientAuth(String clientAuth) {
        this.clientAuth = clientAuth;
    }
}

