/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.interceptor;

import java.util.Collections;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.shrink.ResizeRequest;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportMessage;
import org.elasticsearch.xpack.core.security.authz.AuthorizationEngine;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.core.security.support.Exceptions;
import org.elasticsearch.xpack.security.audit.AuditTrailService;
import org.elasticsearch.xpack.security.audit.AuditUtil;
import org.elasticsearch.xpack.security.authz.interceptor.RequestInterceptor;

public final class ResizeRequestInterceptor
implements RequestInterceptor {
    private final ThreadContext threadContext;
    private final XPackLicenseState licenseState;
    private final AuditTrailService auditTrailService;

    public ResizeRequestInterceptor(ThreadPool threadPool, XPackLicenseState licenseState, AuditTrailService auditTrailService) {
        this.threadContext = threadPool.getThreadContext();
        this.licenseState = licenseState;
        this.auditTrailService = auditTrailService;
    }

    @Override
    public void intercept(AuthorizationEngine.RequestInfo requestInfo, AuthorizationEngine authorizationEngine, AuthorizationEngine.AuthorizationInfo authorizationInfo, ActionListener<Void> listener) {
        if (requestInfo.getRequest() instanceof ResizeRequest) {
            ResizeRequest request = (ResizeRequest)requestInfo.getRequest();
            XPackLicenseState frozenLicenseState = this.licenseState.copyCurrentLicenseState();
            if (frozenLicenseState.isAuthAllowed()) {
                IndicesAccessControl indicesAccessControl;
                IndicesAccessControl.IndexAccessControl indexAccessControl;
                if (frozenLicenseState.isDocumentAndFieldLevelSecurityAllowed() && (indexAccessControl = (indicesAccessControl = (IndicesAccessControl)this.threadContext.getTransient("_indices_permissions")).getIndexPermissions(request.getSourceIndex())) != null) {
                    boolean fls = indexAccessControl.getFieldPermissions().hasFieldLevelSecurity();
                    boolean dls = indexAccessControl.getDocumentPermissions().hasDocumentLevelPermissions();
                    if (fls || dls) {
                        listener.onFailure((Exception)((Object)new ElasticsearchSecurityException("Resize requests are not allowed for users when field or document level security is enabled on the source index", RestStatus.BAD_REQUEST, new Object[0])));
                        return;
                    }
                }
                authorizationEngine.validateIndexPermissionsAreSubset(requestInfo, authorizationInfo, Collections.singletonMap(request.getSourceIndex(), Collections.singletonList(request.getTargetIndexRequest().index())), (ActionListener)ContextPreservingActionListener.wrapPreservingContext((ActionListener)ActionListener.wrap(authzResult -> {
                    if (authzResult.isGranted()) {
                        listener.onResponse(null);
                    } else {
                        if (authzResult.isAuditable()) {
                            this.auditTrailService.accessDenied(AuditUtil.extractRequestId(this.threadContext), requestInfo.getAuthentication(), requestInfo.getAction(), (TransportMessage)request, authorizationInfo);
                        }
                        listener.onFailure((Exception)((Object)Exceptions.authorizationError((String)"Resizing an index is not allowed when the target index has more permissions than the source index", (Object[])new Object[0])));
                    }
                }, arg_0 -> listener.onFailure(arg_0)), (ThreadContext)this.threadContext));
            } else {
                listener.onResponse(null);
            }
        } else {
            listener.onResponse(null);
        }
    }
}

