/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.autodetect.writer;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.xpack.core.ml.calendars.ScheduledEvent;
import org.elasticsearch.xpack.core.ml.job.config.AnalysisConfig;
import org.elasticsearch.xpack.core.ml.job.config.DefaultDetectorDescription;
import org.elasticsearch.xpack.core.ml.job.config.DetectionRule;
import org.elasticsearch.xpack.core.ml.job.config.Detector;
import org.elasticsearch.xpack.core.ml.job.config.MlFilter;
import org.elasticsearch.xpack.core.ml.utils.MlStrings;
import org.elasticsearch.xpack.ml.job.process.autodetect.writer.MlFilterWriter;
import org.elasticsearch.xpack.ml.job.process.autodetect.writer.ScheduledEventsWriter;

public class FieldConfigWriter {
    private static final String DETECTOR_PREFIX = "detector.";
    private static final String DETECTOR_CLAUSE_SUFFIX = ".clause";
    private static final String DETECTOR_RULES_SUFFIX = ".rules";
    private static final String INFLUENCER_PREFIX = "influencer.";
    private static final String CATEGORIZATION_FIELD_OPTION = " categorizationfield=";
    private static final String CATEGORIZATION_FILTER_PREFIX = "categorizationfilter.";
    private static final char NEW_LINE = '\n';
    private final AnalysisConfig config;
    private final Set<MlFilter> filters;
    private final List<ScheduledEvent> scheduledEvents;
    private final OutputStreamWriter writer;
    private final Logger logger;

    public FieldConfigWriter(AnalysisConfig config, Set<MlFilter> filters, List<ScheduledEvent> scheduledEvents, OutputStreamWriter writer, Logger logger) {
        this.config = Objects.requireNonNull(config);
        this.filters = Objects.requireNonNull(filters);
        this.scheduledEvents = Objects.requireNonNull(scheduledEvents);
        this.writer = Objects.requireNonNull(writer);
        this.logger = Objects.requireNonNull(logger);
    }

    public void write() throws IOException {
        StringBuilder contents = new StringBuilder();
        this.writeFilters(contents);
        this.writeDetectors(contents);
        this.writeScheduledEvents(contents);
        FieldConfigWriter.writeAsEnumeratedSettings(INFLUENCER_PREFIX, this.config.getInfluencers(), contents, false);
        this.logger.debug("FieldConfig:\n" + contents.toString());
        this.writer.write(contents.toString());
    }

    private void writeDetectors(StringBuilder contents) throws IOException {
        int counter = 0;
        for (Detector detector : this.config.getDetectors()) {
            int detectorId = counter++;
            this.writeDetectorClause(detectorId, detector, contents);
            this.writeDetectorRules(detectorId, detector, contents);
        }
    }

    private void writeDetectorClause(int detectorId, Detector detector, StringBuilder contents) {
        contents.append(DETECTOR_PREFIX).append(detectorId).append(DETECTOR_CLAUSE_SUFFIX).append(" = ");
        DefaultDetectorDescription.appendOn((Detector)detector, (StringBuilder)contents);
        if (!Strings.isNullOrEmpty((String)this.config.getCategorizationFieldName())) {
            contents.append(CATEGORIZATION_FIELD_OPTION).append(FieldConfigWriter.quoteField(this.config.getCategorizationFieldName()));
        }
        contents.append('\n');
    }

    private void writeDetectorRules(int detectorId, Detector detector, StringBuilder contents) throws IOException {
        ArrayList<DetectionRule> rules = new ArrayList<DetectionRule>();
        if (detector.getRules() != null) {
            rules.addAll(detector.getRules());
        }
        if (rules.isEmpty()) {
            return;
        }
        contents.append(DETECTOR_PREFIX).append(detectorId).append(DETECTOR_RULES_SUFFIX).append(" = ");
        this.writeDetectionRulesJson(rules, contents);
        contents.append('\n');
    }

    private void writeDetectionRulesJson(List<DetectionRule> rules, StringBuilder contents) throws IOException {
        contents.append('[');
        boolean first = true;
        for (DetectionRule rule : rules) {
            if (first) {
                first = false;
            } else {
                contents.append(',');
            }
            XContentBuilder contentBuilder = XContentFactory.jsonBuilder();
            try {
                contents.append(Strings.toString((XContentBuilder)rule.toXContent(contentBuilder, ToXContent.EMPTY_PARAMS)));
            }
            finally {
                if (contentBuilder == null) continue;
                contentBuilder.close();
            }
        }
        contents.append(']');
    }

    private void writeFilters(StringBuilder buffer) throws IOException {
        new MlFilterWriter(this.filters, buffer).write();
    }

    private void writeScheduledEvents(StringBuilder buffer) throws IOException {
        if (!this.scheduledEvents.isEmpty()) {
            new ScheduledEventsWriter(this.scheduledEvents, this.config.getBucketSpan(), buffer).write();
        }
    }

    private static void writeAsEnumeratedSettings(String settingName, List<String> values, StringBuilder buffer, boolean quote) {
        if (values == null) {
            return;
        }
        int counter = 0;
        for (String value : values) {
            buffer.append(settingName).append(counter++).append(" = ").append(quote ? FieldConfigWriter.quoteField(value) : value).append('\n');
        }
    }

    private static String quoteField(String field) {
        return MlStrings.doubleQuoteIfNotAlphaNumeric((String)field);
    }
}

