/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.plain.DocValuesIndexFieldData;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.SimpleMappedFieldType;
import org.elasticsearch.index.query.QueryShardContext;

public class SeqNoFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_seq_no";
    public static final String CONTENT_TYPE = "_seq_no";
    public static final String PRIMARY_TERM_NAME = "_primary_term";
    public static final String TOMBSTONE_NAME = "_tombstone";

    public SeqNoFieldMapper(Settings indexSettings) {
        super("_seq_no", SeqNoDefaults.FIELD_TYPE, SeqNoDefaults.FIELD_TYPE, indexSettings);
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
        super.parse(context);
    }

    @Override
    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        SequenceIDFields seqID = SequenceIDFields.emptySeqID();
        context.seqID(seqID);
        fields.add((IndexableField)seqID.seqNo);
        fields.add((IndexableField)seqID.seqNoDocValue);
        fields.add((IndexableField)seqID.primaryTerm);
    }

    @Override
    public void parse(ParseContext context) throws IOException {
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
        SequenceIDFields seqID = context.seqID();
        assert (seqID != null);
        Version versionCreated = context.mapperService().getIndexSettings().getIndexVersionCreated();
        boolean includePrimaryTerm = versionCreated.before(Version.V_6_1_0);
        for (ParseContext.Document doc : context.nonRootDocuments()) {
            doc.add((IndexableField)seqID.seqNo);
            doc.add((IndexableField)seqID.seqNoDocValue);
            if (!includePrimaryTerm) continue;
            doc.add((IndexableField)seqID.primaryTerm);
        }
    }

    @Override
    protected String contentType() {
        return "_seq_no";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder;
    }

    @Override
    protected void doMerge(Mapper mergeWith, boolean updateAllTypes) {
    }

    static final class SeqNoFieldType
    extends SimpleMappedFieldType {
        SeqNoFieldType() {
        }

        protected SeqNoFieldType(SeqNoFieldType ref) {
            super(ref);
        }

        @Override
        public MappedFieldType clone() {
            return new SeqNoFieldType(this);
        }

        @Override
        public String typeName() {
            return "_seq_no";
        }

        private long parse(Object value) {
            if (value instanceof Number) {
                double doubleValue = ((Number)value).doubleValue();
                if (doubleValue < -9.223372036854776E18 || doubleValue > 9.223372036854776E18) {
                    throw new IllegalArgumentException("Value [" + value + "] is out of range for a long");
                }
                if (doubleValue % 1.0 != 0.0) {
                    throw new IllegalArgumentException("Value [" + value + "] has a decimal part");
                }
                return ((Number)value).longValue();
            }
            if (value instanceof BytesRef) {
                value = ((BytesRef)value).utf8ToString();
            }
            return Long.parseLong(value.toString());
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            return new DocValuesFieldExistsQuery(this.name());
        }

        @Override
        public Query termQuery(Object value, @Nullable QueryShardContext context) {
            long v = this.parse(value);
            return LongPoint.newExactQuery((String)this.name(), (long)v);
        }

        @Override
        public Query termsQuery(List<?> values, @Nullable QueryShardContext context) {
            long[] v = new long[values.size()];
            for (int i = 0; i < values.size(); ++i) {
                v[i] = this.parse(values.get(i));
            }
            return LongPoint.newSetQuery((String)this.name(), (long[])v);
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, QueryShardContext context) {
            long l = Long.MIN_VALUE;
            long u = Long.MAX_VALUE;
            if (lowerTerm != null) {
                l = this.parse(lowerTerm);
                if (!includeLower) {
                    if (l == Long.MAX_VALUE) {
                        return new MatchNoDocsQuery();
                    }
                    ++l;
                }
            }
            if (upperTerm != null) {
                u = this.parse(upperTerm);
                if (!includeUpper) {
                    if (u == Long.MIN_VALUE) {
                        return new MatchNoDocsQuery();
                    }
                    --u;
                }
            }
            return LongPoint.newRangeQuery((String)this.name(), (long)l, (long)u);
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName) {
            this.failIfNoDocValues();
            return new DocValuesIndexFieldData.Builder().numericType(IndexNumericFieldData.NumericType.LONG);
        }
    }

    public static class TypeParser
    implements MetadataFieldMapper.TypeParser {
        @Override
        public MetadataFieldMapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            throw new MapperParsingException("_seq_no is not configurable");
        }

        @Override
        public MetadataFieldMapper getDefault(MappedFieldType fieldType, Mapper.TypeParser.ParserContext context) {
            Settings indexSettings = context.mapperService().getIndexSettings().getSettings();
            return new SeqNoFieldMapper(indexSettings);
        }
    }

    public static class Builder
    extends MetadataFieldMapper.Builder<Builder, SeqNoFieldMapper> {
        public Builder() {
            super("_seq_no", SeqNoDefaults.FIELD_TYPE, SeqNoDefaults.FIELD_TYPE);
        }

        @Override
        public SeqNoFieldMapper build(Mapper.BuilderContext context) {
            return new SeqNoFieldMapper(context.indexSettings());
        }
    }

    public static class SeqNoDefaults {
        public static final String NAME = "_seq_no";
        public static final MappedFieldType FIELD_TYPE = new SeqNoFieldType();

        static {
            FIELD_TYPE.setName("_seq_no");
            FIELD_TYPE.setDocValuesType(DocValuesType.SORTED);
            FIELD_TYPE.setHasDocValues(true);
            FIELD_TYPE.freeze();
        }
    }

    public static class SequenceIDFields {
        public final Field seqNo;
        public final Field seqNoDocValue;
        public final Field primaryTerm;
        public final Field tombstoneField;

        public SequenceIDFields(Field seqNo, Field seqNoDocValue, Field primaryTerm, Field tombstoneField) {
            Objects.requireNonNull(seqNo, "sequence number field cannot be null");
            Objects.requireNonNull(seqNoDocValue, "sequence number dv field cannot be null");
            Objects.requireNonNull(primaryTerm, "primary term field cannot be null");
            this.seqNo = seqNo;
            this.seqNoDocValue = seqNoDocValue;
            this.primaryTerm = primaryTerm;
            this.tombstoneField = tombstoneField;
        }

        public static SequenceIDFields emptySeqID() {
            return new SequenceIDFields((Field)new LongPoint("_seq_no", new long[]{-2L}), (Field)new NumericDocValuesField("_seq_no", -2L), (Field)new NumericDocValuesField(SeqNoFieldMapper.PRIMARY_TERM_NAME, 0L), (Field)new NumericDocValuesField(SeqNoFieldMapper.TOMBSTONE_NAME, 0L));
        }
    }
}

