/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.action.util.PageParams;
import org.elasticsearch.xpack.core.ml.action.util.QueryPage;
import org.elasticsearch.xpack.core.ml.calendars.Calendar;
import org.elasticsearch.xpack.core.ml.calendars.ScheduledEvent;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class GetCalendarEventsAction
extends Action<Request, Response, RequestBuilder> {
    public static final GetCalendarEventsAction INSTANCE = new GetCalendarEventsAction();
    public static final String NAME = "cluster:monitor/xpack/ml/calendars/events/get";

    private GetCalendarEventsAction() {
        super(NAME);
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client);
    }

    public Response newResponse() {
        return new Response();
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private QueryPage<ScheduledEvent> scheduledEvents;

        public Response() {
        }

        public Response(QueryPage<ScheduledEvent> scheduledEvents) {
            this.scheduledEvents = scheduledEvents;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.scheduledEvents = new QueryPage(in, ScheduledEvent::new);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.scheduledEvents.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return this.scheduledEvents.toXContent(builder, params);
        }

        public int hashCode() {
            return Objects.hash(this.scheduledEvents);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Response other = (Response)((Object)obj);
            return Objects.equals(this.scheduledEvents, other.scheduledEvents);
        }
    }

    public static class RequestBuilder
    extends ActionRequestBuilder<Request, Response, RequestBuilder> {
        public RequestBuilder(ElasticsearchClient client) {
            super(client, (Action)INSTANCE, (ActionRequest)new Request());
        }
    }

    public static class Request
    extends ActionRequest
    implements ToXContentObject {
        public static final ParseField START = new ParseField("start", new String[0]);
        public static final ParseField END = new ParseField("end", new String[0]);
        private static final ObjectParser<Request, Void> PARSER = new ObjectParser("cluster:monitor/xpack/ml/calendars/events/get", Request::new);
        private String calendarId;
        private String start;
        private String end;
        private String jobId;
        private PageParams pageParams = PageParams.defaultParams();

        public static Request parseRequest(String calendarId, XContentParser parser) {
            Request request = (Request)((Object)PARSER.apply(parser, null));
            if (calendarId != null) {
                request.setCalendarId(calendarId);
            }
            return request;
        }

        public Request() {
        }

        public Request(String calendarId) {
            this.setCalendarId(calendarId);
        }

        public String getCalendarId() {
            return this.calendarId;
        }

        private void setCalendarId(String calendarId) {
            this.calendarId = ExceptionsHelper.requireNonNull(calendarId, Calendar.ID.getPreferredName());
        }

        public String getStart() {
            return this.start;
        }

        public void setStart(String start) {
            this.start = start;
        }

        public String getEnd() {
            return this.end;
        }

        public void setEnd(String end) {
            this.end = end;
        }

        public String getJobId() {
            return this.jobId;
        }

        public void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public PageParams getPageParams() {
            return this.pageParams;
        }

        public void setPageParams(PageParams pageParams) {
            this.pageParams = Objects.requireNonNull(pageParams);
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException e = null;
            boolean calendarIdIsAll = "_all".equals(this.calendarId);
            if (this.jobId != null && !calendarIdIsAll) {
                e = ValidateActions.addValidationError((String)("If " + Job.ID.getPreferredName() + " is used " + Calendar.ID.getPreferredName() + " must be '" + "_all" + "'"), e);
            }
            return e;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.calendarId = in.readString();
            this.start = in.readOptionalString();
            this.end = in.readOptionalString();
            this.jobId = in.readOptionalString();
            this.pageParams = new PageParams(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.calendarId);
            out.writeOptionalString(this.start);
            out.writeOptionalString(this.end);
            out.writeOptionalString(this.jobId);
            this.pageParams.writeTo(out);
        }

        public int hashCode() {
            return Objects.hash(this.calendarId, this.start, this.end, this.pageParams, this.jobId);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.calendarId, other.calendarId) && Objects.equals(this.start, other.start) && Objects.equals(this.end, other.end) && Objects.equals(this.pageParams, other.pageParams) && Objects.equals(this.jobId, other.jobId);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Calendar.ID.getPreferredName(), this.calendarId);
            if (this.start != null) {
                builder.field(START.getPreferredName(), this.start);
            }
            if (this.end != null) {
                builder.field(END.getPreferredName(), this.end);
            }
            if (this.jobId != null) {
                builder.field(Job.ID.getPreferredName(), this.jobId);
            }
            builder.field(PageParams.PAGE.getPreferredName(), (ToXContent)this.pageParams);
            builder.endObject();
            return builder;
        }

        static {
            PARSER.declareString(Request::setCalendarId, Calendar.ID);
            PARSER.declareString(Request::setStart, START);
            PARSER.declareString(Request::setEnd, END);
            PARSER.declareString(Request::setJobId, Job.ID);
            PARSER.declareObject(Request::setPageParams, PageParams.PARSER, PageParams.PAGE);
        }
    }
}

