/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.watcher.condition;

import java.io.IOException;
import java.time.Clock;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.watcher.condition.ConditionFactory;
import org.elasticsearch.xpack.core.watcher.condition.ExecutableCondition;

public class ConditionRegistry {
    private final Map<String, ConditionFactory> factories;
    private final Clock clock;

    public ConditionRegistry(Map<String, ConditionFactory> factories, Clock clock) {
        this.clock = clock;
        this.factories = factories;
    }

    public ExecutableCondition parseExecutable(String watchId, XContentParser parser) throws IOException {
        XContentParser.Token token;
        ExecutableCondition condition = null;
        String type = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                type = parser.currentName();
                continue;
            }
            if (type == null) {
                throw new ElasticsearchParseException("could not parse condition for watch [{}]. invalid definition. expected a field indicating the condition type, but found", new Object[]{watchId, token});
            }
            ConditionFactory factory = this.factories.get(type);
            if (factory == null) {
                throw new ElasticsearchParseException("could not parse condition for watch [{}]. unknown condition type [{}]", new Object[]{watchId, type});
            }
            condition = factory.parse(this.clock, watchId, parser);
        }
        if (condition == null) {
            throw new ElasticsearchParseException("could not parse condition for watch [{}]. missing required condition type field", new Object[]{watchId});
        }
        return condition;
    }
}

