#ifndef SCAN_H
#define SCAN_H

/* Revision 2024-09-10
 * Authors feh, jmh
 */

#define scan_dnum(s,X) _Generic((X),\
  unsigned char*:  scan_uint,     \
  unsigned int *:  scan_uint,     \
  unsigned long *: scan_ulong,    \
  long *:          scan_long      \
  ) (s,X)
 
#define scan_xnum(s,X) _Generic((X),\
  unsigned int *:  scan_xint,     \
  unsigned long *: scan_xlong     \
  ) (s,X)

extern unsigned int scan_8long(const char *,unsigned long *);

extern unsigned int scan_uint(const char *,unsigned int *);
extern unsigned int scan_ulong(const char *,unsigned long *);
extern unsigned int scan_long(const char *,long *);

extern unsigned int scan_0x(const char *,unsigned int *);
extern unsigned int scan_xint(const char *,unsigned int *);
extern unsigned int scan_xlong(const char *,unsigned long *);

#endif
