/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JTextArea;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ChoiceItem;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.FreeColChoiceDialog;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.LostCityRumour;
import net.sf.freecol.common.model.UnitType;

public final class EmigrationDialog
extends FreeColChoiceDialog<Integer> {
    public EmigrationDialog(FreeColClient freeColClient, JFrame frame, Europe europe, boolean foy) {
        super(freeColClient, frame);
        ImageLibrary lib = freeColClient.getGUI().getImageLibrary();
        ArrayList<UnitType> recruitables = new ArrayList<UnitType>(europe.getRecruitables());
        JTextArea header = Utility.localizedTextArea("emigrationDialog.chooseImmigrant");
        if (foy) {
            header.insert(Messages.message(LostCityRumour.RumourType.FOUNTAIN_OF_YOUTH.getDescriptionKey()) + "\n\n", 0);
        }
        MigPanel panel = new MigPanel(new MigLayout("wrap 1", "[fill]", ""));
        panel.add((Component)header, "wrap 20");
        panel.setSize(panel.getPreferredSize());
        List c = EmigrationDialog.choices();
        int i = Europe.MigrationType.getDefaultSlot();
        UnitType u0 = (UnitType)recruitables.remove(0);
        c.add(new ChoiceItem<Integer>(Messages.getName(u0), i++).defaultOption().setIcon(new ImageIcon(lib.getSmallUnitImage(u0))));
        for (UnitType ut : recruitables) {
            c.add(new ChoiceItem<Integer>(Messages.getName(ut), i++).setIcon(new ImageIcon(lib.getSmallUnitImage(ut))));
        }
        this.initializeChoiceDialog(frame, false, panel, null, null, c);
    }
}

