/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;
import net.sf.gogui.game.Node;
import net.sf.gogui.game.NodeUtils;
import net.sf.gogui.go.Board;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.go.Move;
import net.sf.gogui.gui.Clock;

public class GameInfo
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 0L;
    private final JTextField m_move;
    private final JTextField m_number;
    private final JTextField m_last;
    private final JTextField m_captB;
    private final JTextField m_captW;
    private final JTextField m_timeB;
    private final JTextField m_timeW;
    private final JTextField m_variation;
    private final Clock m_clock;

    public GameInfo(Clock clock) {
        super(new GridLayout(0, 2, 2, 2));
        this.m_clock = clock;
        this.m_move = this.addEntry("To play:");
        this.m_number = this.addEntry("Moves:");
        this.m_last = this.addEntry("Last move:");
        this.m_variation = this.addEntry("Variation:");
        this.m_captB = this.addEntry("Captured Black:");
        this.m_captW = this.addEntry("Captured White:");
        this.m_timeB = this.addEntry("Time Black:");
        this.m_timeW = this.addEntry("Time White:");
        this.m_timeB.setText("00:00");
        this.m_timeW.setText("00:00");
        new Timer(1000, this).start();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.m_clock.isRunning()) {
            this.updateTime();
        }
    }

    public void fastUpdateMoveNumber(Node node) {
        this.updateMoveNumber(node);
        this.m_number.paintImmediately(this.m_number.getVisibleRect());
    }

    public void update(Node node, Board board) {
        if (board.getToMove() == GoColor.BLACK) {
            this.m_move.setText("Black");
        } else {
            this.m_move.setText("White");
        }
        int n = board.getCapturedB();
        if (n == 0) {
            this.m_captB.setText("");
        } else {
            this.m_captB.setText(Integer.toString(n));
        }
        int n2 = board.getCapturedW();
        if (n2 == 0) {
            this.m_captW.setText("");
        } else {
            this.m_captW.setText(Integer.toString(n2));
        }
        this.updateMoveNumber(node);
        String string = "";
        Move move = node.getMove();
        if (move != null) {
            GoColor goColor = move.getColor();
            GoPoint goPoint = move.getPoint();
            string = goColor == GoColor.BLACK ? "B " : "W ";
            string = goPoint == null ? string + "PASS" : string + goPoint.toString();
        }
        this.m_last.setText(string);
        this.m_variation.setText(NodeUtils.getVariationString(node));
        double d = node.getTimeLeft(GoColor.BLACK);
        int n3 = node.getMovesLeft(GoColor.BLACK);
        if (!Double.isNaN(d)) {
            this.m_timeB.setText(Clock.getTimeString(d, n3));
        }
        double d2 = node.getTimeLeft(GoColor.WHITE);
        int n4 = node.getMovesLeft(GoColor.WHITE);
        if (!Double.isNaN(d2)) {
            this.m_timeW.setText(Clock.getTimeString(d2, n4));
        }
    }

    public void updateTime() {
        this.updateTime(GoColor.BLACK);
        this.updateTime(GoColor.WHITE);
    }

    private JTextField addEntry(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setHorizontalAlignment(2);
        this.add(jLabel);
        JTextField jTextField = new JTextField(" ");
        jTextField.setHorizontalAlignment(2);
        jTextField.setEditable(false);
        jTextField.setFocusable(false);
        this.add(jTextField);
        return jTextField;
    }

    private void updateMoveNumber(Node node) {
        int n = NodeUtils.getMoveNumber(node);
        int n2 = NodeUtils.getMovesLeft(node);
        if (n == 0 && n2 == 0) {
            this.m_number.setText("");
        } else {
            String string = Integer.toString(n);
            if (n2 > 0) {
                string = string + "/" + (n + n2);
            }
            this.m_number.setText(string);
        }
    }

    private void updateTime(GoColor goColor) {
        String string = this.m_clock.getTimeString(goColor);
        if (string == null) {
            string = " ";
        }
        if (goColor == GoColor.BLACK) {
            this.m_timeB.setText(string);
        } else {
            this.m_timeW.setText(string);
        }
    }
}

