/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.view.client;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.view.client.AbstractDataProvider;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ProvidesKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class ListDataProvider<T>
extends AbstractDataProvider<T> {
    private ListWrapper listWrapper;

    public ListDataProvider() {
        this(new ArrayList(), null);
    }

    public ListDataProvider(List<T> listToWrap) {
        this(listToWrap, null);
    }

    public ListDataProvider(ProvidesKey<T> keyProvider) {
        this(new ArrayList(), keyProvider);
    }

    public ListDataProvider(List<T> listToWrap, ProvidesKey<T> keyProvider) {
        super(keyProvider);
        this.listWrapper = new ListWrapper(listToWrap);
    }

    public void flush() {
        this.listWrapper.flushNow();
    }

    public List<T> getList() {
        return this.listWrapper;
    }

    public void refresh() {
        this.updateRowData(0, this.listWrapper);
    }

    public void setList(List<T> listToWrap) {
        this.listWrapper = new ListWrapper(listToWrap);
        this.listWrapper.minModified = 0;
        this.listWrapper.maxModified = this.listWrapper.size();
        this.listWrapper.modified = true;
        this.flush();
    }

    @Override
    protected void onRangeChanged(HasData<T> display) {
        int size = this.listWrapper.size();
        if (size > 0) {
            this.updateRowData(display, 0, this.listWrapper);
        }
    }

    private class ListWrapper
    implements List<T> {
        private int curSize = 0;
        private final ListWrapper delegate;
        private boolean flushCancelled;
        private Scheduler.ScheduledCommand flushCommand = new Scheduler.ScheduledCommand(){

            @Override
            public void execute() {
                ListWrapper.this.flushPending = false;
                if (ListWrapper.this.flushCancelled) {
                    ListWrapper.this.flushCancelled = false;
                    return;
                }
                ListWrapper.this.flushNow();
            }
        };
        private boolean flushPending;
        private List<T> list;
        private final int offset;
        private int maxModified = Integer.MIN_VALUE;
        private int minModified = Integer.MAX_VALUE;
        private boolean modified;

        public ListWrapper(List<T> list) {
            this(list, null, 0);
            listDataProvider.updateRowCount(list.size(), true);
        }

        private ListWrapper(List<T> list, ListWrapper delegate, int offset) {
            this.list = list;
            this.delegate = delegate;
            this.offset = offset;
        }

        @Override
        public void add(int index, T element) {
            try {
                this.list.add(index, element);
                this.minModified = Math.min(this.minModified, index);
                this.maxModified = this.size();
                this.modified = true;
                this.flush();
            }
            catch (IndexOutOfBoundsException e) {
                throw new IndexOutOfBoundsException(e.getMessage());
            }
        }

        @Override
        public boolean add(T e) {
            boolean toRet = this.list.add(e);
            this.minModified = Math.min(this.minModified, this.size() - 1);
            this.maxModified = this.size();
            this.modified = true;
            this.flush();
            return toRet;
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            this.minModified = Math.min(this.minModified, this.size());
            boolean toRet = this.list.addAll(c);
            this.maxModified = this.size();
            this.modified = true;
            this.flush();
            return toRet;
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> c) {
            try {
                boolean toRet = this.list.addAll(index, c);
                this.minModified = Math.min(this.minModified, index);
                this.maxModified = this.size();
                this.modified = true;
                this.flush();
                return toRet;
            }
            catch (IndexOutOfBoundsException e) {
                throw new IndexOutOfBoundsException(e.getMessage());
            }
        }

        @Override
        public void clear() {
            this.list.clear();
            this.maxModified = 0;
            this.minModified = 0;
            this.modified = true;
            this.flush();
        }

        @Override
        public boolean contains(Object o) {
            return this.list.contains(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.list.containsAll(c);
        }

        @Override
        public boolean equals(Object o) {
            return ((Object)this.list).equals(o);
        }

        @Override
        public T get(int index) {
            return this.list.get(index);
        }

        @Override
        public int hashCode() {
            return ((Object)this.list).hashCode();
        }

        @Override
        public int indexOf(Object o) {
            return this.list.indexOf(o);
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        @Override
        public Iterator<T> iterator() {
            return this.listIterator();
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.list.lastIndexOf(o);
        }

        @Override
        public ListIterator<T> listIterator() {
            return new WrappedListIterator();
        }

        @Override
        public ListIterator<T> listIterator(int index) {
            return new WrappedListIterator(index);
        }

        @Override
        public T remove(int index) {
            try {
                Object toRet = this.list.remove(index);
                this.minModified = Math.min(this.minModified, index);
                this.maxModified = this.size();
                this.modified = true;
                this.flush();
                return toRet;
            }
            catch (IndexOutOfBoundsException e) {
                throw new IndexOutOfBoundsException(e.getMessage());
            }
        }

        @Override
        public boolean remove(Object o) {
            int index = this.indexOf(o);
            if (index == -1) {
                return false;
            }
            this.remove(index);
            return true;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean toRet = this.list.removeAll(c);
            this.minModified = 0;
            this.maxModified = this.size();
            this.modified = true;
            this.flush();
            return toRet;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            boolean toRet = this.list.retainAll(c);
            this.minModified = 0;
            this.maxModified = this.size();
            this.modified = true;
            this.flush();
            return toRet;
        }

        @Override
        public T set(int index, T element) {
            Object toRet = this.list.set(index, element);
            this.minModified = Math.min(this.minModified, index);
            this.maxModified = Math.max(this.maxModified, index + 1);
            this.modified = true;
            this.flush();
            return toRet;
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public List<T> subList(int fromIndex, int toIndex) {
            return new ListWrapper(this.list.subList(fromIndex, toIndex), this, fromIndex);
        }

        @Override
        public Object[] toArray() {
            return this.list.toArray();
        }

        @Override
        public <C> C[] toArray(C[] a) {
            return this.list.toArray(a);
        }

        private void flush() {
            if (this.delegate != null) {
                this.delegate.minModified = Math.min(this.minModified + this.offset, this.delegate.minModified);
                this.delegate.maxModified = Math.max(this.maxModified + this.offset, this.delegate.maxModified);
                this.delegate.modified = this.modified || this.delegate.modified;
                this.delegate.flush();
                return;
            }
            this.flushCancelled = false;
            if (!this.flushPending) {
                this.flushPending = true;
                Scheduler.get().scheduleFinally(this.flushCommand);
            }
        }

        private void flushNow() {
            if (this.flushPending) {
                this.flushCancelled = true;
            }
            if (ListDataProvider.this.listWrapper != this) {
                return;
            }
            int newSize = this.list.size();
            if (this.curSize != newSize) {
                this.curSize = newSize;
                ListDataProvider.this.updateRowCount(this.curSize, true);
            }
            if (this.modified) {
                ListDataProvider.this.updateRowData(this.minModified, this.list.subList(this.minModified, this.maxModified));
                this.modified = false;
            }
            this.minModified = Integer.MAX_VALUE;
            this.maxModified = Integer.MIN_VALUE;
        }

        private final class WrappedListIterator
        implements ListIterator<T> {
            private static final String IMPERMEABLE_EXCEPTION = "Cannot call add/remove more than once per call to next/previous.";
            private int i = 0;
            private int last = -1;

            private WrappedListIterator() {
            }

            private WrappedListIterator(int start) {
                int size = ListWrapper.this.size();
                if (start < 0 || start > size) {
                    throw new IndexOutOfBoundsException("Index: " + start + ", Size: " + size);
                }
                this.i = start;
            }

            @Override
            public void add(T o) {
                if (this.last < 0) {
                    throw new IllegalStateException(IMPERMEABLE_EXCEPTION);
                }
                ListWrapper.this.add(this.i++, o);
                this.last = -1;
            }

            @Override
            public boolean hasNext() {
                return this.i < ListWrapper.this.size();
            }

            @Override
            public boolean hasPrevious() {
                return this.i > 0;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.i++;
                return ListWrapper.this.get(this.last);
            }

            @Override
            public int nextIndex() {
                return this.i;
            }

            @Override
            public T previous() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.last = --this.i;
                return ListWrapper.this.get(this.i);
            }

            @Override
            public int previousIndex() {
                return this.i - 1;
            }

            @Override
            public void remove() {
                if (this.last < 0) {
                    throw new IllegalStateException(IMPERMEABLE_EXCEPTION);
                }
                ListWrapper.this.remove(this.last);
                this.i = this.last;
                this.last = -1;
            }

            @Override
            public void set(T o) {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                ListWrapper.this.set(this.last, o);
            }
        }
    }
}

