/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.Chunk;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.sra.ReferenceCache;
import htsjdk.samtools.sra.SRAAccession;
import htsjdk.samtools.sra.SRAAlignmentIterator;
import htsjdk.samtools.sra.SRAUnalignmentIterator;
import htsjdk.samtools.sra.SRAUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import ngs.ErrorMsg;
import ngs.ReadCollection;

public class SRAIterator
implements SAMRecordIterator {
    private ValidationStringency validationStringency;
    private SRAAccession accession;
    private ReadCollection run;
    private SAMFileHeader header;
    private ReferenceCache cachedReferences;
    private RecordRangeInfo recordRangeInfo;
    private Iterator<Chunk> chunksIterator;
    private Chunk currentChunk;
    private SRAAlignmentIterator alignmentIterator;
    private SRAUnalignmentIterator unalignmentIterator;

    public static RecordRangeInfo getRecordsRangeInfo(ReadCollection run) {
        try {
            return new RecordRangeInfo(SRAUtils.getReferencesLengthsAligned(run), SRAUtils.getNumberOfReads(run));
        }
        catch (ErrorMsg e) {
            throw new RuntimeException(e);
        }
    }

    public SRAIterator(SRAAccession accession, ReadCollection run, SAMFileHeader header, ReferenceCache cachedReferences, RecordRangeInfo recordRangeInfo, List<Chunk> chunks) {
        this.accession = accession;
        this.run = run;
        this.header = header;
        this.cachedReferences = cachedReferences;
        this.recordRangeInfo = recordRangeInfo;
        this.chunksIterator = chunks.iterator();
        if (this.chunksIterator.hasNext()) {
            this.currentChunk = this.chunksIterator.next();
        }
        this.hasNext();
    }

    @Override
    public boolean hasNext() {
        while (this.currentChunk != null) {
            if (this.alignmentIterator == null && this.currentChunk.getChunkStart() < this.recordRangeInfo.getTotalReferencesLength()) {
                this.alignmentIterator = new SRAAlignmentIterator(this.accession, this.run, this.header, this.cachedReferences, this.recordRangeInfo, this.currentChunk);
                if (this.validationStringency != null) {
                    this.alignmentIterator.setValidationStringency(this.validationStringency);
                }
            }
            if (this.alignmentIterator != null && this.alignmentIterator.hasNext()) {
                return true;
            }
            if (this.unalignmentIterator == null && this.currentChunk.getChunkEnd() > this.recordRangeInfo.getTotalReferencesLength()) {
                this.unalignmentIterator = new SRAUnalignmentIterator(this.accession, this.run, this.header, this.recordRangeInfo, this.currentChunk);
                if (this.validationStringency != null) {
                    this.unalignmentIterator.setValidationStringency(this.validationStringency);
                }
            }
            if (this.unalignmentIterator != null && this.unalignmentIterator.hasNext()) {
                return true;
            }
            if (this.alignmentIterator != null) {
                this.alignmentIterator.close();
            }
            this.alignmentIterator = null;
            this.unalignmentIterator = null;
            if (this.chunksIterator.hasNext()) {
                this.currentChunk = this.chunksIterator.next();
                continue;
            }
            this.currentChunk = null;
        }
        return false;
    }

    @Override
    public SAMRecord next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more records are available in SRAIterator");
        }
        if (this.alignmentIterator != null && this.alignmentIterator.hasNext()) {
            return this.alignmentIterator.next();
        }
        return this.unalignmentIterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Removal of records not implemented.");
    }

    @Override
    public void close() {
        if (this.alignmentIterator != null) {
            this.alignmentIterator.close();
            this.alignmentIterator = null;
        }
    }

    @Override
    public SAMRecordIterator assertSorted(SAMFileHeader.SortOrder sortOrder) {
        throw new UnsupportedOperationException("assertSorted is not implemented.");
    }

    public void setValidationStringency(ValidationStringency validationStringency) {
        this.validationStringency = validationStringency;
        if (this.alignmentIterator != null) {
            this.alignmentIterator.setValidationStringency(validationStringency);
        }
        if (this.unalignmentIterator != null) {
            this.unalignmentIterator.setValidationStringency(validationStringency);
        }
    }

    public static class RecordRangeInfo {
        private List<Long> referenceOffsets;
        private List<Long> referenceLengthsAligned;
        private long totalReferencesLength;
        private long numberOfReads;
        private long totalRecordRangeLength;

        public RecordRangeInfo(List<Long> referenceLengthsAligned, long numberOfReads) {
            this.numberOfReads = numberOfReads;
            this.referenceLengthsAligned = referenceLengthsAligned;
            this.referenceOffsets = new ArrayList<Long>();
            this.totalReferencesLength = 0L;
            for (Long refLen : referenceLengthsAligned) {
                this.referenceOffsets.add(this.totalReferencesLength);
                this.totalReferencesLength += refLen.longValue();
            }
            this.totalRecordRangeLength = this.totalReferencesLength + this.numberOfReads;
        }

        public long getNumberOfReads() {
            return this.numberOfReads;
        }

        public long getTotalReferencesLength() {
            return this.totalReferencesLength;
        }

        public long getTotalRecordRangeLength() {
            return this.totalRecordRangeLength;
        }

        public final List<Long> getReferenceOffsets() {
            return Collections.unmodifiableList(this.referenceOffsets);
        }

        public final List<Long> getReferenceLengthsAligned() {
            return Collections.unmodifiableList(this.referenceLengthsAligned);
        }
    }
}

