/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.classfile.visitor;

import java.util.List;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.constant.Constant;
import jd.core.model.classfile.constant.ConstantClass;
import jd.core.model.classfile.constant.ConstantFieldref;
import jd.core.model.classfile.constant.ConstantMethodref;
import jd.core.model.instruction.bytecode.instruction.ANewArray;
import jd.core.model.instruction.bytecode.instruction.AThrow;
import jd.core.model.instruction.bytecode.instruction.ArrayLength;
import jd.core.model.instruction.bytecode.instruction.ArrayStoreInstruction;
import jd.core.model.instruction.bytecode.instruction.AssertInstruction;
import jd.core.model.instruction.bytecode.instruction.BinaryOperatorInstruction;
import jd.core.model.instruction.bytecode.instruction.CheckCast;
import jd.core.model.instruction.bytecode.instruction.ComplexConditionalBranchInstruction;
import jd.core.model.instruction.bytecode.instruction.ConvertInstruction;
import jd.core.model.instruction.bytecode.instruction.DupStore;
import jd.core.model.instruction.bytecode.instruction.GetField;
import jd.core.model.instruction.bytecode.instruction.IfCmp;
import jd.core.model.instruction.bytecode.instruction.IfInstruction;
import jd.core.model.instruction.bytecode.instruction.IndexInstruction;
import jd.core.model.instruction.bytecode.instruction.InitArrayInstruction;
import jd.core.model.instruction.bytecode.instruction.InstanceOf;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.InvokeInstruction;
import jd.core.model.instruction.bytecode.instruction.InvokeNoStaticInstruction;
import jd.core.model.instruction.bytecode.instruction.LookupSwitch;
import jd.core.model.instruction.bytecode.instruction.MonitorEnter;
import jd.core.model.instruction.bytecode.instruction.MonitorExit;
import jd.core.model.instruction.bytecode.instruction.MultiANewArray;
import jd.core.model.instruction.bytecode.instruction.New;
import jd.core.model.instruction.bytecode.instruction.NewArray;
import jd.core.model.instruction.bytecode.instruction.Pop;
import jd.core.model.instruction.bytecode.instruction.PutField;
import jd.core.model.instruction.bytecode.instruction.PutStatic;
import jd.core.model.instruction.bytecode.instruction.ReturnInstruction;
import jd.core.model.instruction.bytecode.instruction.StoreInstruction;
import jd.core.model.instruction.bytecode.instruction.TableSwitch;
import jd.core.model.instruction.bytecode.instruction.TernaryOpStore;
import jd.core.model.instruction.bytecode.instruction.TernaryOperator;
import jd.core.model.instruction.bytecode.instruction.UnaryOperatorInstruction;
import jd.core.model.instruction.fast.instruction.FastDeclaration;
import jd.core.model.instruction.fast.instruction.FastFor;
import jd.core.model.instruction.fast.instruction.FastForEach;
import jd.core.model.instruction.fast.instruction.FastInstruction;
import jd.core.model.instruction.fast.instruction.FastLabel;
import jd.core.model.instruction.fast.instruction.FastList;
import jd.core.model.instruction.fast.instruction.FastSwitch;
import jd.core.model.instruction.fast.instruction.FastSynchronized;
import jd.core.model.instruction.fast.instruction.FastTest2Lists;
import jd.core.model.instruction.fast.instruction.FastTestList;
import jd.core.model.instruction.fast.instruction.FastTry;
import jd.core.model.reference.ReferenceMap;
import jd.core.util.SignatureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceVisitor {
    private ConstantPool constants;
    private ReferenceMap referenceMap;

    public ReferenceVisitor(ConstantPool constants, ReferenceMap referenceMap) {
        this.constants = constants;
        this.referenceMap = referenceMap;
    }

    public void visit(Instruction instruction) {
        if (instruction == null) {
            return;
        }
        switch (instruction.opcode) {
            case 190: {
                ArrayLength al = (ArrayLength)instruction;
                this.visit(al.arrayref);
                break;
            }
            case 83: 
            case 272: {
                ArrayStoreInstruction asi = (ArrayStoreInstruction)instruction;
                this.visit(asi.valueref);
                break;
            }
            case 286: {
                AssertInstruction ai = (AssertInstruction)instruction;
                this.visit(ai.test);
                this.visit(ai.msg);
                break;
            }
            case 191: {
                AThrow aThrow = (AThrow)instruction;
                this.visit(aThrow.value);
                break;
            }
            case 266: {
                UnaryOperatorInstruction uoi = (UnaryOperatorInstruction)instruction;
                this.visit(uoi.value);
                break;
            }
            case 265: 
            case 267: {
                BinaryOperatorInstruction boi = (BinaryOperatorInstruction)instruction;
                this.visit(boi.value1);
                this.visit(boi.value2);
                break;
            }
            case 192: {
                CheckCast checkCast = (CheckCast)instruction;
                this.visitCheckCastAndMultiANewArray(checkCast.index);
                this.visit(checkCast.objectref);
                break;
            }
            case 54: 
            case 269: {
                StoreInstruction storeInstruction = (StoreInstruction)instruction;
                this.visit(storeInstruction.valueref);
                break;
            }
            case 58: {
                StoreInstruction storeInstruction = (StoreInstruction)instruction;
                this.visit(storeInstruction.valueref);
                break;
            }
            case 264: {
                DupStore dupStore = (DupStore)instruction;
                this.visit(dupStore.objectref);
                break;
            }
            case 275: 
            case 276: {
                ConvertInstruction ci = (ConvertInstruction)instruction;
                this.visit(ci.value);
                break;
            }
            case 261: {
                IfCmp ifCmp = (IfCmp)instruction;
                this.visit(ifCmp.value1);
                this.visit(ifCmp.value2);
                break;
            }
            case 260: 
            case 262: {
                IfInstruction iff = (IfInstruction)instruction;
                this.visit(iff.value);
                break;
            }
            case 284: {
                List<Instruction> branchList = ((ComplexConditionalBranchInstruction)instruction).instructions;
                int i = branchList.size() - 1;
                while (i >= 0) {
                    this.visit(branchList.get(i));
                    --i;
                }
                break;
            }
            case 193: {
                InstanceOf instanceOf = (InstanceOf)instruction;
                this.visitCheckCastAndMultiANewArray(instanceOf.index);
                this.visit(instanceOf.objectref);
                break;
            }
            case 182: 
            case 183: 
            case 185: {
                InvokeNoStaticInstruction insi = (InvokeNoStaticInstruction)instruction;
                this.visit(insi.objectref);
            }
            case 184: 
            case 274: {
                InvokeInstruction ii = (InvokeInstruction)instruction;
                ConstantMethodref cmr = this.constants.getConstantMethodref(ii.index);
                String internalName = this.constants.getConstantClassName(cmr.class_index);
                this.addReference(internalName);
                this.visit(ii.args);
                break;
            }
            case 171: {
                LookupSwitch ls = (LookupSwitch)instruction;
                this.visit(ls.key);
                break;
            }
            case 194: {
                MonitorEnter monitorEnter = (MonitorEnter)instruction;
                this.visit(monitorEnter.objectref);
                break;
            }
            case 195: {
                MonitorExit monitorExit = (MonitorExit)instruction;
                this.visit(monitorExit.objectref);
                break;
            }
            case 197: {
                MultiANewArray multiANewArray = (MultiANewArray)instruction;
                this.visitCheckCastAndMultiANewArray(multiANewArray.index);
                Instruction[] dimensions = multiANewArray.dimensions;
                int i = dimensions.length - 1;
                while (i >= 0) {
                    this.visit(dimensions[i]);
                    --i;
                }
                break;
            }
            case 188: {
                NewArray newArray = (NewArray)instruction;
                this.visit(newArray.dimension);
                break;
            }
            case 187: {
                New aNew = (New)instruction;
                this.addReference(this.constants.getConstantClassName(aNew.index));
                break;
            }
            case 189: {
                ANewArray aNewArray = (ANewArray)instruction;
                this.addReference(this.constants.getConstantClassName(aNewArray.index));
                this.visit(aNewArray.dimension);
                break;
            }
            case 87: {
                Pop pop = (Pop)instruction;
                this.visit(pop.objectref);
                break;
            }
            case 181: {
                PutField putField = (PutField)instruction;
                this.visit(putField.objectref);
                this.visit(putField.valueref);
                break;
            }
            case 179: {
                PutStatic putStatic = (PutStatic)instruction;
                this.visit(putStatic.valueref);
                break;
            }
            case 273: {
                ReturnInstruction ri = (ReturnInstruction)instruction;
                this.visit(ri.valueref);
                break;
            }
            case 170: {
                TableSwitch ts = (TableSwitch)instruction;
                this.visit(ts.key);
                break;
            }
            case 280: {
                TernaryOpStore tos = (TernaryOpStore)instruction;
                this.visit(tos.objectref);
                break;
            }
            case 281: {
                TernaryOperator to = (TernaryOperator)instruction;
                this.visit(to.test);
                this.visit(to.value1);
                this.visit(to.value2);
                break;
            }
            case 180: {
                GetField getField = (GetField)instruction;
                this.visit(getField.objectref);
            }
            case 178: 
            case 285: {
                IndexInstruction indexInstruction = (IndexInstruction)instruction;
                ConstantFieldref cfr = this.constants.getConstantFieldref(indexInstruction.index);
                String internalName = this.constants.getConstantClassName(cfr.class_index);
                this.addReference(internalName);
                break;
            }
            case 282: 
            case 283: {
                InitArrayInstruction iai = (InitArrayInstruction)instruction;
                this.visit(iai.newArray);
                int index = iai.values.size() - 1;
                while (index >= 0) {
                    this.visit(iai.values.get(index));
                    --index;
                }
                break;
            }
            case 304: {
                FastFor ff = (FastFor)instruction;
                this.visit(ff.init);
                this.visit(ff.inc);
            }
            case 301: 
            case 302: 
            case 306: {
                FastTestList ftl = (FastTestList)instruction;
                this.visit(ftl.test);
            }
            case 303: {
                List<Instruction> instructions = ((FastList)instruction).instructions;
                this.visit(instructions);
                break;
            }
            case 305: {
                FastForEach ffe = (FastForEach)instruction;
                this.visit(ffe.variable);
                this.visit(ffe.values);
                this.visit(ffe.instructions);
                break;
            }
            case 307: {
                FastTest2Lists ft2l = (FastTest2Lists)instruction;
                this.visit(ft2l.test);
                this.visit(ft2l.instructions);
                this.visit(ft2l.instructions2);
                break;
            }
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: {
                FastInstruction fi = (FastInstruction)instruction;
                this.visit(fi.instruction);
                break;
            }
            case 314: 
            case 315: 
            case 316: {
                FastSwitch fs = (FastSwitch)instruction;
                this.visit(fs.test);
                FastSwitch.Pair[] pairs = fs.pairs;
                int i = pairs.length - 1;
                while (i >= 0) {
                    List<Instruction> instructions = pairs[i].getInstructions();
                    this.visit(instructions);
                    --i;
                }
                break;
            }
            case 317: {
                FastDeclaration fd = (FastDeclaration)instruction;
                this.visit(fd.instruction);
                break;
            }
            case 318: {
                FastTry ft = (FastTry)instruction;
                this.visit(ft.instructions);
                List<FastTry.FastCatch> catches = ft.catches;
                int i = catches.size() - 1;
                while (i >= 0) {
                    this.visit(catches.get((int)i).instructions);
                    --i;
                }
                this.visit(ft.finallyInstructions);
                break;
            }
            case 319: {
                FastSynchronized fsy = (FastSynchronized)instruction;
                this.visit(fsy.monitor);
                this.visit(fsy.instructions);
                break;
            }
            case 320: {
                FastLabel fla = (FastLabel)instruction;
                this.visit(fla.instruction);
                break;
            }
            case 18: {
                IndexInstruction indexInstruction = (IndexInstruction)instruction;
                Constant cst = this.constants.get(indexInstruction.index);
                if (cst.tag != 7) break;
                ConstantClass cc = (ConstantClass)cst;
                String internalName = this.constants.getConstantUtf8(cc.name_index);
                this.addReference(internalName);
                break;
            }
            case 0: 
            case 1: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 25: 
            case 132: 
            case 167: 
            case 168: 
            case 169: 
            case 177: 
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 263: 
            case 268: 
            case 270: 
            case 271: 
            case 277: 
            case 278: 
            case 279: {
                break;
            }
            default: {
                System.err.println("Can not count reference in " + instruction.getClass().getName() + ", opcode=" + instruction.opcode);
            }
        }
    }

    private void visit(List<Instruction> instructions) {
        if (instructions != null) {
            int i = instructions.size() - 1;
            while (i >= 0) {
                this.visit(instructions.get(i));
                --i;
            }
        }
    }

    private void visitCheckCastAndMultiANewArray(int index) {
        Constant c = this.constants.get(index);
        if (c.tag == 7) {
            this.addReference(this.constants.getConstantUtf8(((ConstantClass)c).name_index));
        }
    }

    private void addReference(String signature) {
        if (signature.charAt(0) == '[') {
            if ((signature = SignatureUtil.CutArrayDimensionPrefix(signature)).charAt(0) == 'L') {
                this.referenceMap.add(SignatureUtil.GetInnerName(signature));
            }
        } else {
            this.referenceMap.add(signature);
        }
    }
}

