/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.http;

import java.io.IOException;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.spdy.SPDYServerConnector;
import org.eclipse.jetty.spdy.api.server.ServerSessionFrameListener;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class AbstractHTTPSPDYServerConnector
extends SPDYServerConnector {
    public AbstractHTTPSPDYServerConnector(ServerSessionFrameListener listener, SslContextFactory sslContextFactory) {
        super(listener, sslContextFactory);
    }

    public void customize(EndPoint endPoint, Request request) throws IOException {
        super.customize(endPoint, request);
        if (this.getSslContextFactory() != null) {
            request.setScheme("https");
        }
    }

    public boolean isConfidential(Request request) {
        if (this.getSslContextFactory() != null) {
            int confidentialPort = this.getConfidentialPort();
            return confidentialPort == 0 || confidentialPort == request.getServerPort();
        }
        return super.isConfidential(request);
    }

    public boolean isIntegral(Request request) {
        if (this.getSslContextFactory() != null) {
            int integralPort = this.getIntegralPort();
            return integralPort == 0 || integralPort == request.getServerPort();
        }
        return super.isIntegral(request);
    }
}

