/*
 * Decompiled with CFR 0.152.
 */
package free.util;

import free.util.FormatException;
import free.util.RectDouble;
import free.util.TextUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.StringTokenizer;

public class StringParser {
    public static Rectangle parseRectangle(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        if (stringTokenizer.countTokens() != 4) {
            throw new FormatException("Wrong Rectangle format: " + string);
        }
        try {
            int n = Integer.parseInt(stringTokenizer.nextToken());
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            int n3 = Integer.parseInt(stringTokenizer.nextToken());
            int n4 = Integer.parseInt(stringTokenizer.nextToken());
            return new Rectangle(n, n2, n3, n4);
        }
        catch (NumberFormatException numberFormatException) {
            throw new FormatException(numberFormatException, "Wrong Rectangle format: " + string);
        }
    }

    public static RectDouble parseRectDouble(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        if (stringTokenizer.countTokens() != 4) {
            throw new FormatException("Wrong Rectangle format: " + string);
        }
        try {
            double d = Double.valueOf(stringTokenizer.nextToken());
            double d2 = Double.valueOf(stringTokenizer.nextToken());
            double d3 = Double.valueOf(stringTokenizer.nextToken());
            double d4 = Double.valueOf(stringTokenizer.nextToken());
            return new RectDouble(d, d2, d3, d4);
        }
        catch (NumberFormatException numberFormatException) {
            throw new FormatException(numberFormatException, "Wrong Rectangle format: " + string);
        }
    }

    public static Dimension parseDimension(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        if (stringTokenizer.countTokens() != 2) {
            throw new FormatException("Wrong Dimension format: " + string);
        }
        try {
            int n = Integer.parseInt(stringTokenizer.nextToken());
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            return new Dimension(n, n2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new FormatException(numberFormatException, "Wrong Dimension format: " + string);
        }
    }

    public static Color parseColor(String string) {
        try {
            int n = Integer.parseInt(string, 16);
            if (n < 0 || (long)n > 0xFFFFFFL) {
                throw new FormatException("Wrong Color format: " + string);
            }
            return new Color(n);
        }
        catch (NumberFormatException numberFormatException) {
            throw new FormatException(numberFormatException, "Wrong Color format: " + string);
        }
    }

    public static int[] parseIntList(String string) {
        return TextUtilities.parseIntList(string, " ");
    }

    public static String parseString(String string) {
        StringBuffer stringBuffer = null;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(string.substring(0, i));
                }
                c = string.charAt(++i);
                switch (c) {
                    case 'n': {
                        stringBuffer.append('\n');
                        break;
                    }
                    case 'r': {
                        stringBuffer.append('\r');
                        break;
                    }
                    case 't': {
                        stringBuffer.append('\t');
                        break;
                    }
                    case '\\': {
                        stringBuffer.append('\\');
                        break;
                    }
                    default: {
                        stringBuffer.append('\'');
                        stringBuffer.append(c);
                        break;
                    }
                }
                continue;
            }
            if (stringBuffer == null) continue;
            stringBuffer.append(c);
        }
        return stringBuffer == null ? string : stringBuffer.toString();
    }
}

