/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.mlf.metouia;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalToolBarUI;
import net.sourceforge.mlf.metouia.MetouiaGradients;

public class MetouiaToolBarUI
extends MetalToolBarUI {
    private static final MetouiaToolBarUI toolBarUI = new MetouiaToolBarUI();
    private Insets insets = new Insets(2, 2, 2, 2);

    public static ComponentUI createUI(JComponent jComponent) {
        return toolBarUI;
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        super.paint(graphics, jComponent);
        int n = 0;
        if (jComponent instanceof JToolBar) {
            n = ((JToolBar)jComponent).getOrientation();
        }
        if (n == 0) {
            MetouiaGradients.drawHorizontalHighlight(graphics, jComponent);
            MetouiaGradients.drawHorizontalShadow(graphics, jComponent);
        } else {
            MetouiaGradients.drawVerticalHighlight(graphics, jComponent);
            MetouiaGradients.drawVerticalShadow(graphics, jComponent);
        }
    }

    protected void setBorderToRollover(Component component) {
        if (component instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)component;
            if (!abstractButton.isRolloverEnabled()) {
                abstractButton.setRolloverEnabled(true);
            }
            if (abstractButton.isContentAreaFilled()) {
                abstractButton.setContentAreaFilled(false);
            }
            if (abstractButton.isFocusPainted()) {
                abstractButton.setFocusPainted(false);
            }
            abstractButton.setMargin(this.insets);
        }
    }
}

