/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.util.Map;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windows;

public final class JoinWindows
extends Windows<Window> {
    public final long beforeMs;
    public final long afterMs;

    private JoinWindows(long beforeMs, long afterMs) {
        if (beforeMs + afterMs < 0L) {
            throw new IllegalArgumentException("Window interval (ie, beforeMs+afterMs) must not be negative.");
        }
        this.afterMs = afterMs;
        this.beforeMs = beforeMs;
    }

    public static JoinWindows of(long timeDifferenceMs) throws IllegalArgumentException {
        return new JoinWindows(timeDifferenceMs, timeDifferenceMs);
    }

    public JoinWindows before(long timeDifferenceMs) throws IllegalArgumentException {
        return new JoinWindows(timeDifferenceMs, this.afterMs);
    }

    public JoinWindows after(long timeDifferenceMs) throws IllegalArgumentException {
        return new JoinWindows(this.beforeMs, timeDifferenceMs);
    }

    @Override
    public Map<Long, Window> windowsFor(long timestamp) {
        throw new UnsupportedOperationException("windowsFor() is not supported by JoinWindows.");
    }

    @Override
    public long size() {
        return this.beforeMs + this.afterMs;
    }

    public JoinWindows until(long durationMs) throws IllegalArgumentException {
        if (durationMs < this.size()) {
            throw new IllegalArgumentException("Window retention time (durationMs) cannot be smaller than the window size.");
        }
        super.until(durationMs);
        return this;
    }

    @Override
    public long maintainMs() {
        return Math.max(super.maintainMs(), this.size());
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JoinWindows)) {
            return false;
        }
        JoinWindows other = (JoinWindows)o;
        return this.beforeMs == other.beforeMs && this.afterMs == other.afterMs;
    }

    public int hashCode() {
        int result = (int)(this.beforeMs ^ this.beforeMs >>> 32);
        result = 31 * result + (int)(this.afterMs ^ this.afterMs >>> 32);
        return result;
    }
}

