/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.CommonFields;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.StopReplicaResponse;
import org.apache.kafka.common.utils.Utils;

public class StopReplicaRequest
extends AbstractRequest {
    private static final String CONTROLLER_ID_KEY_NAME = "controller_id";
    private static final String CONTROLLER_EPOCH_KEY_NAME = "controller_epoch";
    private static final String DELETE_PARTITIONS_KEY_NAME = "delete_partitions";
    private static final String PARTITIONS_KEY_NAME = "partitions";
    private static final Schema STOP_REPLICA_REQUEST_PARTITION_V0 = new Schema(CommonFields.TOPIC_NAME, CommonFields.PARTITION_ID);
    private static final Schema STOP_REPLICA_REQUEST_V0 = new Schema(new Field("controller_id", Type.INT32, "The controller id."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("delete_partitions", Type.BOOLEAN, "Boolean which indicates if replica's partitions must be deleted."), new Field("partitions", new ArrayOf(STOP_REPLICA_REQUEST_PARTITION_V0)));
    private final int controllerId;
    private final int controllerEpoch;
    private final boolean deletePartitions;
    private final Set<TopicPartition> partitions;

    public static Schema[] schemaVersions() {
        return new Schema[]{STOP_REPLICA_REQUEST_V0};
    }

    private StopReplicaRequest(int controllerId, int controllerEpoch, boolean deletePartitions, Set<TopicPartition> partitions, short version) {
        super(version);
        this.controllerId = controllerId;
        this.controllerEpoch = controllerEpoch;
        this.deletePartitions = deletePartitions;
        this.partitions = partitions;
    }

    public StopReplicaRequest(Struct struct, short version) {
        super(version);
        this.partitions = new HashSet<TopicPartition>();
        for (Object partitionDataObj : struct.getArray(PARTITIONS_KEY_NAME)) {
            Struct partitionData = (Struct)partitionDataObj;
            String topic = partitionData.get(CommonFields.TOPIC_NAME);
            int partition = partitionData.get(CommonFields.PARTITION_ID);
            this.partitions.add(new TopicPartition(topic, partition));
        }
        this.controllerId = struct.getInt(CONTROLLER_ID_KEY_NAME);
        this.controllerEpoch = struct.getInt(CONTROLLER_EPOCH_KEY_NAME);
        this.deletePartitions = struct.getBoolean(DELETE_PARTITIONS_KEY_NAME);
    }

    @Override
    public StopReplicaResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        Errors error = Errors.forException(e);
        HashMap<TopicPartition, Errors> responses = new HashMap<TopicPartition, Errors>(this.partitions.size());
        for (TopicPartition partition : this.partitions) {
            responses.put(partition, error);
        }
        short versionId = this.version();
        switch (versionId) {
            case 0: {
                return new StopReplicaResponse(error, responses);
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ApiKeys.STOP_REPLICA.latestVersion()));
    }

    public int controllerId() {
        return this.controllerId;
    }

    public int controllerEpoch() {
        return this.controllerEpoch;
    }

    public boolean deletePartitions() {
        return this.deletePartitions;
    }

    public Set<TopicPartition> partitions() {
        return this.partitions;
    }

    public static StopReplicaRequest parse(ByteBuffer buffer, short version) {
        return new StopReplicaRequest(ApiKeys.STOP_REPLICA.parseRequest(version, buffer), version);
    }

    @Override
    protected Struct toStruct() {
        Struct struct = new Struct(ApiKeys.STOP_REPLICA.requestSchema(this.version()));
        struct.set(CONTROLLER_ID_KEY_NAME, (Object)this.controllerId);
        struct.set(CONTROLLER_EPOCH_KEY_NAME, (Object)this.controllerEpoch);
        struct.set(DELETE_PARTITIONS_KEY_NAME, (Object)this.deletePartitions);
        ArrayList<Struct> partitionDatas = new ArrayList<Struct>(this.partitions.size());
        for (TopicPartition partition : this.partitions) {
            Struct partitionData = struct.instance(PARTITIONS_KEY_NAME);
            partitionData.set(CommonFields.TOPIC_NAME, partition.topic());
            partitionData.set(CommonFields.PARTITION_ID, partition.partition());
            partitionDatas.add(partitionData);
        }
        struct.set(PARTITIONS_KEY_NAME, (Object)partitionDatas.toArray());
        return struct;
    }

    public static class Builder
    extends AbstractRequest.Builder<StopReplicaRequest> {
        private final int controllerId;
        private final int controllerEpoch;
        private final boolean deletePartitions;
        private final Set<TopicPartition> partitions;

        public Builder(int controllerId, int controllerEpoch, boolean deletePartitions, Set<TopicPartition> partitions) {
            super(ApiKeys.STOP_REPLICA);
            this.controllerId = controllerId;
            this.controllerEpoch = controllerEpoch;
            this.deletePartitions = deletePartitions;
            this.partitions = partitions;
        }

        @Override
        public StopReplicaRequest build(short version) {
            return new StopReplicaRequest(this.controllerId, this.controllerEpoch, this.deletePartitions, this.partitions, version);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type=StopReplicaRequest").append(", controllerId=").append(this.controllerId).append(", controllerEpoch=").append(this.controllerEpoch).append(", deletePartitions=").append(this.deletePartitions).append(", partitions=").append(Utils.join(this.partitions, ",")).append(")");
            return bld.toString();
        }
    }
}

