/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ic.doc.scenebeans;

import java.awt.Graphics2D;
import java.awt.Shape;
import uk.ac.ic.doc.scenebeans.Primitive;
import uk.ac.ic.doc.scenebeans.SceneGraphBase;
import uk.ac.ic.doc.scenebeans.SceneGraphProcessor;

public abstract class PrimitiveBase
extends SceneGraphBase
implements Primitive {
    private boolean _is_filled = true;
    private transient Shape _last_drawn = null;

    public boolean isFilled() {
        return this._is_filled;
    }

    public void setFilled(boolean bl) {
        this._is_filled = bl;
        this.setDirty(true);
    }

    public void draw(Graphics2D graphics2D) {
        Shape shape = this.getShape(graphics2D);
        if (this._is_filled) {
            graphics2D.fill(shape);
        } else {
            graphics2D.draw(shape);
        }
        this._last_drawn = shape;
        this.setDirty(false);
    }

    public void accept(SceneGraphProcessor sceneGraphProcessor) {
        sceneGraphProcessor.process(this);
    }

    public Shape getLastDrawnShape() {
        return this._last_drawn;
    }

    public abstract Shape getShape(Graphics2D var1);
}

