/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.session;

import java.io.Serializable;
import org.apache.catalina.cluster.Member;
import org.apache.catalina.cluster.session.SessionMessage;

public class SessionMessageImpl
implements SessionMessage,
Serializable {
    private int mEvtType = -1;
    private byte[] mSession;
    private String mSessionID;
    private Member mSrc;
    private String mContextName;
    private long serializationTimestamp;
    private boolean timestampSet = false;
    private String uniqueId;
    private int resend = 2;
    private int compress = 2;

    public SessionMessageImpl() {
    }

    private SessionMessageImpl(String contextName, int eventtype, byte[] session, String sessionID) {
        this.mEvtType = eventtype;
        this.mSession = session;
        this.mSessionID = sessionID;
        this.mContextName = contextName;
        this.uniqueId = sessionID;
    }

    public SessionMessageImpl(String contextName, int eventtype, byte[] session, String sessionID, String uniqueID) {
        this(contextName, eventtype, session, sessionID);
        this.uniqueId = uniqueID;
    }

    public int getEventType() {
        return this.mEvtType;
    }

    public byte[] getSession() {
        return this.mSession;
    }

    public String getSessionID() {
        return this.mSessionID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimestamp(long time) {
        SessionMessageImpl sessionMessageImpl = this;
        synchronized (sessionMessageImpl) {
            if (!this.timestampSet) {
                this.serializationTimestamp = time;
                this.timestampSet = true;
            }
        }
    }

    public long getTimestamp() {
        return this.serializationTimestamp;
    }

    public String getEventTypeString() {
        switch (this.mEvtType) {
            case 1: {
                return "SESSION-MODIFIED";
            }
            case 2: {
                return "SESSION-EXPIRED";
            }
            case 3: {
                return "SESSION-ACCESSED";
            }
            case 4: {
                return "SESSION-GET-ALL";
            }
            case 13: {
                return "SESSION-DELTA";
            }
            case 12: {
                return "ALL-SESSION-DATA";
            }
            case 14: {
                return "SESSION-STATE-TRANSFERED";
            }
            case 15: {
                return "SESSION-ID-CHANGED";
            }
        }
        return "UNKNOWN-EVENT-TYPE";
    }

    public Member getAddress() {
        return this.mSrc;
    }

    public void setAddress(Member src) {
        this.mSrc = src;
    }

    public String getContextName() {
        return this.mContextName;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public int getCompress() {
        return this.compress;
    }

    public void setCompress(int compress) {
        this.compress = compress;
    }

    public int getResend() {
        return this.resend;
    }

    public void setResend(int resend) {
        this.resend = resend;
    }
}

