/*
 * Decompiled with CFR 0.152.
 */
package com.gokgs.client.swing.plaf;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalButtonUI;
import org.igoweb.go.swing.StoneImages;

public class ButtonUI
extends MetalButtonUI {
    private static final int MAX_SIZE = 64;
    private static final int MAX_RADIUS = 12;
    private static final ButtonUI ui = new ButtonUI();
    private static final BufferedImage[][] borders = new BufferedImage[26][];
    private static final int[] widthAdds = new int[13];
    private static Color buttonBg;
    private static Color darkBg;

    private static void makeBorders(int radius) {
        ButtonUI.borders[radius] = ButtonUI.doBorders(radius, false);
        ButtonUI.borders[radius + 12] = ButtonUI.doBorders(radius, true);
    }

    private static BufferedImage[] doBorders(int radius, boolean darker) {
        int i;
        BufferedImage[] bl = new BufferedImage[8];
        for (i = 0; i < 4; ++i) {
            bl[i] = new BufferedImage(radius, radius, 2);
        }
        for (i = 4; i < 6; ++i) {
            bl[i] = new BufferedImage(64, radius, 1);
        }
        for (i = 6; i < 8; ++i) {
            bl[i] = new BufferedImage(radius, 64, 1);
        }
        BufferedImage bigImg = new BufferedImage(radius * 2, radius * 2, 2);
        StoneImages.Props props = new StoneImages.Props(0);
        float midColor = (float)StoneImages.getBrightness(radius * 2, radius, radius, props) / 256.0f;
        buttonBg = new Color(midColor, midColor, midColor);
        darkBg = new Color(midColor * 0.75f, midColor * 0.75f, midColor * 0.75f);
        for (int y = 0; y < radius * 2; ++y) {
            int x;
            int bright = (int)((StoneImages.getBrightness(radius * 2 - 1, (double)radius - 0.5, (double)y - 0.25, props) + StoneImages.getBrightness(radius * 2 - 1, (double)radius - 0.5, (double)y + 0.25, props)) * 0.5);
            if (darker) {
                bright = bright * 3 / 4;
            }
            bright = bright << 16 | bright << 8 | bright;
            if (y == 0 || y == radius * 2 - 1) {
                bright = bright >> 1 & 0xFF7F7F7F;
            }
            for (x = 0; x < 64; ++x) {
                if (y < radius) {
                    bl[4].setRGB(x, y, bright);
                    bl[6].setRGB(y, x, bright);
                    continue;
                }
                bl[5].setRGB(x, y - radius, bright);
                bl[7].setRGB(y - radius, x, bright);
            }
            for (x = 0; x < radius * 2; ++x) {
                int color = StoneImages.getColor(radius * 2, x, y, props);
                if (darker) {
                    color = (color & 0xFF) * 3 / 4;
                    color |= color << 16 | color << 8;
                }
                bigImg.setRGB(x, y, 0xFF000000 | color);
            }
        }
        Graphics2D g2d = bigImg.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        Rectangle2D.Double fullImage = new Rectangle2D.Double(0.0, 0.0, radius * 2, radius * 2);
        Area stoneClip = new Area(fullImage);
        stoneClip.subtract(new Area(new Ellipse2D.Double(0.5, 0.5, radius * 2 - 1, radius * 2 - 1)));
        g2d.setColor(Color.black);
        g2d.fill(stoneClip);
        g2d.setComposite(AlphaComposite.getInstance(1));
        stoneClip = new Area(fullImage);
        stoneClip.subtract(new Area(new Ellipse2D.Double(0.0, 0.0, radius * 2, radius * 2)));
        g2d.fill(stoneClip);
        for (int x = 0; x < radius; ++x) {
            for (int y = 0; y < radius; ++y) {
                bl[0].setRGB(x, y, bigImg.getRGB(x, y));
                bl[1].setRGB(x, y, bigImg.getRGB(x + radius, y));
                bl[2].setRGB(x, y, bigImg.getRGB(x, y + radius));
                bl[3].setRGB(x, y, bigImg.getRGB(x + radius, y + radius));
            }
        }
        bigImg.flush();
        return bl;
    }

    private ButtonUI() {
    }

    public static ComponentUI createUI(JComponent c) {
        if (c.getClass() == JButton.class) {
            return ui;
        }
        return MetalButtonUI.createUI(c);
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        c.setOpaque(false);
        c.setBorder(null);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension result = super.getPreferredSize(c);
        result.height += 5;
        result.width += 5;
        if (result.width <= result.height) {
            result.width = result.height;
            return result;
        }
        result.width = result.height <= 25 ? (result.width += widthAdds[result.height >> 1]) : (result.width += widthAdds[12]);
        return result;
    }

    @Override
    protected void paintButtonPressed(Graphics g, AbstractButton b) {
    }

    @Override
    public void update(Graphics g, JComponent c) {
        ButtonModel model;
        boolean isDarker;
        int radius;
        int w = c.getWidth();
        int h = c.getHeight();
        int yOff = 0;
        if (h > w) {
            yOff = h - w >> 1;
            h = w;
        }
        if ((radius = h >> 1) > 12) {
            radius = 12;
        }
        boolean bl = isDarker = (model = ((AbstractButton)c).getModel()).isArmed() && model.isPressed();
        if (radius > 0) {
            if (borders[radius] == null) {
                ButtonUI.makeBorders(radius);
            }
            BufferedImage[] bl2 = borders[radius + (isDarker ? 12 : 0)];
            g.drawImage(bl2[0], 0, yOff, null);
            g.drawImage(bl2[1], w - radius, yOff, null);
            g.drawImage(bl2[2], 0, yOff + h - radius, null);
            g.drawImage(bl2[3], w - radius, yOff + h - radius, null);
            Shape oldClip = g.getClip();
            if (w > radius * 2) {
                g.clipRect(radius, yOff, w - radius * 2, h);
                for (int x = radius; x < w - radius; x += 64) {
                    g.drawImage(bl2[4], x, yOff, null);
                    g.drawImage(bl2[5], x, yOff + h - radius, null);
                }
                g.setClip(oldClip);
            }
            if (h > radius * 2) {
                g.clipRect(0, yOff + radius, w, h - radius * 2);
                for (int y = radius; y < h - radius; y += 64) {
                    g.drawImage(bl2[6], 0, yOff + y, null);
                    g.drawImage(bl2[7], w - radius, yOff + y, null);
                }
                g.setClip(oldClip);
                if (w > radius * 2) {
                    g.setColor(isDarker ? darkBg : buttonBg);
                    g.fillRect(radius, yOff + radius, w - radius * 2, h - radius * 2);
                }
            }
            this.paint(g, c);
        }
    }

    static {
        for (int i = 1; i <= 12; ++i) {
            ButtonUI.widthAdds[i] = i * 2 - (int)(Math.sqrt(i * i - (i - 2) * (i - 2)) * 2.0);
        }
    }
}

