/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.deprecation;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.support.nodes.BaseNodeRequest;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.action.support.nodes.NodesOperationRequestBuilder;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.core.deprecation.DeprecationIssue;
import org.elasticsearch.xpack.core.deprecation.NodesDeprecationCheckRequest;
import org.elasticsearch.xpack.core.deprecation.NodesDeprecationCheckResponse;

public class NodesDeprecationCheckAction
extends Action<NodesDeprecationCheckRequest, NodesDeprecationCheckResponse, RequestBuilder> {
    public static final NodesDeprecationCheckAction INSTANCE = new NodesDeprecationCheckAction();
    public static final String NAME = "cluster:admin/xpack/deprecation/nodes/info";

    private NodesDeprecationCheckAction() {
        super(NAME);
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client, INSTANCE, new NodesDeprecationCheckRequest());
    }

    public NodesDeprecationCheckResponse newResponse() {
        return new NodesDeprecationCheckResponse();
    }

    public static class RequestBuilder
    extends NodesOperationRequestBuilder<NodesDeprecationCheckRequest, NodesDeprecationCheckResponse, RequestBuilder> {
        protected RequestBuilder(ElasticsearchClient client, Action<NodesDeprecationCheckRequest, NodesDeprecationCheckResponse, RequestBuilder> action, NodesDeprecationCheckRequest request) {
            super(client, action, (BaseNodesRequest)request);
        }
    }

    public static class NodeResponse
    extends BaseNodeResponse {
        private List<DeprecationIssue> deprecationIssues;

        public NodeResponse() {
        }

        public NodeResponse(DiscoveryNode node, List<DeprecationIssue> deprecationIssues) {
            super(node);
            this.deprecationIssues = deprecationIssues;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.deprecationIssues = in.readList(DeprecationIssue::new);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeList(this.deprecationIssues);
        }

        public static NodeResponse readNodeResponse(StreamInput in) throws IOException {
            NodeResponse nodeResponse = new NodeResponse();
            nodeResponse.readFrom(in);
            return nodeResponse;
        }

        public List<DeprecationIssue> getDeprecationIssues() {
            return this.deprecationIssues;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            NodeResponse that = (NodeResponse)((Object)o);
            return Objects.equals(this.getDeprecationIssues(), that.getDeprecationIssues()) && Objects.equals(this.getNode(), that.getNode());
        }

        public int hashCode() {
            return Objects.hash(this.getNode(), this.getDeprecationIssues());
        }
    }

    public static class NodeRequest
    extends BaseNodeRequest {
        NodesDeprecationCheckRequest request;

        public NodeRequest() {
        }

        public NodeRequest(String nodeId, NodesDeprecationCheckRequest request) {
            super(nodeId);
            this.request = request;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.request = new NodesDeprecationCheckRequest();
            this.request.readFrom(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.request.writeTo(out);
        }
    }
}

