/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ssl;

import java.io.IOException;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.X509ExtendedTrustManager;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.core.ssl.CertParsingUtils;
import org.elasticsearch.xpack.core.ssl.TrustConfig;
import org.elasticsearch.xpack.core.ssl.cert.CertificateInfo;

class StoreTrustConfig
extends TrustConfig {
    final String trustStorePath;
    final String trustStoreType;
    final SecureString trustStorePassword;
    final String trustStoreAlgorithm;

    StoreTrustConfig(String trustStorePath, String trustStoreType, SecureString trustStorePassword, String trustStoreAlgorithm) {
        this.trustStorePath = trustStorePath;
        this.trustStoreType = trustStoreType;
        this.trustStorePassword = Objects.requireNonNull(trustStorePassword, "truststore password must be specified").clone();
        this.trustStoreAlgorithm = trustStoreAlgorithm;
    }

    @Override
    X509ExtendedTrustManager createTrustManager(@Nullable Environment environment) {
        try {
            KeyStore trustStore = this.getStore(environment, this.trustStorePath, this.trustStoreType, this.trustStorePassword);
            return CertParsingUtils.trustManager(trustStore, this.trustStoreAlgorithm);
        }
        catch (Exception e) {
            throw new ElasticsearchException("failed to initialize a TrustManagerFactory", (Throwable)e, new Object[0]);
        }
    }

    @Override
    Collection<CertificateInfo> certificates(Environment environment) throws GeneralSecurityException, IOException {
        KeyStore trustStore = this.getStore(environment, this.trustStorePath, this.trustStoreType, this.trustStorePassword);
        ArrayList<CertificateInfo> certificates = new ArrayList<CertificateInfo>();
        Enumeration<String> aliases = trustStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            Certificate certificate = trustStore.getCertificate(alias);
            if (!(certificate instanceof X509Certificate)) continue;
            boolean hasKey = trustStore.isKeyEntry(alias);
            certificates.add(new CertificateInfo(this.trustStorePath, this.trustStoreType, alias, hasKey, (X509Certificate)certificate));
        }
        return certificates;
    }

    @Override
    List<Path> filesToMonitor(@Nullable Environment environment) {
        if (this.trustStorePath == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(CertParsingUtils.resolvePath(this.trustStorePath, environment));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoreTrustConfig that = (StoreTrustConfig)o;
        if (this.trustStorePath != null ? !this.trustStorePath.equals(that.trustStorePath) : that.trustStorePath != null) {
            return false;
        }
        if (this.trustStorePassword != null ? !this.trustStorePassword.equals((Object)that.trustStorePassword) : that.trustStorePassword != null) {
            return false;
        }
        return this.trustStoreAlgorithm != null ? this.trustStoreAlgorithm.equals(that.trustStoreAlgorithm) : that.trustStoreAlgorithm == null;
    }

    @Override
    public int hashCode() {
        int result = this.trustStorePath != null ? this.trustStorePath.hashCode() : 0;
        result = 31 * result + (this.trustStorePassword != null ? this.trustStorePassword.hashCode() : 0);
        result = 31 * result + (this.trustStoreAlgorithm != null ? this.trustStoreAlgorithm.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "trustStorePath=[" + this.trustStorePath + "], trustStoreAlgorithm=[" + this.trustStoreAlgorithm + "]";
    }
}

