/* Test gCAD3D - RemoteControl from java. 2012-01-02




# start this prog:
# start gcad3d
# open a terminal
cd
cd gCAD3D/prg
java DemoRC1



# compile & start this prog:
javac DemoRC1.java && java DemoRC1


*/




import java.io.*;               // BufferedWriter

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;





//================================================================
public class DemoRC1 extends JFrame {
//================================================================


  static DemoRC1 win0;

  static String nlc;             // newLineChar
  static String lnrOld = null;
  static String ptOri = null;    // originpoint

  Container cont1 = getContentPane();
  Box boxV0 = Box.createVerticalBox();
  Box boxH1 = Box.createHorizontalBox();
  Box boxH2 = Box.createHorizontalBox();
  Box boxH3 = Box.createHorizontalBox();
  Box boxH4 = Box.createHorizontalBox();

  final JButton     b1, b2, b3, b4, bt_send, bt_rect;
  final JTextField  en_w, en_h, en_send, en_msg;

  ButtonListener btCB = new ButtonListener();

  static int            actFun;
  static BufferedReader fcadin;
  static BufferedWriter fcadout;





//================================================================
  public static void main (String[] args) {
//================================================================
  
  System.out.println("DemoRC1 starting ..");

  // connect cad
  cadConnInit();

  // bring up window
  win0 = new DemoRC1();

  System.out.println("DemoRC1 is up ..");

}


//================================================================
  public DemoRC1 () {
//================================================================

  super();  // 
  super.setAlwaysOnTop(true);


  JLabel lb1;
 
  // add boxV0 into cont1
  cont1.add(boxV0);

  boxV0.add(boxH1);
  boxV0.add(boxH2);
  boxV0.add(boxH3);
  boxV0.add(boxH4);     // messagefield


  b1 = new JButton ("new");
  b1.addActionListener (btCB);
  b1.setToolTipText("clear cad-model");
  boxH1.add (b1);

  b2 = new JButton ("test1");
  // b2.setBackground (Color.RED);
  b2.addActionListener (btCB);
  b2.setToolTipText("create a point and a circle in cad");
  boxH1.add (b2);

  b3 = new JButton ("test2");
  b3.addActionListener (btCB);
  b3.setToolTipText("create assembly in cad");
  boxH1.add (b3);

  b4 = new JButton ("undo-Rect");
  b4.addActionListener (btCB);
  b4.setToolTipText("remove last created rectangle");
  boxH1.add (b4);



  bt_send = new JButton ("send");
  bt_send.addActionListener (btCB);
  bt_send.setToolTipText("send text left of this button to cad");
  boxH2.add (bt_send);

  en_send = new JTextField(20);
  en_send.setText(" - ");
  boxH2.add (en_send);



  bt_rect = new JButton ("rect");
  bt_rect.addActionListener (btCB);
  bt_rect.setToolTipText("select point/position and create rectangular surface");
  boxH3.add (bt_rect);

  lb1 = new JLabel ("width:");
  boxH3.add (lb1);

  en_w = new JTextField(6);
  en_w.setText("50");
  boxH3.add (en_w);

  lb1 = new JLabel ("height:");
  boxH3.add (lb1);

  en_h = new JTextField(6);
  en_h.setText("100");
  boxH3.add (en_h);



  en_msg = new JTextField(30);
  en_msg.setEditable(false);
  en_msg.setText(" - ");
  boxH4.add (en_msg);


  //----------------------------------------------------------------
  addWindowListener(new win_CB());  // catch close-window-event
  setTitle ("test gCAD3D remoteControl");
  getContentPane().setBackground (Color.LIGHT_GRAY);
  // setSize(230,140);
  // setLocation(200,100);
  pack();
  // minimumsize = defaultsize
  setMinimumSize(getSize());

  setVisible(true);
}


//================================================================
class win_CB extends WindowAdapter {
//================================================================
// catch close-window-event
 
    public void windowClosing (WindowEvent ew) {
      System.out.println("windowClosing ..");
      try {
        fcadout.close();
        fcadin.close();
      } catch (IOException e) {
        System.out.println("error closing pipes ..");
      }
      ew.getWindow().dispose();
      System.exit(0);
    }

}


//================================================================
class ButtonListener implements ActionListener {
//================================================================


//================================================================
  public void actionPerformed (ActionEvent e) {
//================================================================
// buttons-callback

  String     s1 = null;

  System.out.println("actionPerformed ..");

  //----------------------------------------------------------------
  if(e.getSource() == b1) {
    s1 = cadCmd("new");
    return;
  }

  //----------------------------------------------------------------
  if(e.getSource() == b2) {
    cadTest1 ();
    return;
  }

  //----------------------------------------------------------------
  if(e.getSource() == b3) {
    en_msg.setText("select or indicate point in CAD .."); 
    ui_enable (false);  // lock all buttons
    actFun = 3;
    SwingUtilities.invokeLater(proc_later1);
    return;
  }


  //----------------------------------------------------------------
  if(e.getSource() == b4) {
    if(lnrOld != null) {
      s1 = cadCmd("DELFOLL(" + lnrOld + ")");
      lnrOld = null;
    }
    return;
  }

  //----------------------------------------------------------------
  if(e.getSource() == bt_send) { 
    s1 = cadCmd(en_send.getText());
    return;
  } 
  
  //----------------------------------------------------------------
  if(e.getSource() == bt_rect) {
    en_msg.setText("select or indicate point in CAD .."); 
    ui_enable (false);  // lock all buttons
    actFun = 7;
    SwingUtilities.invokeLater(proc_later1);
    return;
  }


}

} // END OF CLASS ButtonListener



//================================================================
Runnable proc_later1 = new Runnable() {
//================================================================
 
  String  s1;

  public void run () {

    if(actFun == 3) {
      s1 = cadTest2 ();
      if(s1 == null) s1 = "OK ..";
      en_msg.setText(s1);
      ui_enable (true);
    }

    if(actFun == 7) {
      s1 = cadTest3 (en_h.getText(),en_w.getText());
      if(s1 == null) s1 = "OK ..";
      en_msg.setText(s1);
      ui_enable (true);
    }
  }

};

 
//================================================================
public void ui_enable (boolean mode) {
//================================================================
// lock / unlock gui-buttons
 
    b1.setEnabled(mode);
    b2.setEnabled(mode);
    b3.setEnabled(mode);
    b4.setEnabled(mode);
    bt_send.setEnabled(mode);
    bt_rect.setEnabled(mode);

}


//================================================================
private static String cadCmd (String cmd) {
//================================================================
// send command -> cad; return answer.


  String   s1 = "";

  // write command -> cad
  try {
    fcadout.write(cmd + nlc);
    fcadout.flush();

  } catch (IOException e) {
    System.out.println("error write out-pipe");
    return s1;
  }
    System.out.println("cadCmd: sent |" + cmd + "|");


  // read answer from cad
  try {
    s1 = fcadin.readLine();

  } catch (Exception e) {
    System.out.println("Lesefehler");
    return s1;
  }

  System.out.println("cadCmd: got |" + s1 + "|");

  return s1;

}


//================================================================
private static int cadConnInit () {
//================================================================
// blocks until gcad is up.

  String   s1;

  nlc = System.getProperty("line.separator");


  System.out.println("waiting for gCAD3D ..");


  // open command-out-channel
  s1 = System.getenv ("HOME");
  s1 += "/gCAD3D/tmp/CTRLpin";
  try {
    fcadout = new BufferedWriter(new FileWriter(s1,true));

  } catch (IOException e) {
    s1 = "error open pipe " + s1;
    System.out.println(s1);
    errMsg (s1);
    return -1;
  }
  System.out.println("pipout " + s1 + " open ..");





  // open input-channel
  s1 = System.getenv ("HOME");
  s1 += "/gCAD3D/tmp/CTRLpout";
  try {
    fcadin = new BufferedReader(new FileReader(s1));

  } catch (Exception e) {
    s1 = "error open pipe " + s1;
    System.out.println(s1);
    errMsg (s1);
    return -2;
  }
  System.out.println("pipin " + s1 + " open ..");
                                     

  try {
    if(!fcadin.ready()) System.out.println("ready");

  } catch (Exception e) {
    s1 = "Lesefehler";
    System.out.println(s1);
    errMsg (s1);
    return -3;
  }

/*
  // clear input-channel
  try {
    while ((s1 = fcadin.readLine()) != null) {
      System.out.println(s1);
    }
  } catch (Exception e) {
    System.out.println("Lesefehler");
    return -4;
  }
*/

  System.out.println("cadConn ok ..");

  return 0;

}


//================================================================
private static int cadTest1 () {
//================================================================
 
  String    s1;


  s1 = cadCmd("add(P1=P(100 0 0 ))");
  s1 = cadCmd("add(C1=P1 40)");

  return 0;

}


//================================================================
private static String cadTest2 () {
//================================================================

  int       i1;
  String    soi, s1, s2, s3, s4, sEx = null;

  System.out.println("cadTest2");


  // get ptOri from User
  sEx = cadGetPoint();
  if(sEx != null) return sEx;


  // load submodels
  s1 = cadCmd("loadsm(\"Data/sample_mod_blech1.gcad\")");
  s1 = cadCmd("loadsm(\"Data/sample_mod_screw1.gcad\")");
  // s1 = cadCmd("loadsm(\"Data/sample_mod_nut1.gcad\")");


  // get mext free index for model
  soi = cadCmd("GETOBJINDNXT(M)");


  s2 = "ADD(M" + soi + "=\"sample_mod_blech1\" " + ptOri + ")";
  s3 = cadCmd(s2);

  // incr. modelindex
  soi = String.valueOf(Integer.valueOf(soi) + 1);

  s1 = " P(" + ptOri + " X(30) Y(26.5) Z(67))";
  s2 = "ADD(M" + soi + "=\"sample_mod_screw1\" " + s1 + ")";
  s3 = cadCmd(s2);


  return sEx;

}


//================================================================
private static String cadTest3 (String s_w, String s_h) {
//================================================================
  
  int       i1;
  String    sp2, sp3, sp4; // polygonpoints
  String    s1, s2, s3, s4, sEx = null;
    
  System.out.println("cadTest3 "+ s_w + " " + s_h);


  // get current lineNr for undo
  lnrOld = cadCmd("GETLNR");


  // get ptOri from User
  sEx = cadGetPoint();
  if(sEx != null) {
    lnrOld = null;
    return sEx;
  }


  // create the points of the rectangle; startpoint = ptOri
  sp2 = " P(" + ptOri + " X(" + s_w + "))";
  sp3 = " P(" + ptOri + " X(" + s_w + ") Y(" + s_h +"))";
  sp4 = " P(" + ptOri + " Y(" + s_h + ")) ";

  // get db-ind of next free curve
  s2 = cadCmd("GETOBJINDNXT(S)");

  // create the polygon
  s3 = "ADD(S" + s2 + "=POL " + ptOri + sp2 + sp3 + sp4 + ptOri + ")";
  s1 = cadCmd(s3);

  // get db-ind of next free surface
  s1 = cadCmd("GETOBJINDNXT(A)");

  // create the surface
  s3 = "ADD(A" + s1 + "=S" + s2 + ")";
  s4 = cadCmd(s3);


  // apply color to surface
  s3 = "ATTS(\"C00ff00\" A" + s1 + ")";
  s4 = cadCmd(s3);
    

  // closing message ..
  s4 = cadCmd("PRINT(\"Surface A" + s1 + " created ..\")");

  return sEx;

}


//================================================================
public static String cadGetPoint () {
//================================================================
// sets point ptOri
// Returns: null = OK; else Errormessage.
 
  int     i1;
  String  s1, s2, s3, sEx = null;

  System.out.println("cadGetPoint ");

  // get startposition
  s1 = cadCmd("PRINT(\" ** select or indicate point\")");
  s1 = cadCmd("USER");
    System.out.println("|" + s1 + "| - l =" + s1.length());

  i1 = s1.length();
  if(i1 < 6) {           // "SEL()" - skip ESC
    sEx = "User-abort (Escape) ..";
    s1 = cadCmd("PRINT(\""+ sEx + "\")");
    return sEx;
  }

  // remove first 4 and last char
  i1 = s1.length();
  ptOri = s1.substring(4, i1-1);
    System.out.println("|" + ptOri + "|");


  // test if it is a point (1. char must be P)
  if(ptOri.charAt(0) != 'P') {
    sEx = "Error: selected object is not point or position ..";
    s1 = cadCmd("PRINT(\""+ sEx + "\")");
    return sEx;
  }


  // test point or position
  if(ptOri.charAt(1) == '(') {

    // get db-ind of next free point
    s2 = cadCmd("GETOBJINDNXT(P)");

    // create point at indicated position
    s3 = "ADD(P" + s2 + "=" + ptOri + ")";
    s1 = cadCmd(s3);
    ptOri = "P" + s2;
  }


  System.out.println("ex getPoint: |" + ptOri + "|");

  return sEx;

}


//================================================================
  public static void errMsg (String sMsg) {
//================================================================
// display exit-message in modal dialog-window
 
  JOptionPane.showMessageDialog(win0, sMsg, "ERROR",
                                JOptionPane.ERROR_MESSAGE);

  System.exit(0);

}


} // END OF CLASS


// EOF
