/*
 * Decompiled with CFR 0.152.
 */
package jflex;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jflex.ErrorMessages;
import jflex.MacroException;
import jflex.RegExp;
import jflex.RegExp1;
import jflex.RegExp2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Macros {
    private Map<String, RegExp> macros = new HashMap<String, RegExp>();
    private Map<String, Boolean> used = new HashMap<String, Boolean>();

    public boolean insert(String name, RegExp definition) {
        this.used.put(name, Boolean.FALSE);
        return this.macros.put(name, definition) == null;
    }

    public boolean markUsed(String name) {
        return this.used.put(name, Boolean.TRUE) != null;
    }

    public boolean isUsed(String name) {
        return this.used.get(name);
    }

    public List<String> unused() {
        ArrayList<String> unUsed = new ArrayList<String>();
        for (String name : this.used.keySet()) {
            Boolean isUsed = this.used.get(name);
            if (isUsed.booleanValue()) continue;
            unUsed.add(name);
        }
        return unUsed;
    }

    public RegExp getDefinition(String name) {
        return this.macros.get(name);
    }

    public void expand() throws MacroException {
        for (String name : this.macros.keySet()) {
            if (!this.isUsed(name)) continue;
            this.macros.put(name, this.expandMacro(name, this.getDefinition(name)));
        }
    }

    private RegExp expandMacro(String name, RegExp definition) throws MacroException {
        switch (definition.type) {
            case 44: 
            case 57: {
                RegExp2 binary = (RegExp2)definition;
                binary.r1 = this.expandMacro(name, binary.r1);
                binary.r2 = this.expandMacro(name, binary.r2);
                return definition;
            }
            case 42: 
            case 43: 
            case 45: 
            case 48: 
            case 49: {
                RegExp1 unary = (RegExp1)definition;
                unary.content = this.expandMacro(name, (RegExp)unary.content);
                return definition;
            }
            case 52: {
                String usename = (String)((RegExp1)definition).content;
                if (name.equals(usename)) {
                    throw new MacroException(ErrorMessages.get(ErrorMessages.MACRO_CYCLE, name));
                }
                RegExp usedef = this.getDefinition(usename);
                if (usedef == null) {
                    throw new MacroException(ErrorMessages.get(ErrorMessages.MACRO_DEF_MISSING, usename, name));
                }
                this.markUsed(usename);
                return this.expandMacro(name, usedef);
            }
            case 50: 
            case 51: 
            case 55: 
            case 56: 
            case 58: 
            case 59: {
                return definition;
            }
        }
        throw new MacroException("unknown expression type " + definition.type + " in macro expansion");
    }
}

