/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.IntrospectionHelper;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.EnumeratedAttribute;

public class AntStructure
extends Task {
    private final String lSep = System.getProperty("line.separator");
    private final String BOOLEAN = "%boolean;";
    private final String TASKS = "%tasks;";
    private final String TYPES = "%types;";
    private Hashtable visited = new Hashtable();
    private File output;
    static /* synthetic */ Class class$org$apache$tools$ant$types$Reference;
    static /* synthetic */ Class class$org$apache$tools$ant$TaskContainer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$org$apache$tools$ant$types$EnumeratedAttribute;

    public void setOutput(File output) {
        this.output = output;
    }

    public void execute() throws BuildException {
        if (this.output == null) {
            throw new BuildException("output attribute is required", this.location);
        }
        PrintWriter out = null;
        try {
            try {
                try {
                    out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.output), "UTF8"));
                }
                catch (UnsupportedEncodingException ue) {
                    out = new PrintWriter(new FileWriter(this.output));
                }
                this.printHead(out, this.project.getTaskDefinitions().keys(), this.project.getDataTypeDefinitions().keys());
                this.printTargetDecl(out);
                Enumeration dataTypes = this.project.getDataTypeDefinitions().keys();
                while (dataTypes.hasMoreElements()) {
                    String typeName = (String)dataTypes.nextElement();
                    this.printElementDecl(out, typeName, (Class)this.project.getDataTypeDefinitions().get(typeName));
                }
                Enumeration tasks = this.project.getTaskDefinitions().keys();
                while (tasks.hasMoreElements()) {
                    String taskName = (String)tasks.nextElement();
                    this.printElementDecl(out, taskName, (Class)this.project.getTaskDefinitions().get(taskName));
                }
                this.printTail(out);
            }
            catch (IOException ioe) {
                throw new BuildException("Error writing " + this.output.getAbsolutePath(), ioe, this.location);
            }
            Object var6_7 = null;
            if (out != null) {
                out.close();
            }
            this.visited.clear();
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (out != null) {
                out.close();
            }
            this.visited.clear();
            throw throwable;
        }
    }

    private void printHead(PrintWriter out, Enumeration tasks, Enumeration types) {
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        out.println("<!ENTITY % boolean \"(true|false|on|off|yes|no)\">");
        out.print("<!ENTITY % tasks \"");
        boolean first = true;
        while (tasks.hasMoreElements()) {
            String taskName = (String)tasks.nextElement();
            if (!first) {
                out.print(" | ");
            } else {
                first = false;
            }
            out.print(taskName);
        }
        out.println("\">");
        out.print("<!ENTITY % types \"");
        first = true;
        while (types.hasMoreElements()) {
            String typeName = (String)types.nextElement();
            if (!first) {
                out.print(" | ");
            } else {
                first = false;
            }
            out.print(typeName);
        }
        out.println("\">");
        out.println("");
        out.print("<!ELEMENT project (target | property | taskdef");
        out.print(" | typedef | ");
        out.print("%types;");
        out.println(")*>");
        out.println("<!ATTLIST project");
        out.println("          name    CDATA #IMPLIED");
        out.println("          default CDATA #REQUIRED");
        out.println("          basedir CDATA #IMPLIED>");
        out.println("");
    }

    private void printTargetDecl(PrintWriter out) {
        out.print("<!ELEMENT target (");
        out.print("%tasks;");
        out.print(" | ");
        out.print("%types;");
        out.println(")*>");
        out.println("");
        out.println("<!ATTLIST target");
        out.println("          id          ID    #IMPLIED");
        out.println("          name        CDATA #REQUIRED");
        out.println("          if          CDATA #IMPLIED");
        out.println("          unless      CDATA #IMPLIED");
        out.println("          depends     CDATA #IMPLIED");
        out.println("          description CDATA #IMPLIED>");
        out.println("");
    }

    private void printElementDecl(PrintWriter out, String name, Class element) throws BuildException {
        int i;
        int count;
        if (this.visited.containsKey(name)) {
            return;
        }
        this.visited.put(name, "");
        IntrospectionHelper ih = null;
        try {
            ih = IntrospectionHelper.getHelper(element);
        }
        catch (Throwable t) {
            return;
        }
        StringBuffer sb = new StringBuffer("<!ELEMENT ");
        sb.append(name).append(" ");
        if ((class$org$apache$tools$ant$types$Reference == null ? (class$org$apache$tools$ant$types$Reference = AntStructure.class$("org.apache.tools.ant.types.Reference")) : class$org$apache$tools$ant$types$Reference).equals(element)) {
            sb.append("EMPTY>").append(this.lSep);
            sb.append("<!ATTLIST ").append(name);
            sb.append(this.lSep).append("          id ID #IMPLIED");
            sb.append(this.lSep).append("          refid IDREF #IMPLIED");
            sb.append(">").append(this.lSep);
            out.println(sb);
            return;
        }
        Vector<String> v = new Vector<String>();
        if (ih.supportsCharacters()) {
            v.addElement("#PCDATA");
        }
        if ((class$org$apache$tools$ant$TaskContainer == null ? (class$org$apache$tools$ant$TaskContainer = AntStructure.class$("org.apache.tools.ant.TaskContainer")) : class$org$apache$tools$ant$TaskContainer).isAssignableFrom(element)) {
            v.addElement("%tasks;");
        }
        Enumeration enumeration = ih.getNestedElements();
        while (enumeration.hasMoreElements()) {
            v.addElement((String)enumeration.nextElement());
        }
        if (v.isEmpty()) {
            sb.append("EMPTY");
        } else {
            sb.append("(");
            count = v.size();
            for (i = 0; i < count; ++i) {
                if (i != 0) {
                    sb.append(" | ");
                }
                sb.append(v.elementAt(i));
            }
            sb.append(")");
            if (count > 1 || !v.elementAt(0).equals("#PCDATA")) {
                sb.append("*");
            }
        }
        sb.append(">");
        out.println(sb);
        sb.setLength(0);
        sb.append("<!ATTLIST ").append(name);
        sb.append(this.lSep).append("          id ID #IMPLIED");
        enumeration = ih.getAttributes();
        while (enumeration.hasMoreElements()) {
            block26: {
                String attrName = (String)enumeration.nextElement();
                if ("id".equals(attrName)) continue;
                sb.append(this.lSep).append("          ").append(attrName).append(" ");
                Class type = ih.getAttributeType(attrName);
                if (type.equals(class$java$lang$Boolean == null ? AntStructure.class$("java.lang.Boolean") : class$java$lang$Boolean) || type.equals(Boolean.TYPE)) {
                    sb.append("%boolean;").append(" ");
                } else if ((class$org$apache$tools$ant$types$Reference == null ? AntStructure.class$("org.apache.tools.ant.types.Reference") : class$org$apache$tools$ant$types$Reference).isAssignableFrom(type)) {
                    sb.append("IDREF ");
                } else if ((class$org$apache$tools$ant$types$EnumeratedAttribute == null ? AntStructure.class$("org.apache.tools.ant.types.EnumeratedAttribute") : class$org$apache$tools$ant$types$EnumeratedAttribute).isAssignableFrom(type)) {
                    try {
                        EnumeratedAttribute ea = (EnumeratedAttribute)type.newInstance();
                        String[] values = ea.getValues();
                        if (values == null || values.length == 0 || !this.areNmtokens(values)) {
                            sb.append("CDATA ");
                            break block26;
                        }
                        sb.append("(");
                        for (int i2 = 0; i2 < values.length; ++i2) {
                            if (i2 != 0) {
                                sb.append(" | ");
                            }
                            sb.append(values[i2]);
                        }
                        sb.append(") ");
                    }
                    catch (InstantiationException ie) {
                        sb.append("CDATA ");
                    }
                    catch (IllegalAccessException ie) {
                        sb.append("CDATA ");
                    }
                } else {
                    sb.append("CDATA ");
                }
            }
            sb.append("#IMPLIED");
        }
        sb.append(">").append(this.lSep);
        out.println(sb);
        count = v.size();
        for (i = 0; i < count; ++i) {
            String nestedName = (String)v.elementAt(i);
            if ("#PCDATA".equals(nestedName) || "%tasks;".equals(nestedName) || "%types;".equals(nestedName)) continue;
            this.printElementDecl(out, nestedName, ih.getElementType(nestedName));
        }
    }

    private void printTail(PrintWriter out) {
    }

    protected boolean isNmtoken(String s) {
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '.' || c == '-' || c == '_' || c == ':') continue;
            return false;
        }
        return true;
    }

    protected boolean areNmtokens(String[] s) {
        for (int i = 0; i < s.length; ++i) {
            if (this.isNmtoken(s[i])) continue;
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

