/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import com.google.common.util.concurrent.AbstractFuture;
import java.net.InetAddress;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.net.IAsyncCallbackWithFailure;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.messages.SnapshotMessage;

public class SnapshotTask
extends AbstractFuture<InetAddress>
implements RunnableFuture<InetAddress> {
    private final RepairJobDesc desc;
    private final InetAddress endpoint;

    public SnapshotTask(RepairJobDesc desc, InetAddress endpoint) {
        this.desc = desc;
        this.endpoint = endpoint;
    }

    @Override
    public void run() {
        MessagingService.instance().sendRR(new SnapshotMessage(this.desc).createMessage(), this.endpoint, new SnapshotCallback(this), TimeUnit.HOURS.toMillis(1L), true);
    }

    static class SnapshotCallback
    implements IAsyncCallbackWithFailure {
        final SnapshotTask task;

        SnapshotCallback(SnapshotTask task) {
            this.task = task;
        }

        @Override
        public void response(MessageIn msg) {
            this.task.set(this.task.endpoint);
        }

        @Override
        public boolean isLatencyForSnitch() {
            return false;
        }

        @Override
        public void onFailure(InetAddress from) {
            this.task.setException(new RuntimeException("Could not create snapshot at " + from));
        }
    }
}

