/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress;

import java.util.concurrent.atomic.AtomicLong;

interface WorkManager {
    public int takePermits(int var1);

    public void stop();

    public static final class ContinuousWorkManager
    implements WorkManager {
        volatile boolean stop = false;

        @Override
        public int takePermits(int count) {
            if (this.stop) {
                return -1;
            }
            return count;
        }

        @Override
        public void stop() {
            this.stop = true;
        }
    }

    public static final class FixedWorkManager
    implements WorkManager {
        final AtomicLong permits;

        public FixedWorkManager(long permits) {
            this.permits = new AtomicLong(permits);
        }

        @Override
        public int takePermits(int count) {
            long next;
            long cur;
            do {
                if ((cur = this.permits.get()) != 0L) continue;
                return -1;
            } while (!this.permits.compareAndSet(cur, next = cur - (long)(count = (int)Math.min((long)count, cur))));
            return count;
        }

        @Override
        public void stop() {
            this.permits.getAndSet(0L);
        }
    }
}

