/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.functions.NativeScalarFunction;
import org.apache.cassandra.cql3.functions.TimeFcts;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.BooleanType;
import org.apache.cassandra.db.marshal.ByteType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.DecimalType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.FloatType;
import org.apache.cassandra.db.marshal.InetAddressType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.IntegerType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.ShortType;
import org.apache.cassandra.db.marshal.SimpleDateType;
import org.apache.cassandra.db.marshal.TimeType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.TimestampType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UUIDType;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.commons.lang3.text.WordUtils;

public final class CastFcts {
    private static final String FUNCTION_NAME_PREFIX = "castAs";

    public static Collection<Function> all() {
        AbstractType[] numericTypes;
        ArrayList<Function> functions = new ArrayList<Function>();
        for (AbstractType inputType : numericTypes = new AbstractType[]{ByteType.instance, ShortType.instance, Int32Type.instance, LongType.instance, FloatType.instance, DoubleType.instance, DecimalType.instance, CounterColumnType.instance, IntegerType.instance}) {
            CastFcts.addFunctionIfNeeded(functions, inputType, ByteType.instance, Number::byteValue);
            CastFcts.addFunctionIfNeeded(functions, inputType, ShortType.instance, Number::shortValue);
            CastFcts.addFunctionIfNeeded(functions, inputType, Int32Type.instance, Number::intValue);
            CastFcts.addFunctionIfNeeded(functions, inputType, LongType.instance, Number::longValue);
            CastFcts.addFunctionIfNeeded(functions, inputType, FloatType.instance, Number::floatValue);
            CastFcts.addFunctionIfNeeded(functions, inputType, DoubleType.instance, Number::doubleValue);
            CastFcts.addFunctionIfNeeded(functions, inputType, DecimalType.instance, p -> BigDecimal.valueOf(p.doubleValue()));
            CastFcts.addFunctionIfNeeded(functions, inputType, IntegerType.instance, p -> BigInteger.valueOf(p.longValue()));
            functions.add(CastAsTextFunction.create(inputType, AsciiType.instance));
            functions.add(CastAsTextFunction.create(inputType, UTF8Type.instance));
        }
        functions.add(JavaFunctionWrapper.create(AsciiType.instance, UTF8Type.instance, p -> p));
        functions.add(CastAsTextFunction.create(InetAddressType.instance, AsciiType.instance));
        functions.add(CastAsTextFunction.create(InetAddressType.instance, UTF8Type.instance));
        functions.add(CastAsTextFunction.create(BooleanType.instance, AsciiType.instance));
        functions.add(CastAsTextFunction.create(BooleanType.instance, UTF8Type.instance));
        functions.add(CassandraFunctionWrapper.create(TimeUUIDType.instance, SimpleDateType.instance, TimeFcts.timeUuidtoDate));
        functions.add(CassandraFunctionWrapper.create(TimeUUIDType.instance, TimestampType.instance, TimeFcts.timeUuidToTimestamp));
        functions.add(CastAsTextFunction.create(TimeUUIDType.instance, AsciiType.instance));
        functions.add(CastAsTextFunction.create(TimeUUIDType.instance, UTF8Type.instance));
        functions.add(CassandraFunctionWrapper.create(TimestampType.instance, SimpleDateType.instance, TimeFcts.timestampToDate));
        functions.add(CastAsTextFunction.create(TimestampType.instance, AsciiType.instance));
        functions.add(CastAsTextFunction.create(TimestampType.instance, UTF8Type.instance));
        functions.add(CassandraFunctionWrapper.create(SimpleDateType.instance, TimestampType.instance, TimeFcts.dateToTimestamp));
        functions.add(CastAsTextFunction.create(SimpleDateType.instance, AsciiType.instance));
        functions.add(CastAsTextFunction.create(SimpleDateType.instance, UTF8Type.instance));
        functions.add(CastAsTextFunction.create(TimeType.instance, AsciiType.instance));
        functions.add(CastAsTextFunction.create(TimeType.instance, UTF8Type.instance));
        functions.add(CastAsTextFunction.create(UUIDType.instance, AsciiType.instance));
        functions.add(CastAsTextFunction.create(UUIDType.instance, UTF8Type.instance));
        return functions;
    }

    public static String getFunctionName(AbstractType<?> outputType) {
        return CastFcts.getFunctionName(outputType.asCQL3Type());
    }

    public static String getFunctionName(CQL3Type outputType) {
        return FUNCTION_NAME_PREFIX + WordUtils.capitalize((String)CastFcts.toLowerCaseString(outputType));
    }

    private static <I, O> void addFunctionIfNeeded(List<Function> functions, AbstractType<I> inputType, AbstractType<O> outputType, java.util.function.Function<I, O> converter) {
        if (!inputType.equals(outputType)) {
            functions.add(CastFcts.wrapJavaFunction(inputType, outputType, converter));
        }
    }

    private static <O, I> Function wrapJavaFunction(AbstractType<I> inputType, AbstractType<O> outputType, java.util.function.Function<I, O> converter) {
        return inputType.equals(CounterColumnType.instance) ? JavaCounterFunctionWrapper.create(outputType, converter) : JavaFunctionWrapper.create(inputType, outputType, converter);
    }

    private static String toLowerCaseString(CQL3Type type) {
        return type.toString().toLowerCase();
    }

    private CastFcts() {
    }

    private static final class CastAsTextFunction<I>
    extends CastFunction<I, String> {
        public static <I> CastAsTextFunction<I> create(AbstractType<I> inputType, AbstractType<String> outputType) {
            return new CastAsTextFunction<I>(inputType, outputType);
        }

        private CastAsTextFunction(AbstractType<I> inputType, AbstractType<String> outputType) {
            super(inputType, outputType);
        }

        @Override
        public ByteBuffer execute(ProtocolVersion protocolVersion, List<ByteBuffer> parameters) {
            ByteBuffer bb = parameters.get(0);
            if (bb == null) {
                return null;
            }
            return this.outputType().decompose(this.inputType().getSerializer().toCQLLiteral(bb));
        }
    }

    private static final class CassandraFunctionWrapper<I, O>
    extends CastFunction<I, O> {
        private final NativeScalarFunction delegate;

        public static <I, O> CassandraFunctionWrapper<I, O> create(AbstractType<I> inputType, AbstractType<O> outputType, NativeScalarFunction delegate) {
            return new CassandraFunctionWrapper<I, O>(inputType, outputType, delegate);
        }

        private CassandraFunctionWrapper(AbstractType<I> inputType, AbstractType<O> outputType, NativeScalarFunction delegate) {
            super(inputType, outputType);
            assert (delegate.argTypes().size() == 1 && inputType.equals(delegate.argTypes().get(0)));
            assert (outputType.equals(delegate.returnType()));
            this.delegate = delegate;
        }

        @Override
        public ByteBuffer execute(ProtocolVersion protocolVersion, List<ByteBuffer> parameters) {
            return this.delegate.execute(protocolVersion, parameters);
        }
    }

    private static class JavaCounterFunctionWrapper<O>
    extends JavaFunctionWrapper<Long, O> {
        public static <O> JavaFunctionWrapper<Long, O> create(AbstractType<O> outputType, java.util.function.Function<Long, O> converter) {
            return new JavaCounterFunctionWrapper<O>(outputType, converter);
        }

        protected JavaCounterFunctionWrapper(AbstractType<O> outputType, java.util.function.Function<Long, O> converter) {
            super(CounterColumnType.instance, outputType, converter);
        }

        @Override
        protected Long compose(ByteBuffer bb) {
            return (Long)LongType.instance.compose(bb);
        }
    }

    private static class JavaFunctionWrapper<I, O>
    extends CastFunction<I, O> {
        private final java.util.function.Function<I, O> converter;

        public static <I, O> JavaFunctionWrapper<I, O> create(AbstractType<I> inputType, AbstractType<O> outputType, java.util.function.Function<I, O> converter) {
            return new JavaFunctionWrapper<I, O>(inputType, outputType, converter);
        }

        protected JavaFunctionWrapper(AbstractType<I> inputType, AbstractType<O> outputType, java.util.function.Function<I, O> converter) {
            super(inputType, outputType);
            this.converter = converter;
        }

        @Override
        public final ByteBuffer execute(ProtocolVersion protocolVersion, List<ByteBuffer> parameters) {
            ByteBuffer bb = parameters.get(0);
            if (bb == null) {
                return null;
            }
            return this.outputType().decompose(this.converter.apply(this.compose(bb)));
        }

        protected I compose(ByteBuffer bb) {
            return this.inputType().compose(bb);
        }
    }

    private static abstract class CastFunction<I, O>
    extends NativeScalarFunction {
        public CastFunction(AbstractType<I> inputType, AbstractType<O> outputType) {
            super(CastFcts.getFunctionName(outputType), outputType, inputType);
        }

        @Override
        public String columnName(List<String> columnNames) {
            return String.format("cast(%s as %s)", columnNames.get(0), CastFcts.toLowerCaseString(this.outputType().asCQL3Type()));
        }

        protected AbstractType<O> outputType() {
            return this.returnType;
        }

        protected AbstractType<I> inputType() {
            return (AbstractType)this.argTypes.get(0);
        }
    }
}

