/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import org.apache.solr.analytics.ExpressionFactory;
import org.apache.solr.analytics.function.mapping.BooleanFilterFunction;
import org.apache.solr.analytics.function.mapping.BooleanStreamFilterFunction;
import org.apache.solr.analytics.function.mapping.DateFilterFunction;
import org.apache.solr.analytics.function.mapping.DateStreamFilterFunction;
import org.apache.solr.analytics.function.mapping.DoubleFilterFunction;
import org.apache.solr.analytics.function.mapping.DoubleStreamFilterFunction;
import org.apache.solr.analytics.function.mapping.FloatFilterFunction;
import org.apache.solr.analytics.function.mapping.FloatStreamFilterFunction;
import org.apache.solr.analytics.function.mapping.IntFilterFunction;
import org.apache.solr.analytics.function.mapping.IntStreamFilterFunction;
import org.apache.solr.analytics.function.mapping.LongFilterFunction;
import org.apache.solr.analytics.function.mapping.LongStreamFilterFunction;
import org.apache.solr.analytics.function.mapping.StreamFilterFunction;
import org.apache.solr.analytics.function.mapping.StringFilterFunction;
import org.apache.solr.analytics.function.mapping.StringStreamFilterFunction;
import org.apache.solr.analytics.function.mapping.ValueFilterFunction;
import org.apache.solr.analytics.value.AnalyticsValue;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.BooleanValue;
import org.apache.solr.analytics.value.BooleanValueStream;
import org.apache.solr.analytics.value.DateValue;
import org.apache.solr.analytics.value.DateValueStream;
import org.apache.solr.analytics.value.DoubleValue;
import org.apache.solr.analytics.value.DoubleValueStream;
import org.apache.solr.analytics.value.FloatValue;
import org.apache.solr.analytics.value.FloatValueStream;
import org.apache.solr.analytics.value.IntValue;
import org.apache.solr.analytics.value.IntValueStream;
import org.apache.solr.analytics.value.LongValue;
import org.apache.solr.analytics.value.LongValueStream;
import org.apache.solr.analytics.value.StringValue;
import org.apache.solr.analytics.value.StringValueStream;
import org.apache.solr.common.SolrException;

public class FilterFunction {
    public static final String name = "filter";
    public static final ExpressionFactory.CreatorFunction creatorFunction = params -> {
        if (params.length != 2) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The filter function requires 2 paramaters, " + params.length + " found.");
        }
        if (!(params[1] instanceof BooleanValue)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The filter function requires the second paramater to be single-valued and boolean.");
        }
        AnalyticsValueStream baseExpr = params[0];
        BooleanValue filterExpr = (BooleanValue)params[1];
        if (baseExpr instanceof DateValue) {
            return new DateFilterFunction((DateValue)baseExpr, filterExpr);
        }
        if (baseExpr instanceof DateValueStream) {
            return new DateStreamFilterFunction((DateValueStream)baseExpr, filterExpr);
        }
        if (baseExpr instanceof BooleanValue) {
            return new BooleanFilterFunction((BooleanValue)baseExpr, filterExpr);
        }
        if (baseExpr instanceof BooleanValueStream) {
            return new BooleanStreamFilterFunction((BooleanValueStream)baseExpr, filterExpr);
        }
        if (baseExpr instanceof IntValue) {
            return new IntFilterFunction((IntValue)baseExpr, filterExpr);
        }
        if (baseExpr instanceof IntValueStream) {
            return new IntStreamFilterFunction((IntValueStream)baseExpr, filterExpr);
        }
        if (baseExpr instanceof LongValue) {
            return new LongFilterFunction((LongValue)baseExpr, filterExpr);
        }
        if (baseExpr instanceof LongValueStream) {
            return new LongStreamFilterFunction((LongValueStream)baseExpr, filterExpr);
        }
        if (baseExpr instanceof FloatValue) {
            return new FloatFilterFunction((FloatValue)baseExpr, filterExpr);
        }
        if (baseExpr instanceof FloatValueStream) {
            return new FloatStreamFilterFunction((FloatValueStream)baseExpr, filterExpr);
        }
        if (baseExpr instanceof DoubleValue) {
            return new DoubleFilterFunction((DoubleValue)baseExpr, filterExpr);
        }
        if (baseExpr instanceof DoubleValueStream) {
            return new DoubleStreamFilterFunction((DoubleValueStream)baseExpr, filterExpr);
        }
        if (baseExpr instanceof StringValue) {
            return new StringFilterFunction((StringValue)baseExpr, filterExpr);
        }
        if (baseExpr instanceof StringValueStream) {
            return new StringStreamFilterFunction((StringValueStream)baseExpr, filterExpr);
        }
        if (baseExpr instanceof AnalyticsValue) {
            return new ValueFilterFunction((AnalyticsValue)baseExpr, filterExpr);
        }
        return new StreamFilterFunction(baseExpr, filterExpr);
    };
}

