/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.openwire.codec.v8;

import java.io.IOException;
import org.apache.activemq.apollo.openwire.codec.BooleanStream;
import org.apache.activemq.apollo.openwire.codec.OpenWireFormat;
import org.apache.activemq.apollo.openwire.codec.v8.ActiveMQMessageMarshaller;
import org.apache.activemq.apollo.openwire.command.ActiveMQBlobMessage;
import org.apache.activemq.apollo.openwire.command.DataStructure;
import org.fusesource.hawtbuf.DataByteArrayInputStream;
import org.fusesource.hawtbuf.DataByteArrayOutputStream;

public class ActiveMQBlobMessageMarshaller
extends ActiveMQMessageMarshaller {
    public byte getDataStructureType() {
        return 29;
    }

    public DataStructure createObject() {
        return new ActiveMQBlobMessage();
    }

    public void tightUnmarshal(OpenWireFormat wireFormat, Object o, DataByteArrayInputStream dataIn, BooleanStream bs) throws IOException {
        super.tightUnmarshal(wireFormat, o, dataIn, bs);
        ActiveMQBlobMessage info = (ActiveMQBlobMessage)o;
        info.setRemoteBlobUrl(this.tightUnmarshalString(dataIn, bs));
        info.setMimeType(this.tightUnmarshalString(dataIn, bs));
        info.setDeletedByBroker(bs.readBoolean());
    }

    public int tightMarshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        ActiveMQBlobMessage info = (ActiveMQBlobMessage)o;
        int rc = super.tightMarshal1(wireFormat, o, bs);
        rc += this.tightMarshalString1(info.getRemoteBlobUrl(), bs);
        bs.writeBoolean(info.isDeletedByBroker());
        return (rc += this.tightMarshalString1(info.getMimeType(), bs)) + 0;
    }

    public void tightMarshal2(OpenWireFormat wireFormat, Object o, DataByteArrayOutputStream dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(wireFormat, o, dataOut, bs);
        ActiveMQBlobMessage info = (ActiveMQBlobMessage)o;
        this.tightMarshalString2(info.getRemoteBlobUrl(), dataOut, bs);
        this.tightMarshalString2(info.getMimeType(), dataOut, bs);
        bs.readBoolean();
    }

    public void looseUnmarshal(OpenWireFormat wireFormat, Object o, DataByteArrayInputStream dataIn) throws IOException {
        super.looseUnmarshal(wireFormat, o, dataIn);
        ActiveMQBlobMessage info = (ActiveMQBlobMessage)o;
        info.setRemoteBlobUrl(this.looseUnmarshalString(dataIn));
        info.setMimeType(this.looseUnmarshalString(dataIn));
        info.setDeletedByBroker(dataIn.readBoolean());
    }

    public void looseMarshal(OpenWireFormat wireFormat, Object o, DataByteArrayOutputStream dataOut) throws IOException {
        ActiveMQBlobMessage info = (ActiveMQBlobMessage)o;
        super.looseMarshal(wireFormat, o, dataOut);
        this.looseMarshalString(info.getRemoteBlobUrl(), dataOut);
        this.looseMarshalString(info.getMimeType(), dataOut);
        dataOut.writeBoolean(info.isDeletedByBroker());
    }
}

