/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.broker;

import java.io.IOException;
import java.net.SocketAddress;
import org.apache.activemq.apollo.broker.Connection;
import org.apache.activemq.apollo.broker.Connector;
import org.apache.activemq.apollo.broker.protocol.ProtocolHandler;
import org.apache.activemq.apollo.dto.ConnectionStatusDTO;
import org.fusesource.hawtdispatch.Task;
import org.fusesource.hawtdispatch.transport.ProtocolCodec;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005ua\u0001B\u0001\u0003\u00015\u0011\u0001C\u0011:pW\u0016\u00148i\u001c8oK\u000e$\u0018n\u001c8\u000b\u0005\r!\u0011A\u00022s_.,'O\u0003\u0002\u0006\r\u00051\u0011\r]8mY>T!a\u0002\u0005\u0002\u0011\u0005\u001cG/\u001b<f[FT!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011c\u0001\u0001\u000f%A\u0011q\u0002E\u0007\u0002\u0005%\u0011\u0011C\u0001\u0002\u000b\u0007>tg.Z2uS>t\u0007CA\n\u0017\u001b\u0005!\"\"A\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]!\"aC*dC2\fwJ\u00196fGRD\u0001\"\u0007\u0001\u0003\u0002\u0004%\tAG\u0001\nG>tg.Z2u_J,\u0012a\u0007\t\u0003\u001fqI!!\b\u0002\u0003\u0013\r{gN\\3di>\u0014\b\u0002C\u0010\u0001\u0005\u0003\u0007I\u0011\u0001\u0011\u0002\u001b\r|gN\\3di>\u0014x\fJ3r)\t\tC\u0005\u0005\u0002\u0014E%\u00111\u0005\u0006\u0002\u0005+:LG\u000fC\u0004&=\u0005\u0005\t\u0019A\u000e\u0002\u0007a$\u0013\u0007\u0003\u0005(\u0001\t\u0005\t\u0015)\u0003\u001c\u0003)\u0019wN\u001c8fGR|'\u000f\t\u0005\tS\u0001\u0011)\u0019!C\u0001U\u0005\u0011\u0011\u000eZ\u000b\u0002WA\u00111\u0003L\u0005\u0003[Q\u0011A\u0001T8oO\"Aq\u0006\u0001B\u0001B\u0003%1&A\u0002jI\u0002BQ!\r\u0001\u0005\u0002I\na\u0001P5oSRtDcA\u001a5kA\u0011q\u0002\u0001\u0005\u00063A\u0002\ra\u0007\u0005\u0006SA\u0002\ra\u000b\u0005\bo\u0001\u0001\r\u0011\"\u00019\u0003A\u0001(o\u001c;pG>dw\f[1oI2,'/F\u0001:!\tQT(D\u0001<\u0015\ta$!\u0001\u0005qe>$xnY8m\u0013\tq4HA\bQe>$xnY8m\u0011\u0006tG\r\\3s\u0011\u001d\u0001\u0005\u00011A\u0005\u0002\u0005\u000bA\u0003\u001d:pi>\u001cw\u000e\\0iC:$G.\u001a:`I\u0015\fHCA\u0011C\u0011\u001d)s(!AA\u0002eBa\u0001\u0012\u0001!B\u0013I\u0014!\u00059s_R|7m\u001c7`Q\u0006tG\r\\3sA!)a\t\u0001C\u0001\u000f\u0006Q1/Z:tS>tw,\u001b3\u0016\u0003!\u00032aE%L\u0013\tQEC\u0001\u0004PaRLwN\u001c\t\u0003\u0019>s!aE'\n\u00059#\u0012A\u0002)sK\u0012,g-\u0003\u0002Q#\n11\u000b\u001e:j]\u001eT!A\u0014\u000b\t\u000bM\u0003A\u0011\t+\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012!\u0016\t\u0003-nk\u0011a\u0016\u0006\u00031f\u000bA\u0001\\1oO*\t!,\u0001\u0003kCZ\f\u0017B\u0001)X\u0011\u0015i\u0006\u0001\"\u0015_\u0003\u0019y6\u000f^1siR\u0011\u0011e\u0018\u0005\u0006Ar\u0003\r!Y\u0001\r_:|6m\\7qY\u0016$X\r\u001a\t\u0003E\u001el\u0011a\u0019\u0006\u0003I\u0016\fA\u0002[1xi\u0012L7\u000f]1uG\"T!A\u001a\u0006\u0002\u0015\u0019,8/Z:pkJ\u001cW-\u0003\u0002iG\n!A+Y:l\u0011\u0015Q\u0007\u0001\"\u0015l\u0003\u0015y6\u000f^8q)\t\tC\u000eC\u0003aS\u0002\u0007\u0011\rC\u0003o\u0001\u0011Es.\u0001\fp]~#(/\u00198ta>\u0014HoX2p]:,7\r^3e)\u0005\t\u0003\"B9\u0001\t#z\u0017!G8o?R\u0014\u0018M\\:q_J$x\fZ5tG>tg.Z2uK\u0012DQa\u001d\u0001\u0005RQ\fAc\u001c8`iJ\fgn\u001d9peR|6m\\7nC:$GCA\u0011v\u0011\u00151(\u000f1\u0001x\u0003\u001d\u0019w.\\7b]\u0012\u0004\"A\u0016=\n\u0005e<&AB(cU\u0016\u001cG\u000fC\u0003|\u0001\u0011EC0\u0001\u000bp]~#(/\u00198ta>\u0014Ho\u00184bS2,(/\u001a\u000b\u0003CuDQA >A\u0002}\fQ!\u001a:s_J\u0004B!!\u0001\u0002\b5\u0011\u00111\u0001\u0006\u0004\u0003\u000bI\u0016AA5p\u0013\u0011\tI!a\u0001\u0003\u0017%{U\t_2faRLwN\u001c\u0005\b\u0003\u001b\u0001A\u0011AA\b\u0003U9W\r^0d_:tWm\u0019;j_:|6\u000f^1ukN,\"!!\u0005\u0011\t\u0005M\u0011\u0011D\u0007\u0003\u0003+Q1!a\u0006\u0005\u0003\r!Go\\\u0005\u0005\u00037\t)BA\nD_:tWm\u0019;j_:\u001cF/\u0019;vg\u0012#v\n")
public class BrokerConnection
extends Connection
implements ScalaObject {
    private Connector connector;
    private final long id;
    private ProtocolHandler protocol_handler;

    public Connector connector() {
        return this.connector;
    }

    public void connector_$eq(Connector connector) {
        this.connector = connector;
    }

    public long id() {
        return this.id;
    }

    public ProtocolHandler protocol_handler() {
        return this.protocol_handler;
    }

    public void protocol_handler_$eq(ProtocolHandler protocolHandler) {
        this.protocol_handler = protocolHandler;
    }

    public Option<String> session_id() {
        return Option$.MODULE$.apply((Object)this.protocol_handler()).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Option<String> apply(ProtocolHandler protocolHandler) {
                return protocolHandler.session_id();
            }
        });
    }

    public String toString() {
        return new StringBuilder().append((Object)"id: ").append((Object)((Object)BoxesRunTime.boxToLong((long)this.id())).toString()).toString();
    }

    @Override
    public void _start(Task on_completed2) {
        this.protocol_handler().set_connection(this);
        super._start(on_completed2);
    }

    @Override
    public void _stop(Task on_completed2) {
        this.connector().stopped(this);
        super._stop(on_completed2);
    }

    @Override
    public void on_transport_connected() {
        this.connector().broker().connection_log().info((Function0)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "connected: local:%s, remote:%s";
            }
        }, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.transport().getLocalAddress(), this.transport().getRemoteAddress()}));
        this.protocol_handler().on_transport_connected();
    }

    @Override
    public void on_transport_disconnected() {
        this.connector().broker().connection_log().info((Function0)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "disconnected: local:%s, remote:%s";
            }
        }, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.transport().getLocalAddress(), this.transport().getRemoteAddress()}));
        this.protocol_handler().on_transport_disconnected();
    }

    @Override
    public void on_transport_command(Object command) {
        try {
            this.protocol_handler().on_transport_command(command);
        }
        catch (Exception exception) {
            this.on_failure(exception);
        }
    }

    @Override
    public void on_transport_failure(IOException error) {
        this.protocol_handler().on_transport_failure(error);
    }

    /*
     * WARNING - void declaration
     */
    public ConnectionStatusDTO get_connection_status() {
        void var1_1;
        ConnectionStatusDTO result = this.protocol_handler() == null ? new ConnectionStatusDTO() : this.protocol_handler().create_connection_status();
        result.id = ((Object)BoxesRunTime.boxToLong((long)this.id())).toString();
        result.state = this.service_state().toString();
        result.state_since = this.service_state().since();
        result.protocol = this.protocol_handler().protocol();
        result.connector = this.connector().id();
        result.remote_address = (String)Option$.MODULE$.apply((Object)this.transport().getRemoteAddress()).map((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(SocketAddress socketAddress) {
                return socketAddress.toString();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Null$ apply() {
                return null;
            }
        });
        result.local_address = (String)Option$.MODULE$.apply((Object)this.transport().getLocalAddress()).map((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(SocketAddress socketAddress) {
                return socketAddress.toString();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Null$ apply() {
                return null;
            }
        });
        result.protocol_session_id = (String)this.protocol_handler().session_id().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Null$ apply() {
                return null;
            }
        });
        ProtocolCodec wf = this.transport().getProtocolCodec();
        if (wf != null) {
            result.write_counter = wf.getWriteCounter();
            result.read_counter = wf.getReadCounter();
            result.last_read_size = wf.getLastReadSize();
            result.last_write_size = wf.getLastWriteSize();
        }
        return var1_1;
    }

    public BrokerConnection(Connector connector, long id) {
        this.connector = connector;
        this.id = id;
        this.protocol_handler = null;
    }
}

