/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.connectivity;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import org.diylc.common.PCBLayer;
import org.diylc.components.AbstractComponent;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.BomPolicy;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.utils.Constants;

@ComponentDescriptor(name="Solder Pad", category="Connectivity", author="Branislav Stojkovic", description="Copper solder pad, round or square", instanceNamePrefix="Pad", stretchable=false, zOrder=3.1, bomPolicy=BomPolicy.NEVER_SHOW, autoEdit=false)
public class SolderPad
extends AbstractComponent<Void> {
    private static final long serialVersionUID = 1L;
    public static Size SIZE = new Size(Double.valueOf(0.09), SizeUnit.in);
    public static Size HOLE_SIZE = new Size(Double.valueOf(0.8), SizeUnit.mm);
    public static Color COLOR = Color.black;
    private Size size = SIZE;
    private Color color = COLOR;
    private Point point = new Point(0, 0);
    private Type type = Type.ROUND;
    private Size holeSize = HOLE_SIZE;
    private PCBLayer layer = PCBLayer._1;

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        if (this.checkPointsClipped(g2d.getClip())) {
            return;
        }
        int diameter = this.getClosestOdd((int)this.getSize().convertToPixels());
        int holeDiameter = this.getClosestOdd((int)this.getHoleSize().convertToPixels());
        g2d.setColor(componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : this.color);
        if (this.type == Type.ROUND) {
            g2d.fillOval(this.point.x - diameter / 2, this.point.y - diameter / 2, diameter, diameter);
        } else {
            g2d.fillRect(this.point.x - diameter / 2, this.point.y - diameter / 2, diameter, diameter);
        }
        if (this.getHoleSize().getValue() > 0.0) {
            g2d.setColor(Constants.CANVAS_COLOR);
            g2d.fillOval(this.point.x - holeDiameter / 2, this.point.y - holeDiameter / 2, holeDiameter, holeDiameter);
        }
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        int diameter = this.getClosestOdd(width / 2);
        int holeDiameter = 5;
        g2d.setColor(COLOR);
        g2d.fillOval((width - diameter) / 2, (height - diameter) / 2, diameter, diameter);
        g2d.setColor(Constants.CANVAS_COLOR);
        g2d.fillOval((width - holeDiameter) / 2, (height - holeDiameter) / 2, holeDiameter, holeDiameter);
    }

    @EditableProperty
    public Size getSize() {
        return this.size;
    }

    public void setSize(Size size) {
        this.size = size;
    }

    @EditableProperty(name="Hole")
    public Size getHoleSize() {
        if (this.holeSize == null) {
            this.holeSize = HOLE_SIZE;
        }
        return this.holeSize;
    }

    public void setHoleSize(Size holeSize) {
        this.holeSize = holeSize;
    }

    @EditableProperty
    public PCBLayer getLayer() {
        if (this.layer == null) {
            this.layer = PCBLayer._1;
        }
        return this.layer;
    }

    public void setLayer(PCBLayer layer) {
        this.layer = layer;
    }

    public String getName() {
        return super.getName();
    }

    public int getControlPointCount() {
        return 1;
    }

    public boolean isControlPointSticky(int index) {
        return true;
    }

    public VisibilityPolicy getControlPointVisibilityPolicy(int index) {
        return VisibilityPolicy.NEVER;
    }

    public Point getControlPoint(int index) {
        return this.point;
    }

    public void setControlPoint(Point point, int index) {
        this.point.setLocation(point);
    }

    @EditableProperty(name="Color")
    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    @EditableProperty
    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Void getValue() {
        return null;
    }

    public void setValue(Void value) {
    }

    static enum Type {
        ROUND,
        SQUARE;


        public String toString() {
            return this.name().substring(0, 1) + this.name().substring(1).toLowerCase();
        }
    }
}

