/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function;

import java.util.List;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.ExpressionId;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.NamedExpression;
import org.elasticsearch.xpack.sql.expression.Nullability;
import org.elasticsearch.xpack.sql.tree.Source;
import org.elasticsearch.xpack.sql.util.StringUtils;

public abstract class Function
extends NamedExpression {
    private final String functionName = StringUtils.camelCaseToUnderscore(this.getClass().getSimpleName());
    private final String name;

    protected Function(Source source, List<Expression> children) {
        this(source, children, null, false);
    }

    protected Function(Source source, List<Expression> children, ExpressionId id, boolean synthetic) {
        super(source, null, children, id, synthetic);
        this.name = source.text();
    }

    public final List<Expression> arguments() {
        return this.children();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Nullability nullable() {
        return Expressions.nullable(this.children());
    }

    public String functionName() {
        return this.functionName;
    }

    public String functionId() {
        return this.id().toString();
    }

    public boolean functionEquals(Function f) {
        return f != null && this.getClass() == f.getClass() && this.arguments().equals(f.arguments());
    }
}

