.TH CLR2GRAY 1 25-Jun-90
.CM 3
.SH NAME
clr2gray \- Convert color images to grayscale
.SH SYNOPSIS
.nf
clr2gray [ -r<red> -g<grn> -b<blu> ] [ -<type> ] < color > gray
.fi
.SH DESCRIPTION
.PP
Converts a color image (8bit or 24bit) to an 8 bit grayscale image.
It works for both mapped and unmapped color inputs.
.SH OPTIONS
.TP
.BR -r<num>, -g<num>, -b<num>
.I weights,
used to convert the triple <red,green,blue> to a scalar intensity
value.  If one or more weights are specified, those not specified
default to zero.   If no weights are specified, NTSC weights (29.9%
red, 58.7% green, 11.4% blue) are used.
.TP
.BR -B
.I face
format, as used by Bennet Yee's
.I face
program at CMU. 
.TP
.BR -F
.I FBM,
format (by default, the default).  You are guaranteed not
to lose information by specifying FBM as the default.
.TP
.BR -G
.I GIF,
Compuserve GIF format.
.TP
.BR -I
.I IFF
format, interleaved bitmaps (ILBM), used by Amigas.
.TP
.BR -P
.I PBM,
Jef Poskanzer's bitmap format.
.TP
.BR -S
.I sun,
Sun rasterfiles (not run length encoded).
.SH EXAMPLE
.PP
To convert a mapped color image in FBM format to a Sun
format grayscale image:
.sp
	% clr2gray -S < foo.fbm > foo.8bit
.sp
To extract the red color plane from an image and write the result in
FBM format:
.sp
	% clr2gray -r1 -F < foo.fbm > red.fbm
.sp
Note that since the green and blue weights were not specified, they
defaulted to 0, and the result is that only the red plane is used.
.SH SEE ALSO
fbm(1) for general discussion, pbm(1) for PBM routines.
.SH BUGS
None known.
.SH HISTORY
Copyright (C) 1989,1990 by Michael Mauldin.  Permission is granted
to use this file in whole or in part for any purpose, educational,
recreational or commercial, provided that this copyright notice
is retained unchanged.  This software is available to all free of
charge by anonymous FTP and in the UUNET archives.
.TP
25-Jun-90  Michael Mauldin at Carnegie Mellon University
Release 1.0 mlm@cs.cmu.edu
.TP
07-Mar-89  Michael L. Mauldin at Carnegie Mellon University
Beta release (version 0.9) mlm@cs.cmu.edu
