/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.util.Date;
import net.sf.gogui.game.TimeSettings;
import net.sf.gogui.go.GoColor;

public final class Clock {
    private long m_startMoveTime;
    private GoColor m_toMove = GoColor.EMPTY;
    private final TimeRecord m_timeRecordBlack = new TimeRecord();
    private final TimeRecord m_timeRecordWhite = new TimeRecord();
    private TimeSettings m_timeSettings;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Clock() {
        this.reset();
    }

    public int getMovesLeft(GoColor goColor) {
        if (!($assertionsDisabled || this.getUseByoyomi() && this.isInByoyomi(goColor))) {
            throw new AssertionError();
        }
        return this.getRecord((GoColor)goColor).m_movesLeft;
    }

    public long getTimeLeft(GoColor goColor) {
        if (!$assertionsDisabled && !this.isInitialized()) {
            throw new AssertionError();
        }
        TimeRecord timeRecord = this.getRecord(goColor);
        long l = timeRecord.m_time;
        if (this.getUseByoyomi()) {
            return this.getByoyomi() - l;
        }
        return this.getPreByoyomi() - l;
    }

    public String getTimeString(GoColor goColor) {
        TimeRecord timeRecord = this.getRecord(goColor);
        long l = timeRecord.m_time;
        if (this.m_toMove == goColor) {
            l += new Date().getTime() - this.m_startMoveTime;
        }
        if (this.isInitialized()) {
            l = timeRecord.m_isInByoyomi ? this.getByoyomi() - l : this.getPreByoyomi() - l;
        }
        int n = -1;
        if (this.isInitialized() && timeRecord.m_isInByoyomi) {
            n = timeRecord.m_movesLeft;
        }
        return Clock.getTimeString(l /= 1000L, n);
    }

    public static String getTimeString(double d, int n) {
        StringBuffer stringBuffer = new StringBuffer(8);
        long l = (long)d;
        if (l < 0L) {
            stringBuffer.append('-');
            l *= -1L;
        }
        long l2 = l / 3600L;
        long l3 = (l %= 3600L) / 60L;
        long l4 = l %= 60L;
        if (l2 > 0L) {
            if (l2 > 9999L) {
                stringBuffer.append(">9999");
            } else {
                stringBuffer.append(l2);
            }
            stringBuffer.append(':');
        }
        if (l3 >= 10L) {
            stringBuffer.append(l3);
        } else {
            stringBuffer.append('0');
            stringBuffer.append(l3);
        }
        stringBuffer.append(':');
        if (l4 >= 10L) {
            stringBuffer.append(l4);
        } else {
            stringBuffer.append('0');
            stringBuffer.append(l4);
        }
        if (n >= 0) {
            stringBuffer.append('/');
            stringBuffer.append(n);
        }
        return stringBuffer.toString();
    }

    public void halt() {
        if (this.m_toMove == GoColor.EMPTY) {
            return;
        }
        TimeRecord timeRecord = this.getRecord(this.m_toMove);
        long l = new Date().getTime() - this.m_startMoveTime;
        timeRecord.m_time += l;
        this.m_toMove = GoColor.EMPTY;
    }

    public boolean isInitialized() {
        return this.m_timeSettings != null;
    }

    public boolean isInByoyomi(GoColor goColor) {
        return this.getUseByoyomi() && this.getRecord((GoColor)goColor).m_isInByoyomi;
    }

    public boolean isRunning() {
        return this.m_toMove != GoColor.EMPTY;
    }

    public boolean lostOnTime(GoColor goColor) {
        if (!this.isInitialized()) {
            return false;
        }
        TimeRecord timeRecord = this.getRecord(goColor);
        long l = timeRecord.m_time;
        if (this.getUseByoyomi()) {
            return timeRecord.m_byoyomiExceeded;
        }
        return l > this.getPreByoyomi();
    }

    public void reset() {
        this.reset(GoColor.BLACK);
        this.reset(GoColor.WHITE);
        this.m_toMove = GoColor.EMPTY;
    }

    public void reset(GoColor goColor) {
        TimeRecord timeRecord = this.getRecord(goColor);
        timeRecord.m_time = 0L;
        timeRecord.m_movesLeft = 0;
        timeRecord.m_isInByoyomi = false;
        timeRecord.m_byoyomiExceeded = false;
    }

    public void setTimeSettings(TimeSettings timeSettings) {
        this.m_timeSettings = timeSettings;
    }

    public void setTimeLeft(GoColor goColor, long l, int n) {
        this.halt();
        TimeRecord timeRecord = this.getRecord(goColor);
        boolean bl = timeRecord.m_isInByoyomi = n >= 0;
        if (timeRecord.m_isInByoyomi) {
            timeRecord.m_time = this.getByoyomi() - l;
            timeRecord.m_movesLeft = n;
            timeRecord.m_byoyomiExceeded = l > 0L;
        } else {
            timeRecord.m_time = this.getPreByoyomi() - l;
            timeRecord.m_movesLeft = -1;
            timeRecord.m_byoyomiExceeded = false;
        }
        if (this.m_toMove != GoColor.EMPTY) {
            this.startMove(this.m_toMove);
        }
    }

    public void startMove(GoColor goColor) {
        if (this.m_toMove != GoColor.EMPTY) {
            this.stopMove();
        }
        this.m_toMove = goColor;
        this.m_startMoveTime = new Date().getTime();
    }

    public void stopMove() {
        if (this.m_toMove == GoColor.EMPTY) {
            return;
        }
        TimeRecord timeRecord = this.getRecord(this.m_toMove);
        long l = new Date().getTime() - this.m_startMoveTime;
        timeRecord.m_time += l;
        if (this.isInitialized() && this.getUseByoyomi()) {
            if (!timeRecord.m_isInByoyomi && timeRecord.m_time > this.getPreByoyomi()) {
                timeRecord.m_isInByoyomi = true;
                timeRecord.m_time -= this.getPreByoyomi();
                if (!$assertionsDisabled && this.getByoyomiMoves() <= 0) {
                    throw new AssertionError();
                }
                timeRecord.m_movesLeft = this.getByoyomiMoves();
            }
            if (timeRecord.m_isInByoyomi) {
                if (timeRecord.m_time > this.getByoyomi()) {
                    timeRecord.m_byoyomiExceeded = true;
                }
                if (!$assertionsDisabled && timeRecord.m_movesLeft <= 0) {
                    throw new AssertionError();
                }
                --timeRecord.m_movesLeft;
                if (timeRecord.m_movesLeft == 0) {
                    timeRecord.m_time = 0L;
                    if (!$assertionsDisabled && this.getByoyomiMoves() <= 0) {
                        throw new AssertionError();
                    }
                    timeRecord.m_movesLeft = this.getByoyomiMoves();
                }
            }
        }
        this.m_toMove = GoColor.EMPTY;
    }

    private TimeRecord getRecord(GoColor goColor) {
        if (goColor == GoColor.BLACK) {
            return this.m_timeRecordBlack;
        }
        return this.m_timeRecordWhite;
    }

    private long getByoyomi() {
        return this.m_timeSettings.getByoyomi();
    }

    private int getByoyomiMoves() {
        return this.m_timeSettings.getByoyomiMoves();
    }

    private long getPreByoyomi() {
        return this.m_timeSettings.getPreByoyomi();
    }

    private boolean getUseByoyomi() {
        return this.m_timeSettings.getUseByoyomi();
    }

    static {
        $assertionsDisabled = !Clock.class.desiredAssertionStatus();
    }

    private static class TimeRecord {
        public boolean m_isInByoyomi;
        public boolean m_byoyomiExceeded;
        public int m_movesLeft;
        public long m_time;

        private TimeRecord() {
        }
    }
}

