/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.Color;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Style;
import net.sf.gogui.gui.Clock;
import net.sf.gogui.gui.GuiTextPane;
import net.sf.gogui.gui.GuiUtils;

class GtpShellText
extends GuiTextPane {
    private boolean m_timeStamp;
    private final int m_historyMin;
    private final int m_historyMax;
    private int m_lines;
    private int m_truncated;
    private final long m_startTime;
    private static final long serialVersionUID = 0L;
    static final /* synthetic */ boolean $assertionsDisabled;

    public GtpShellText(int n, int n2, boolean bl, boolean bl2) {
        super(bl2);
        GuiUtils.setMonospacedFont(this.get());
        this.m_startTime = System.currentTimeMillis();
        this.m_timeStamp = bl;
        this.m_historyMin = n;
        this.m_historyMax = n2;
        this.setNoLineSpacing();
        this.addStyle("error", Color.red);
        this.addStyle("output", null, null, true);
        this.addStyle("log", new Color(0.5f, 0.5f, 0.5f));
        this.addStyle("time", new Color(0.0f, 0.0f, 0.5f));
        this.addStyle("invalid", Color.white, Color.red, false);
        this.get().setEditable(false);
    }

    public void appendComment(String string) {
        this.appendText(string, "log");
    }

    public void appendError(String string) {
        this.appendText(string, "error");
    }

    public void appendInput(String string) {
        this.appendTimeStamp();
        this.appendText(string, null);
    }

    public void appendInvalidResponse(String string) {
        this.appendText(string, "invalid");
    }

    public void appendLog(String string) {
        this.appendText(string, "log");
    }

    public void appendOutput(String string) {
        this.appendTimeStamp();
        this.appendText(string, "output");
    }

    public static int findTruncateIndex(String string, int n) {
        int n2 = 0;
        int n3 = 0;
        while ((n2 = string.indexOf(10, n2)) != -1) {
            ++n2;
            if (++n3 != n) continue;
            return n2;
        }
        return -1;
    }

    public int getLinesTruncated() {
        return this.m_truncated;
    }

    public String getLog() {
        Document document = this.getDocument();
        try {
            return document.getText(0, document.getLength());
        }
        catch (BadLocationException badLocationException) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return "";
        }
    }

    public void setPositionToEnd() {
        int n = this.getDocument().getLength();
        this.get().setCaretPosition(n);
    }

    public void setTimeStamp(boolean bl) {
        this.m_timeStamp = bl;
    }

    private void appendText(String string, String string2) {
        block7: {
            if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
                throw new AssertionError();
            }
            if (string.equals("")) {
                return;
            }
            int n = 0;
            while ((n = string.indexOf(10, n)) != -1) {
                ++this.m_lines;
                ++n;
            }
            Document document = this.getDocument();
            Style style = null;
            if (string2 != null) {
                style = this.getStyle(string2);
            }
            try {
                int n2 = document.getLength();
                document.insertString(n2, string, style);
                this.setPositionToEnd();
            }
            catch (BadLocationException badLocationException) {
                if ($assertionsDisabled) break block7;
                throw new AssertionError();
            }
        }
        if (this.m_lines > this.m_historyMax) {
            this.truncateHistory();
            this.setPositionToEnd();
        }
    }

    private void appendTimeStamp() {
        if (!this.m_timeStamp) {
            return;
        }
        long l = System.currentTimeMillis();
        double d = (float)(l - this.m_startTime) / 1000.0f;
        this.appendText(Clock.getTimeString(d, -1) + " ", "time");
    }

    private void truncateHistory() {
        block3: {
            int n = this.m_lines - this.m_historyMin;
            Document document = this.getDocument();
            try {
                String string = document.getText(0, document.getLength());
                int n2 = GtpShellText.findTruncateIndex(string, n);
                if (!$assertionsDisabled && n2 == -1) {
                    throw new AssertionError();
                }
                document.remove(0, n2);
                this.m_lines -= n;
                this.m_truncated += n;
            }
            catch (BadLocationException badLocationException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    static {
        $assertionsDisabled = !GtpShellText.class.desiredAssertionStatus();
    }
}

