/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.msvcpp.version;

import java.io.File;
import net.rubygrapefruit.platform.MissingRegistryEntryException;
import net.rubygrapefruit.platform.WindowsRegistry;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.version.VswhereVersionLocator;

public class DefaultVswhereVersionLocator
implements VswhereVersionLocator {
    private final WindowsRegistry windowsRegistry;
    private final OperatingSystem os;
    private static final String[] PROGRAM_FILES_KEYS = new String[]{"ProgramFilesDir", "ProgramFilesDir (x86)"};
    private static final String REGISTRY_PATH_WINDOWS = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion";
    private static final String VISUAL_STUDIO_INSTALLER = "Microsoft Visual Studio/Installer";
    private static final String VSWHERE_EXE = "vswhere.exe";

    public DefaultVswhereVersionLocator(WindowsRegistry windowsRegistry, OperatingSystem os) {
        this.windowsRegistry = windowsRegistry;
        this.os = os;
    }

    @Override
    public File getVswhereInstall() {
        for (String programFilesKey : PROGRAM_FILES_KEYS) {
            File programFilesDir;
            try {
                programFilesDir = new File(this.windowsRegistry.getStringValue(WindowsRegistry.Key.HKEY_LOCAL_MACHINE, REGISTRY_PATH_WINDOWS, programFilesKey));
            }
            catch (MissingRegistryEntryException e) {
                continue;
            }
            File candidate = new File(programFilesDir, "Microsoft Visual Studio/Installer/vswhere.exe");
            if (!candidate.exists() || !candidate.isFile()) continue;
            return candidate;
        }
        return this.os.findInPath(VSWHERE_EXE);
    }
}

