/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.agent;

import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Scheduler;
import org.apache.kafka.trogdor.agent.AgentRestResource;
import org.apache.kafka.trogdor.agent.WorkerManager;
import org.apache.kafka.trogdor.common.Node;
import org.apache.kafka.trogdor.common.Platform;
import org.apache.kafka.trogdor.rest.AgentStatusResponse;
import org.apache.kafka.trogdor.rest.CreateWorkerRequest;
import org.apache.kafka.trogdor.rest.CreateWorkerResponse;
import org.apache.kafka.trogdor.rest.JsonRestServer;
import org.apache.kafka.trogdor.rest.StopWorkerRequest;
import org.apache.kafka.trogdor.rest.StopWorkerResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Agent {
    private static final Logger log = LoggerFactory.getLogger(Agent.class);
    private final long serverStartMs;
    private final WorkerManager workerManager;
    private final JsonRestServer restServer;

    public Agent(Platform platform, Scheduler scheduler, JsonRestServer restServer, AgentRestResource resource) {
        this.serverStartMs = scheduler.time().milliseconds();
        this.workerManager = new WorkerManager(platform, scheduler);
        this.restServer = restServer;
        resource.setAgent(this);
    }

    public int port() {
        return this.restServer.port();
    }

    public void beginShutdown() throws Exception {
        this.restServer.beginShutdown();
        this.workerManager.beginShutdown();
    }

    public void waitForShutdown() throws Exception {
        this.restServer.waitForShutdown();
        this.workerManager.waitForShutdown();
    }

    public AgentStatusResponse status() throws Exception {
        return new AgentStatusResponse(this.serverStartMs, this.workerManager.workerStates());
    }

    public CreateWorkerResponse createWorker(CreateWorkerRequest req) throws Exception {
        this.workerManager.createWorker(req.id(), req.spec());
        return new CreateWorkerResponse(req.spec());
    }

    public StopWorkerResponse stopWorker(StopWorkerRequest req) throws Exception {
        return new StopWorkerResponse(this.workerManager.stopWorker(req.id()));
    }

    public static void main(String[] args) throws Exception {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)"trogdor-agent").defaultHelp(true).description("The Trogdor fault injection agent");
        parser.addArgument(new String[]{"--agent.config"}).action((ArgumentAction)Arguments.store()).required(true).type(String.class).dest("config").metavar(new String[]{"CONFIG"}).help("The configuration file to use.");
        parser.addArgument(new String[]{"--node-name"}).action((ArgumentAction)Arguments.store()).required(true).type(String.class).dest("node_name").metavar(new String[]{"NODE_NAME"}).help("The name of this node.");
        Namespace res = null;
        try {
            res = parser.parseArgs(args);
        }
        catch (ArgumentParserException e) {
            if (args.length == 0) {
                parser.printHelp();
                Exit.exit((int)0);
            }
            parser.handleError(e);
            Exit.exit((int)1);
        }
        String configPath = res.getString("config");
        String nodeName = res.getString("node_name");
        Platform platform = Platform.Config.parse(nodeName, configPath);
        JsonRestServer restServer = new JsonRestServer(Node.Util.getTrogdorAgentPort(platform.curNode()));
        AgentRestResource resource = new AgentRestResource();
        log.info("Starting agent process.");
        final Agent agent = new Agent(platform, Scheduler.SYSTEM, restServer, resource);
        restServer.start(resource);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                log.warn("Running agent shutdown hook.");
                try {
                    agent.beginShutdown();
                    agent.waitForShutdown();
                }
                catch (Exception e) {
                    log.error("Got exception while running agent shutdown hook.", (Throwable)e);
                }
            }
        });
        agent.waitForShutdown();
    }
}

