/*
 * Copyright (C) 1997-2004, R3vis Corporation.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA, or visit http://www.gnu.org/copyleft/lgpl.html.
 *
 * Original Contributor:
 *   Wes Bethel, R3vis Corporation, Marin County, California
 * Additional Contributor(s):
 *
 * The OpenRM project is located at http://openrm.sourceforge.net/.
 */
/*
 * $Id: rmw.h,v 1.6 2004/01/17 04:06:42 wes Exp $
 * Version: $Name: OpenRM-1-5-2-RC3 $
 * $Revision: 1.6 $
 * $Log: rmw.h,v $
 * Revision 1.6  2004/01/17 04:06:42  wes
 * Updated Copyright line for 2004.
 *
 * Revision 1.5  2003/10/03 19:16:17  wes
 * Unified naming changes - use rmPipeSet/GetContext rather than use
 * a platform-specific name.
 *
 * Revision 1.4  2003/03/16 21:56:24  wes
 * Documentation updates.
 *
 * Revision 1.3  2003/02/02 02:07:14  wes
 * Updated copyright to 2003.
 *
 * Revision 1.2  2003/02/01 17:56:13  wes
 * Win32 code work to reflect new RMpipe initialization sequence.
 *
 * Revision 1.1.1.1  2003/01/28 02:15:23  wes
 * Manual rebuild of rm150 repository.
 *
 * Revision 1.9  2002/12/31 00:56:21  wes
 * Cleaned up arch-specific portions of RMpipe to support Chromium.
 *
 * Revision 1.8  2002/04/30 19:42:33  wes
 * Updated copyright dates.
 *
 * Revision 1.7  2001/10/15 00:19:01  wes
 * Removed button definitions (moved to an rmaux include file). Added
 * the offscreen field to the Win32 RMpipe.
 *
 * Revision 1.6  2001/03/31 17:13:59  wes
 * v1.4.0-alpha-2 checkin
 *
 * Revision 1.5  2000/12/03 23:20:22  wes
 * Thread-safety mods.
 *
 * Revision 1.4  2000/05/14 23:36:12  wes
 * Added attrib to RMpipe to allow control over how the OpenGL
 * matrix stack is initialized during rendering.
 *
 * Revision 1.3  2000/04/20 17:41:46  wes
 * Minor CVS tag changes.
 *
 * Revision 1.2  2000/04/20 16:30:24  wes
 * Added copyright info.
 *
 * Revision 1.1.1.1  2000/02/28 21:29:40  wes
 * OpenRM 1.2 Checkin
 *
 * Revision 1.1.1.1  2000/02/28 17:18:48  wes
 * Initial entry - pre-RM120 release, source base for OpenRM 1.2.
 *
 */

#ifndef _rmw_h
#define _rmw_h


#ifdef __cplusplus
extern "C" {
#endif


/* rmw.c: Win32 windows, OGL, text [5] */
RM_EXPORT_API  RMenum rmPipeSetWindow (RMpipe *p, HWND hWnd, int width, int height);
RM_EXPORT_API  HWND   rmPipeGetWindow (RMpipe *p);
RM_EXPORT_API  void   rmwText  OGLPRIMPARMLIST() ;
RM_EXPORT_API  RMenum rmPipeSwapBuffersWin32 (const RMpipe *p);
RM_EXPORT_API  RMenum rmwPipeCreateContext(RMpipe *p);

RM_EXPORT_API  HGLRC  rmPipeGetContext(const RMpipe *p);
RM_EXPORT_API  RMenum rmPipeSetContext(RMpipe *p, HGLRC theContext);

/* can this routine be deleted? */
RM_EXPORT_API  HGLRC  rmwSetupOpenGL (HWND hWnd);
#ifdef __cplusplus
}
#endif

#endif /* _rmw_h */
/* EOF */
