/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.tables;

import java.io.DataOutput;
import java.io.IOException;
import java.io.UTFDataFormatException;

abstract class AbstractDataOutput
implements DataOutput {
    AbstractDataOutput() {
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.write(v);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeChars(String s) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeUTF(String str) throws IOException {
        char c;
        int i;
        int strlen = str.length();
        int utflen = 0;
        for (i = 0; i < strlen; ++i) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        if (utflen > 65535) {
            throw new UTFDataFormatException("encoded string too long: " + utflen + " bytes");
        }
        this.writeShort(utflen);
        for (i = 0; i < strlen && (c = str.charAt(i)) >= '\u0001' && c <= '\u007f'; ++i) {
            this.writeByte(c);
        }
        while (i < strlen) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                this.writeByte(c);
            } else if (c > '\u07ff') {
                this.writeByte(0xE0 | c >> 12 & 0xF);
                this.writeByte(0x80 | c >> 6 & 0x3F);
                this.writeByte(0x80 | c & 0x3F);
            } else {
                this.writeByte(0xC0 | c >> 6 & 0x1F);
                this.writeByte(0x80 | c & 0x3F);
            }
            ++i;
        }
    }
}

