/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.Sort;
import org.apache.solr.cloud.ActionThrottle;
import org.apache.solr.cloud.RecoveryStrategy;
import org.apache.solr.common.AlreadyClosedException;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.SolrCore;
import org.apache.solr.util.RefCounted;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SolrCoreState {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int PAUSE_UPDATES_TIMEOUT_MILLIS = Integer.getInteger("solr.cloud.wait-for-updates-on-shutdown-millis", 2500);
    protected boolean closed = false;
    private final Object updateLock = new Object();
    private final Object reloadLock = new Object();
    private final AtomicBoolean pauseUpdateRequests = new AtomicBoolean();
    private final Phaser inflightUpdatesCounter = new Phaser(){

        @Override
        protected boolean onAdvance(int phase, int registeredParties) {
            return false;
        }
    };
    private int solrCoreStateRefCnt = 1;

    public Object getUpdateLock() {
        return this.updateLock;
    }

    public Object getReloadLock() {
        return this.reloadLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increfSolrCoreState() {
        SolrCoreState solrCoreState = this;
        synchronized (solrCoreState) {
            if (this.solrCoreStateRefCnt == 0) {
                throw new CoreIsClosedException("IndexWriter has been closed");
            }
            ++this.solrCoreStateRefCnt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean decrefSolrCoreState(IndexWriterCloser closer) {
        boolean close = false;
        SolrCoreState solrCoreState = this;
        synchronized (solrCoreState) {
            --this.solrCoreStateRefCnt;
            assert (this.solrCoreStateRefCnt >= 0);
            if (this.solrCoreStateRefCnt == 0) {
                this.closed = true;
                close = true;
            }
        }
        if (close) {
            try {
                log.debug("Closing SolrCoreState");
                this.close(closer);
            }
            catch (Exception e) {
                log.error("Error closing SolrCoreState", (Throwable)e);
            }
        }
        return close;
    }

    public void pauseUpdatesAndAwaitInflightRequests() throws TimeoutException, InterruptedException {
        if (this.pauseUpdateRequests.compareAndSet(false, true)) {
            int arrivalNumber = this.inflightUpdatesCounter.register();
            assert (arrivalNumber >= 0) : "Registration of in-flight request should have succeeded but got arrival phase number < 0";
            this.inflightUpdatesCounter.awaitAdvanceInterruptibly(this.inflightUpdatesCounter.arrive(), PAUSE_UPDATES_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
        }
    }

    public boolean registerInFlightUpdate() {
        if (this.pauseUpdateRequests.get()) {
            return false;
        }
        this.inflightUpdatesCounter.register();
        return true;
    }

    public void deregisterInFlightUpdate() {
        int arrivalPhaseNumber = this.inflightUpdatesCounter.arriveAndDeregister();
        assert (arrivalPhaseNumber >= 0) : "inflightUpdatesCounter should not have been terminated";
    }

    public abstract Lock getCommitLock();

    public abstract void newIndexWriter(SolrCore var1, boolean var2) throws IOException;

    public abstract void closeIndexWriter(SolrCore var1, boolean var2) throws IOException;

    public abstract void openIndexWriter(SolrCore var1) throws IOException;

    public abstract RefCounted<IndexWriter> getIndexWriter(SolrCore var1) throws IOException;

    public abstract void rollbackIndexWriter(SolrCore var1) throws IOException;

    public abstract Sort getMergePolicySort() throws IOException;

    public abstract DirectoryFactory getDirectoryFactory();

    public abstract RecoveryStrategy.Builder getRecoveryStrategyBuilder();

    public abstract void doRecovery(CoreContainer var1, CoreDescriptor var2);

    public abstract void cancelRecovery();

    public abstract void close(IndexWriterCloser var1);

    public abstract ActionThrottle getLeaderThrottle();

    public abstract boolean getLastReplicateIndexSuccess();

    public abstract void setLastReplicateIndexSuccess(boolean var1);

    public abstract Lock getRecoveryLock();

    public abstract boolean getCdcrBootstrapRunning();

    public abstract void setCdcrBootstrapRunning(boolean var1);

    public abstract Future<Boolean> getCdcrBootstrapFuture();

    public abstract void setCdcrBootstrapFuture(Future<Boolean> var1);

    public abstract Callable getCdcrBootstrapCallable();

    public abstract void setCdcrBootstrapCallable(Callable var1);

    public Throwable getTragicException() throws IOException {
        RefCounted<IndexWriter> ref = this.getIndexWriter(null);
        if (ref == null) {
            return null;
        }
        try {
            Throwable throwable = ref.get().getTragicException();
            return throwable;
        }
        finally {
            ref.decref();
        }
    }

    public static class CoreIsClosedException
    extends AlreadyClosedException {
        public CoreIsClosedException() {
        }

        public CoreIsClosedException(String s) {
            super(s);
        }
    }

    public static interface IndexWriterCloser {
        public void closeWriter(IndexWriter var1) throws IOException;
    }
}

